/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ExternalTablePropsValidator
extends AbstractChildDBObjectValidator<OracleExternalTableProperties> {
    public ExternalTablePropsValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("projectColumn");
        retval.add("accessUsingClob");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"defaultDirectory"})
    public void validateDefaultDirectory(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        DBObjectID defDirID;
        String dirName;
        if (this.isKnownAccessDriverType(props) && !ModelUtil.hasLength((String)(dirName = DBUtil.getDBObjectName((DBObjectID)(defDirID = props.getDefaultDirectory()))))) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_DEFAULT_DIR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"locationSpecifiers"})
    public void validateLocationSpecifiers(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        OracleExternalTableProperties.LocationSpecifier[] locSpecs;
        if (this.isKnownAccessDriverType(props) && (locSpecs = props.getLocationSpecifiers()).length == 0) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_LOCATION"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"accessDriverType"}, level=ValidationLevel.FULL)
    public void validateAccessDriverType(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        DBObjectProvider pro = this.getProvider();
        if (!(pro != null && pro.getDescriptor().getDatabaseVersion() >= 120 || this.isKnownAccessDriverType(props))) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_ACCESS_DRIVER_TYPE"));
        }
    }

    private boolean isKnownAccessDriverType(OracleExternalTableProperties props) {
        String type = props.getAccessDriverType();
        return type == null || type.equals("ORACLE_LOADER") || type.equals("ORACLE_DATAPUMP");
    }

    @DBObjectValidator.PropertyValidator(value={"accessParameters"})
    @DBObjectValidator.PropertyDependency(value={"accessUsingClob", "accessDriverType"})
    public void validateAccessParameters(ValidationContext<OracleExternalTableProperties> context) throws ValidationException {
        String driver;
        OracleExternalTableProperties props = (OracleExternalTableProperties)context.getUpdatedObject();
        String accessParams = props.getAccessParameters();
        if (!ModelUtil.hasLength((String)accessParams)) {
            if (props.isAccessUsingClob()) {
                throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MUST_BE_SUBQUERY"));
            }
        } else if (context.getLevel() == ValidationLevel.FULL && BigDataAccessParameterMetadata.isBigDataAccessDriver((String)(driver = props.getAccessDriverType()))) {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)props);
            SQLFragment frag = props.getAccessParametersFragment();
            if (frag instanceof BigDataAccessParameters) {
                ArrayList<String> invalid = new ArrayList<String>();
                Collection allowed = BigDataAccessParameterMetadata.getAllowedParameterNames((String)driver);
                for (BigDataAccessParameter param : ((BigDataAccessParameters)frag).getBigDataAccessParameters()) {
                    String name = param.getName();
                    if (allowed.contains(name) || BigDataAccessParameterMetadata.isAdditionalAccessParameter((String)name)) continue;
                    invalid.add(name);
                }
                if (!invalid.isEmpty()) {
                    throw new ValidationException((DBObject)props, APIBundle.format((String)"EXTERNAL_TABLE_PROPERTY_INVALID_PARAMS", (Object[])new Object[]{driver, invalid}));
                }
            } else {
                throw new ValidationException((DBObject)props, APIBundle.format((String)"EXTERNAL_TABLE_PROPERTY_INVALID_PARAM_FORMAT", (Object[])new Object[]{driver}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"rejectLimit"}, level=ValidationLevel.FULL)
    public void validateRejectLimit(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        Integer rl = props.getRejectLimit();
        if (rl != null && rl < 0 && rl != -1) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_REJECT_LIMIT"));
        }
    }
}

