/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.ora.sxml.SXMLCommentGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SXMLGenerator
extends SXMLFragmentGenerator {
    private static final String SXML_VERSION_1 = "1.0";
    protected static final String SXML_VERSION_CURRENT = "1.0";
    private DBObject m_obj;
    private static SXMLCommentGenerator s_commGen;

    public SXMLGenerator() {
        this(new SXMLMappings());
    }

    SXMLGenerator(SXMLMappings mappings) {
        super.setMappings(mappings);
    }

    public final boolean canGenerate(DBObject obj) {
        return this.canGenerate(obj.getType());
    }

    public final boolean canGenerate(String type) {
        return this.getMappings().hasMappings(type) || this.getMappings().getGenerators(type) != null;
    }

    public final void addMapping(String type, String elementPath, String propertyPath, SXMLValueConverter con) {
        this.getMappings().cache(type, elementPath, propertyPath, con);
    }

    public final void removeMapping(String type, String elementPath, String propertyPath) {
        this.getMappings().uncache(type, elementPath, propertyPath);
    }

    public final void addGenerator(String type, Class<? extends SXMLFragmentGenerator> gen) {
        this.getMappings().registerGen(type, gen);
    }

    public final Document generateSXML(DBObject obj) {
        XMLDocument doc = new XMLDocument();
        this.m_obj = obj;
        String type = this.getType(obj);
        doc.setEncoding("UTF-8");
        if (obj instanceof Table && (this.alwaysUseComposite() || ((Table)obj).getIndexes() != null && ((Table)obj).getIndexes().length > 0)) {
            this.populateCompositeDocForTable(doc, (Table)obj, type);
            type = "COMPOSITE";
        } else {
            this.populateDoc(doc, obj, type);
        }
        XMLSchema schema = this.getMappings().getXSD(type);
        if (schema != null) {
            doc.setSchema(schema);
        }
        for (SXMLCommentGenerator commGen : this.getCommentGenerators()) {
            String[] comments;
            for (String com : comments = commGen.getComments(obj)) {
                Comment c = doc.createComment(com);
                doc.insertBefore((Node)c, (Node)doc.getDocumentElement());
            }
        }
        return doc;
    }

    public final boolean alwaysUseComposite() {
        return false;
    }

    public boolean isBuildParsedSQL() {
        return false;
    }

    private void populateDoc(XMLDocument doc, DBObject obj, String type) {
        Element node = doc.createElementNS("http://xmlns.oracle.com/ku", this.getMappings().getNodeName(type));
        node.setAttribute("version", "1.0");
        this.populateNode(node, (Document)doc, obj);
        doc.appendChild((Node)node);
    }

    private void populateCompositeDocForTable(XMLDocument doc, Table tab, String type) {
        Element composite = doc.createElementNS("http://xmlns.oracle.com/ku", "COMPOSITE");
        composite.setAttribute("version", "1.0");
        doc.appendChild((Node)composite);
        Element baseObject = doc.createElementNS("http://xmlns.oracle.com/ku", "BASE_OBJECT");
        composite.appendChild(baseObject);
        Element indexList = doc.createElementNS("http://xmlns.oracle.com/ku", "INDEX_LIST");
        composite.appendChild(indexList);
        Element node = doc.createElementNS("http://xmlns.oracle.com/ku", type.replaceAll(" ", "_"));
        this.populateNode(node, (Document)doc, tab);
        baseObject.appendChild(node);
        node.setAttribute("version", "1.0");
        for (Index index : tab.getIndexes()) {
            Element indexNode = doc.createElementNS("http://xmlns.oracle.com/ku", "INDEX");
            this.populateNode(indexNode, (Document)doc, index);
            indexNode.setAttribute("version", "1.0");
            indexList.appendChild(indexNode);
        }
    }

    @Override
    protected final void populateNode(Node objNode, Document doc, Object obj) {
        String type = this.getType(obj);
        this.populateNodeImpl(objNode, doc, obj, type);
    }

    void populateNodeImpl(Node objNode, Document doc, Object obj, String type) {
        Iterator<SXMLMappings.Mapping> maps = this.getMappings().getMappings(type);
        while (maps.hasNext()) {
            SXMLMappings.Mapping map = maps.next();
            this.processPropertyMapping(objNode, doc, obj, map);
        }
        Iterator<Class<? extends SXMLFragmentGenerator>> gens = this.getMappings().getGenerators(type);
        if (gens != null) {
            while (gens.hasNext()) {
                try {
                    SXMLFragmentGenerator gen = gens.next().newInstance();
                    gen.setParentGenerator(this);
                    gen.populateNode(objNode, doc, obj);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    String getTopLevelObjectSchemaName() {
        String retval = null;
        if (this.m_obj instanceof SchemaObject && ((SchemaObject)this.m_obj).getSchema() != null) {
            retval = ((SchemaObject)this.m_obj).getSchema().getName();
        }
        return retval;
    }

    @Override
    protected final void readNode(Node parent, Object obj) {
    }

    private List<SXMLCommentGenerator> getCommentGenerators() {
        ArrayList<SXMLCommentGenerator> retval = new ArrayList<SXMLCommentGenerator>();
        DBCore.getInstance().populateFactoryList(SXMLCommentGenerator.class, retval);
        if (s_commGen != null) {
            retval.add(s_commGen);
        }
        return retval;
    }

    @Deprecated
    public static void setCommentGenerator(SXMLCommentGenerator commGen) {
        s_commGen = commGen;
    }
}

