/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class SingleColumnForLoopBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        ModelObject.SingleColumnForLoop retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(node, "single_column_for_loop")) {
            ModelObject.SingleColumnForLoop singleColumnForLoop = new ModelObject.SingleColumnForLoop();
            List<ParseNode> kids = helper.getOrderedChildren(node);
            String measureColumn = helper.getContent(kids.get(0));
            String dimensionColumn = helper.getContent(kids.get(1));
            singleColumnForLoop.setDimensionColumn(dimensionColumn);
            if (helper.isKeyword(kids.get(2), "IN")) {
                SQLFragment[] inArgs = context.getArgList(null, node);
                ExpressionList inExpressionList = new ExpressionList(inArgs);
                singleColumnForLoop.setInExpressionList(inExpressionList);
            } else {
                int i = 2;
                if (helper.isKeyword(kids.get(i), "LIKE")) {
                    String pattern = helper.getContent(kids.get(i + 1));
                    i += 2;
                    singleColumnForLoop.setLikePattern(pattern);
                }
                String fromLiteral = helper.getContent(kids.get(i + 1));
                singleColumnForLoop.setFromLiteral(fromLiteral);
                String toLiteral = helper.getContent(kids.get(i + 3));
                singleColumnForLoop.setToLiteral(toLiteral);
                String literal = helper.getContent(kids.get(i + 5));
                if (helper.isKeyword(kids.get(i + 4), "INCREMENT")) {
                    singleColumnForLoop.setIncrementLiteral(literal);
                } else {
                    singleColumnForLoop.setDecrementLiteral(literal);
                }
            }
            retval = singleColumnForLoop;
        }
        return retval;
    }
}

