/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class ArithmeticOperationBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        SQLFragment retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        if (helper.isRule(node, "expr", "compound_expression") || kids.size() == 2 && helper.isOperation(kids.get(0))) {
            SQLFragment creating = context.getCreating();
            Object queryContext = context.getQueryContext();
            if (kids.size() == 4 && helper.isKeyword(kids.get(1), "|") && helper.isKeyword(kids.get(2), "|")) {
                SQLFragment left = context.createFragment(kids.get(0), creating, queryContext);
                SQLFragment right = context.createFragment(kids.get(3), creating, queryContext);
                SQLFragment[] argsL = new SQLFragment[]{left, right};
                String source = "||";
                BuiltInFunction func = null;
                DatabaseDescriptor desc = context.getProvider().getDescriptor();
                Iterator iterator = desc.listBuiltInFunctions("CONCAT").iterator();
                if (iterator.hasNext()) {
                    BuiltInFunction bif;
                    func = bif = (BuiltInFunction)iterator.next();
                }
                retval = context.createFunction(source, func, null, false, argsL);
            } else if (kids.size() == 3) {
                if (helper.isKeyword(kids.get(0), "(")) {
                    retval = context.createFragment(kids.get(1), creating, queryContext);
                } else if (helper.isLeaf(kids.get(1))) {
                    ParseNode operatorNode = kids.get(1);
                    if (!helper.isLeaf(operatorNode)) {
                        throw new SQLQueryException(context.getQueryBuilder().buildErrorMessage(operatorNode, APIBundle.get((String)"SQL_RQB_OPERATOR_EXPECTED")));
                    }
                    SQLFragment left = context.createFragment(kids.get(0), creating, queryContext);
                    SQLFragment right = context.createFragment(kids.get(2), creating, queryContext);
                    String operator = helper.getContent(operatorNode).toUpperCase();
                    ArithmeticOperation.ArithmeticOperator type = ArithmeticOperation.getArithmeticOperator((String)operator, (int)2);
                    if (type != null) {
                        retval = new ArithmeticOperation(type, new SQLFragment[]{left, right});
                    }
                }
            } else if (kids.size() == 2 && helper.isLeaf(kids.get(0))) {
                ParseNode operatorNode = kids.get(0);
                if (!helper.isLeaf(operatorNode)) {
                    throw new SQLQueryException("Operator expected");
                }
                SQLFragment operand = context.createFragment(kids.get(1), creating, queryContext);
                String operator = helper.getContent(operatorNode);
                Comparison.Comparator comp = Comparison.getComparator((String)operator);
                if (comp != null) {
                    retval = new Comparison(operand, comp, null);
                } else {
                    ArithmeticOperation.ArithmeticOperator op = ArithmeticOperation.getArithmeticOperator((String)operator, (int)1);
                    if (op != null) {
                        retval = new ArithmeticOperation(op, new SQLFragment[]{operand});
                    } else {
                        throw new SQLQueryException(APIBundle.format((String)"SQL_UNRECOGNISED_OPERATOR", (Object[])new Object[]{operator}));
                    }
                }
            }
        }
        return retval;
    }
}

