/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.javatools.db.Relation;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.owb.OMBPropertyKey;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropertyValidator;
import oracle.javatools.db.property.PropertyHelper;

abstract class OMBPropsStatementBuilder {
    private TreeMap<OMBPropertyKey, Object> m_mappings;
    private HashMap<String, HashMap<String, String>> m_substitutes;
    private HashMap<String, OMBPropertyValidator> m_propValidators;
    private StringBuffer m_propertyNames = new StringBuffer();
    private StringBuffer m_propertyValues = new StringBuffer();
    private Object m_ctxtObject = null;
    private String m_mapPath = "";
    public final String SET_PROPERTIES = "SET PROPERTIES \\\n(";
    public final String SEPARATOR = ", ";
    public final String VALUES = ") \\\nVALUES \\\n(";
    public final String END_BRACKET = ") \\";
    public final String DEFAULT = "$DEFAULT$";
    public final String IGNORE = "$IGNORE$";

    OMBPropsStatementBuilder() {
    }

    public abstract void registerPropertyMappings();

    public void setContextObject(Object ctxtObject) {
        this.m_ctxtObject = ctxtObject;
    }

    public void setMapPath(String mapPath) {
        this.m_mapPath = mapPath;
    }

    public void buildSetProperties() {
        boolean firstMatch = true;
        String propName = null;
        String propValue = null;
        PropertyHelper ph = new PropertyHelper();
        for (OMBPropertyKey mapKey : this.m_mappings.keySet()) {
            Object mapValue = this.m_mappings.get(mapKey);
            Object propVal = ph.getPropertyValue(this.m_ctxtObject, mapKey.getKey());
            if (propVal == null) continue;
            if (mapValue instanceof String[]) {
                for (int i = 0; i < ((String[])mapValue).length; ++i) {
                    propName = ((String[])mapValue)[i];
                    propValue = propVal.toString();
                    firstMatch = this.appendProperty(propName, propValue, firstMatch);
                }
            } else if (mapValue instanceof OMBPropertyResolver) {
                OMBPropertyResolver resolver = (OMBPropertyResolver)mapValue;
                propName = resolver.resolvePropertyName();
                propValue = resolver.resolvePropertyValue();
                if (propName != null && propValue != null) {
                    firstMatch = this.appendProperty(propName, propValue, firstMatch);
                }
            } else {
                propName = (String)this.m_mappings.get(mapKey);
                propValue = propVal.toString();
                firstMatch = this.appendProperty(propName, propValue, firstMatch);
            }
            this.validateProperty(propName, propValue);
        }
    }

    private boolean appendProperty(String propName, String propValue, boolean firstMatch) {
        if (!(propValue = this.applySubstitutions(propName, propValue)).equals("$IGNORE$")) {
            if (!firstMatch) {
                this.m_propertyNames.append(", ");
                this.m_propertyValues.append(", ");
            } else {
                firstMatch = false;
            }
            this.m_propertyNames.append(propName);
            this.m_propertyValues.append("'");
            this.m_propertyValues.append(propValue);
            this.m_propertyValues.append("'");
        }
        return firstMatch;
    }

    public String getPropertiesStatement() {
        StringBuffer setPropsBuff = new StringBuffer();
        if (this.m_propertyNames.length() > 0) {
            setPropsBuff.append("SET PROPERTIES \\\n(");
            setPropsBuff.append(this.m_propertyNames.toString());
            setPropsBuff.append(") \\\nVALUES \\\n(");
            setPropsBuff.append(this.m_propertyValues.toString());
            setPropsBuff.append(") \\");
            return setPropsBuff.toString();
        }
        return null;
    }

    public void registerPropertyMapping(String DBProperty, Object OMBProperty) {
        this.registerPropertyMapping(DBProperty, 99, OMBProperty);
    }

    public void registerPropertyMapping(String DBProperty, int position, Object OMBProperty) {
        if (this.m_mappings == null) {
            this.m_mappings = new TreeMap(new PropertyComparator());
        }
        OMBPropertyKey propKey = new OMBPropertyKey(DBProperty, position);
        this.m_mappings.put(propKey, OMBProperty);
    }

    public void registerSubstitutionValues(String propName, HashMap<String, String> substitutes) {
        if (this.m_substitutes == null) {
            this.m_substitutes = new HashMap();
        }
        this.m_substitutes.put(propName, substitutes);
    }

    public void registerPropertyValidator(String propName, OMBPropertyValidator validator) {
        if (this.m_propValidators == null) {
            this.m_propValidators = new HashMap();
        }
        this.m_propValidators.put(propName, validator);
    }

    protected String applySubstitutions(String propName, String propVal) {
        if (this.m_substitutes != null && this.m_substitutes.keySet().contains(propName)) {
            HashMap<String, String> subPairs = this.m_substitutes.get(propName);
            String subVal = subPairs.get(propVal);
            if (subVal == null && (subVal = subPairs.get("$DEFAULT$")) == null) {
                return propVal;
            }
            return subVal;
        }
        return propVal;
    }

    private void validateProperty(String propName, String propValue) {
        OMBPropertyValidator opv;
        if (this.m_propValidators != null && this.m_propValidators.keySet().contains(propName) && (opv = this.m_propValidators.get(propName)) != null) {
            opv.validateProperty(propName, propValue);
        }
    }

    public Object getContextObject() {
        return this.m_ctxtObject;
    }

    public String getMapPath() {
        return this.m_mapPath;
    }

    private class PropertyComparator
    implements Comparator {
        private PropertyComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof OMBPropertyKey && o2 instanceof OMBPropertyKey) {
                OMBPropertyKey a = (OMBPropertyKey)o1;
                OMBPropertyKey b = (OMBPropertyKey)o2;
                String s1 = a.getPosition() + a.getKey();
                String s2 = b.getPosition() + b.getKey();
                return s1.compareTo(s2);
            }
            return 0;
        }
    }

    public final class OMBViewQueryPropResolver
    extends OMBPropertyResolver {
        Relation m_view = null;

        public OMBViewQueryPropResolver(Relation view) {
            this.m_view = view;
        }

        @Override
        public String resolvePropertyValue() {
            String viewText = null;
            viewText = this.m_view instanceof View ? ((View)this.m_view).getViewText() : ((MaterializedView)this.m_view).getSQLQuery().getSQLText();
            StringTokenizer st = new StringTokenizer(viewText, "\n");
            StringBuffer query = new StringBuffer();
            while (st.hasMoreTokens()) {
                query.append(st.nextToken());
                query.append("\\n\\\n");
            }
            return query.toString().trim().replaceAll("'", "''");
        }

        @Override
        public String resolvePropertyName() {
            return "VIEW_QUERY";
        }
    }
}

