/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;

class OMBIndexPartitioningPropsBuilder
extends OMBPropsStatementBuilder {
    public OMBIndexPartitioningPropsBuilder(Object forOtp) {
        this.setContextObject(forOtp);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        this.registerPropertyMapping("partitionType", new OMBIndexPartitionTypePropResolver((OracleIndexPartitions)this.getContextObject()));
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("GLOBAL_RANGE", "RANGE");
        typeMap.put("GLOBAL_HASH", "HASH");
        typeMap.put("LOCAL_HASH", "HASH");
        this.registerSubstitutionValues("TYPE", typeMap);
        this.registerPropertyMapping("globalHashQuantity", "HASH_QUANTITY");
    }

    public final class OMBIndexPartitionTypePropResolver
    extends OMBPropertyResolver {
        OracleIndexPartitions m_oip = null;

        public OMBIndexPartitionTypePropResolver(OracleIndexPartitions otp) {
            this.m_oip = otp;
        }

        @Override
        public String resolvePropertyValue() {
            if (this.m_oip.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH) && this.m_oip.getGlobalHashQuantity() != null) {
                return "HASH BY QUANTITY";
            }
            return this.m_oip.getPartitionType().toString();
        }

        @Override
        public String resolvePropertyName() {
            return "TYPE";
        }
    }
}

