/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataFieldsBuilder;
import oracle.javatools.db.ora.bigdata.BigDataJsonValueBuilder;
import oracle.javatools.db.ora.bigdata.BigDataTablePropertiesBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class BigDataAccessParameterBuilder
extends DerivedPropertyBuilder<BigDataAccessParameter> {
    private final Map<String, ValueBuilder> m_builders = new HashMap<String, ValueBuilder>();

    public BigDataAccessParameterBuilder(AbstractDBObjectProvider pro) {
        super(pro, "BigDataAccessParameter");
        BigDataJsonValueBuilder jsonBuilder = new BigDataJsonValueBuilder();
        this.m_builders.put("com.oracle.bigdata.colmap", jsonBuilder);
        this.m_builders.put("com.oracle.bigdata.datemask", jsonBuilder);
        this.m_builders.put("com.oracle.bigdata.maxlen", jsonBuilder);
        this.m_builders.put("com.oracle.bigdata.overflow", jsonBuilder);
        this.m_builders.put("com.oracle.bigdata.erroropt", jsonBuilder);
        this.m_builders.put("com.oracle.bigdata.fields", new BigDataFieldsBuilder());
        this.m_builders.put("com.oracle.bigdata.tblproperties", new BigDataTablePropertiesBuilder());
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"parameterValueFragment"})
    public void buildValue(BigDataAccessParameter param) throws DBException {
        ValueBuilder builder;
        String name = param.getName();
        if (ModelUtil.hasLength((String)param.getParameterValue()) && (builder = this.m_builders.get(name)) != null) {
            builder.buildFragment(param);
        }
    }

    static abstract class ValueBuilder {
        ValueBuilder() {
        }

        public abstract void buildFragment(BigDataAccessParameter var1) throws DBException;

        protected final int findMatchingSingleQuote(BigDataAccessParameter param, String value, int i) throws DBException {
            int end = value.indexOf(39, i + 1);
            if (end <= 0) {
                throw new DBException((DBObject)param, APIBundle.format((String)"EXTERNAL_TABLE_BD_FIELDS_UNMATCHED", (Object[])new Object[]{Character.valueOf('\'')}));
            }
            return end;
        }

        protected final int findMatchingDoubleQuote(BigDataAccessParameter param, String value, int i) throws DBException {
            int end = -1;
            for (int i2 = i + 1; i2 < value.length(); ++i2) {
                char c2 = value.charAt(i2);
                if (c2 != '\"') continue;
                if (value.charAt(i2 - 1) != '\\') {
                    // empty if block
                }
                end = i2;
                break;
            }
            if (end <= 0) {
                throw new DBException((DBObject)param, APIBundle.format((String)"EXTERNAL_TABLE_BD_FIELDS_UNMATCHED", (Object[])new Object[]{Character.valueOf('\"')}));
            }
            return end;
        }

        protected final String stripAndTrimParentheses(String value) {
            if (ModelUtil.hasLength((String)value)) {
                boolean end;
                value = BigDataAccessParameterMetadata.stripLineEscapes((String)value).trim();
                int length = value.length();
                boolean start = value.charAt(0) == '(';
                boolean bl = end = value.charAt(length - 1) == ')';
                if (start || end) {
                    value = value.substring(start ? 1 : 0, end ? length - 1 : length);
                    value = value.trim();
                }
            }
            return value;
        }
    }
}

