/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public class ReferencePartitionHelper {
    public static final String PARTITION = "PARTITION";
    public static final String SUBPARTITION = "SUBPARTITION";

    public static Constraint getReferencedConstraint(OracleTablePartitions otp) {
        Constraint referencedCon = null;
        if (otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            Constraint refCon = ReferencePartitionHelper.resolveReferenceConstraintID(otp);
            try {
                FKConstraint fk;
                DBObjectID referenceId;
                if (refCon != null && refCon instanceof FKConstraint && (referenceId = (fk = (FKConstraint)refCon).getReferenceID()) != null) {
                    referencedCon = (Constraint)referenceId.resolveID();
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger().warning(dbe.getMessage());
            }
        }
        return referencedCon;
    }

    public static Table getReferencedTable(OracleTablePartitions otp) {
        DBObject parent;
        Table referencedTable = null;
        Constraint referencedCon = ReferencePartitionHelper.getReferencedConstraint(otp);
        if (referencedCon != null && (parent = referencedCon.getParent()) instanceof Table) {
            referencedTable = (Table)parent;
        }
        return referencedTable;
    }

    public static Constraint resolveReferenceConstraintID(OracleTablePartitions otp) {
        Constraint referenceConstraint = null;
        if (otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            Table table = (Table)otp.getParent();
            referenceConstraint = (Constraint)table.findOwnedObject(otp.getReferenceConstraintID(), true);
        }
        return referenceConstraint;
    }

    public static boolean isValidReferenceConstraintID(OracleTablePartitions otp, boolean allowNullReferenceTable) {
        boolean retval = false;
        if (otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            Table referenceTable = ReferencePartitionHelper.getReferencedTable(otp);
            if (referenceTable == null) {
                Constraint refCon;
                if (allowNullReferenceTable && (refCon = ReferencePartitionHelper.resolveReferenceConstraintID(otp)) != null && refCon instanceof FKConstraint) {
                    retval = true;
                }
            } else if (referenceTable != otp.getParent() && referenceTable.getProperty("PARTITIONED TABLE") != null) {
                retval = true;
            }
        }
        return retval;
    }

    public static int getReferencedTablePartitionsCount(Table refTable) {
        OracleTablePartitions refOtp = (OracleTablePartitions)refTable.getProperty("OracleTablePartitions");
        return ReferencePartitionHelper.getReferencedTablePartitionsCount(refOtp);
    }

    public static int getReferencedTablePartitionsCount(OracleTablePartitions refOtp) {
        int partitionsCount = 0;
        if (refOtp != null) {
            Table refTable;
            Object hashQuantity;
            boolean hasSubParts;
            TablePartition[] refPartitions = refOtp.getPartitions();
            boolean bl = hasSubParts = refOtp.getSubpartitionModel() != null;
            if (refPartitions.length == 0 && refOtp.getPartitionType() == OracleTablePartitions.PartitionType.HASH && (hashQuantity = refOtp.getHashQuantity()) != null && (Integer)hashQuantity > 0) {
                partitionsCount += ((Integer)hashQuantity).intValue();
            }
            for (TablePartition partition : refPartitions) {
                if (hasSubParts) {
                    partitionsCount += ReferencePartitionHelper.getSubPartitionsCount(partition);
                    continue;
                }
                ++partitionsCount;
            }
            if (partitionsCount == 0 && (refTable = ReferencePartitionHelper.getReferencedTable(refOtp)) != null && refOtp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
                partitionsCount = ReferencePartitionHelper.getReferencedTablePartitionsCount(refTable);
            }
        }
        return partitionsCount;
    }

    public static int getSubPartitionsCount(TablePartition partition) {
        int partitionsCount = 0;
        if (partition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION) {
            OracleTablePartitions parts = (OracleTablePartitions)partition.getParent();
            OracleTablePartitions subPartsModel = parts.getSubpartitionModel();
            boolean hasSubParts = subPartsModel != null;
            OracleTablePartitions subparts = partition.getPartitionLevelSubpartitions();
            if (hasSubParts) {
                TablePartition[] subpartitions;
                if (subparts == null) {
                    subparts = subPartsModel;
                }
                if ((subpartitions = subparts.getPartitions()).length == 0) {
                    int numOfSubParts = subPartsModel.getPartitions().length;
                    if (numOfSubParts < 1) {
                        numOfSubParts = 1;
                    }
                    if (subparts.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                        Integer hashQuantity = subparts.getHashQuantity();
                        if (hashQuantity == null) {
                            hashQuantity = subPartsModel.getHashQuantity();
                        }
                        if (hashQuantity != null && hashQuantity > 0) {
                            numOfSubParts = hashQuantity;
                        }
                    }
                    partitionsCount += numOfSubParts;
                } else {
                    partitionsCount += subpartitions.length;
                }
            }
        }
        return partitionsCount;
    }

    public static Collection<TablePartition> getReferenceTablePartitions(Table referenceTable, boolean copyParentPartition) {
        Collection<Object> referencePartitions = new ArrayList();
        if (referenceTable == null) {
            referencePartitions = Collections.emptyList();
        } else {
            OracleTablePartitions refOtp = (OracleTablePartitions)referenceTable.getProperty("OracleTablePartitions");
            if (refOtp != null) {
                boolean hasSubParts;
                TablePartition[] refPartitions = refOtp.getPartitions();
                boolean bl = hasSubParts = refOtp.getSubpartitionModel() != null;
                if (refPartitions.length == 0 && refOtp.getPartitionType() == OracleTablePartitions.PartitionType.HASH && refOtp.getHashQuantity() != null && refOtp.getHashQuantity() > 0) {
                    for (int i = 1; i <= refOtp.getHashQuantity(); ++i) {
                        String partitionName = PARTITION + i;
                        referencePartitions.add(ReferencePartitionHelper.createReferencePartition(null, partitionName, copyParentPartition));
                    }
                }
                for (TablePartition partition : refPartitions) {
                    if (hasSubParts) {
                        TablePartition[] subpartitions;
                        OracleTablePartitions partLevelSubparts = partition.getPartitionLevelSubpartitions();
                        OracleTablePartitions refSubsOtp = partLevelSubparts;
                        if (refSubsOtp == null) {
                            refSubsOtp = refOtp.getSubpartitionModel();
                        }
                        if ((subpartitions = refSubsOtp.getPartitions()).length == 0) {
                            int numOfSubParts = refOtp.getSubpartitionModel().getPartitions().length;
                            if (numOfSubParts < 1) {
                                numOfSubParts = 1;
                            }
                            if (refSubsOtp.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                                Integer hashQuantity = refSubsOtp.getHashQuantity();
                                if (hashQuantity == null && partLevelSubparts != null) {
                                    hashQuantity = refOtp.getSubpartitionModel().getHashQuantity();
                                }
                                if (hashQuantity != null && hashQuantity > 0) {
                                    numOfSubParts = hashQuantity;
                                }
                            }
                            for (int i = 1; i <= numOfSubParts; ++i) {
                                String partitionName = partition.getName() + "_" + SUBPARTITION + i;
                                referencePartitions.add(ReferencePartitionHelper.createReferencePartition(null, partitionName, copyParentPartition));
                            }
                        }
                        for (TablePartition subpartition : subpartitions) {
                            String partitionName = partition.getName() + "_" + subpartition.getName();
                            if (subpartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                                partitionName = subpartition.getName();
                            }
                            referencePartitions.add(ReferencePartitionHelper.createReferencePartition(subpartition, partitionName, copyParentPartition));
                        }
                        continue;
                    }
                    referencePartitions.add(ReferencePartitionHelper.createReferencePartition(partition, partition.getName(), copyParentPartition));
                }
                if ((refPartitions == null || refPartitions.length == 0) && refOtp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
                    referenceTable = ReferencePartitionHelper.getReferencedTable(refOtp);
                    referencePartitions = ReferencePartitionHelper.getReferenceTablePartitions(referenceTable, copyParentPartition);
                }
            }
        }
        return referencePartitions;
    }

    public static TablePartition createReferencePartition(TablePartition partition, String name, boolean copyParentPartition) {
        TablePartition tp;
        if (partition != null && copyParentPartition) {
            tp = (TablePartition)partition.copyTo(null);
            tp.setValues(new Object[0]);
        } else {
            tp = new TablePartition(name);
        }
        tp.setName(name);
        tp.setPartitionType(OracleTablePartitions.PartitionType.REFERENCE);
        tp.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
        tp.setParent(null);
        return tp;
    }
}

