/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class OracleTablePartitionsBuilder
extends OracleDBObjectBuilder<OracleTablePartitions> {
    public OracleTablePartitionsBuilder(BaseOracleDatabase db) {
        super(db, "PARTITION MODEL");
    }

    private Table getTable(DBObject obj) {
        return (Table)DBUtil.findParentOfType((DBObject)obj, Table.class);
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"partitionColumns"})
    public void fillInPartitionColumns(OracleTablePartitions otp) throws DBException {
        Table table;
        if (otp.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION && (table = this.getTable((DBObject)otp)) != null) {
            QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, "select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_COLUMNS_QUERY*/\n       COLUMN_NAME\nfrom   SYS.ALL_SUBPART_KEY_COLUMNS\nwhere  OWNER = ?\nand    NAME  = ?\norder by COLUMN_POSITION", table.getSchema(), table);
            final ArrayList colIDs = new ArrayList();
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException, SQLException {
                    while (rs.next()) {
                        Column col = table.getColumn(rs.getString(1));
                        if (col == null) continue;
                        colIDs.add(col.getID());
                    }
                }
            };
            wrap.executeQuery(r);
            otp.setPartitionColumns(colIDs.toArray(new DBObjectID[colIDs.size()]));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"partitions"})
    public void fillInPartitions(OracleTablePartitions partitions) throws DBException {
        Table table = this.getTable((DBObject)partitions);
        if (table != null) {
            OracleTablePartitions.ObjectType type = partitions.getObjectType();
            if (type == OracleTablePartitions.ObjectType.PARTITION) {
                this.fillInPartitions(table, partitions);
            } else if (type == OracleTablePartitions.ObjectType.SUBPARTITION) {
                this.fillInTemplates(table, partitions);
            }
        }
    }

    private void fillInPartitions(Table table, final OracleTablePartitions otp) throws DBException {
        final ArrayList partitions = new ArrayList();
        final BaseOracleDatabase db = this.getDatabase();
        QueryWrapper wrap2 = db.newQueryWrapper((SystemObject)table, this.getTablePartitionsQuery(table), table.getSchema(), OracleTableBuilder.getQueryObject(table));
        QueryWrapper.QueryRunnable r2 = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs2) throws DBException, SQLException {
                TablePartitionBuilder builder = new TablePartitionBuilder(db);
                while (rs2.next()) {
                    TablePartition partition = (TablePartition)OracleTablePartitionsBuilder.this.newObject(TablePartition.class, rs2.getString("PARTITION_NAME"));
                    db.setOracleBuilder(partition, builder);
                    partition.setObjectType(otp.getObjectType());
                    partition.setPartitionType(otp.getPartitionType());
                    partition.setID((DBObjectID)new NameBasedID((DBObject)partition, otp.getID()));
                    partitions.add(partition);
                    OracleTablePartitionsBuilder.this.initialisePartition(partition, rs2);
                }
            }
        };
        wrap2.executeQuery(r2);
        otp.setPartitions(partitions.toArray(new TablePartition[partitions.size()]));
    }

    private void fillInTemplates(Table table, final OracleTablePartitions otp) throws DBException {
        final ArrayList templates = new ArrayList();
        final BaseOracleDatabase db = this.getDatabase();
        QueryWrapper wrap = db.newQueryWrapper((SystemObject)table, "select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_TEMPLATES_QUERY*/\n       SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_BOUND\nfrom   SYS.ALL_SUBPARTITION_TEMPLATES\nwhere  /**/USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_POSITION", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException, SQLException {
                TablePartitionBuilder builder = new TablePartitionBuilder(db);
                while (rs.next()) {
                    String name = rs.getString("SUBPARTITION_NAME");
                    TablePartition template = (TablePartition)OracleTablePartitionsBuilder.this.newObject(TablePartition.class, name);
                    db.setOracleBuilder(template, builder);
                    template.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
                    template.setPartitionType(otp.getPartitionType());
                    template.setID((DBObjectID)new NameBasedID((DBObject)template, otp.getID()));
                    String values = rs.getString("HIGH_BOUND");
                    if (values != null && !rs.wasNull()) {
                        template.setValues(values);
                    }
                    OracleTablePartitionsBuilder.this.fillInTablespace(template, rs);
                    templates.add(template);
                }
            }
        };
        wrap.executeQuery(r);
        if (!templates.isEmpty()) {
            otp.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
            otp.setPartitions(templates.toArray(new TablePartition[templates.size()]));
        }
    }

    private void fillInPartitionLOBs(final Table table, final OracleTablePartitions otp, String query) throws DBException {
        final MultiMap map = new MultiMap(IdentityHashMap.class, ArrayList.class);
        QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, query, table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException, SQLException {
                while (rs.next()) {
                    String tablespaceName;
                    Column col = table.getColumn(rs.getString("COLUMN_NAME"));
                    if (col == null) continue;
                    TablePartition tp = OracleTablePartitionsBuilder.this.findTablePartition(rs.getString("NAME"), otp);
                    LOBDescriptor lobDescriptor = new LOBDescriptor();
                    lobDescriptor.addColumn(col.getID());
                    lobDescriptor.setLOBSegName(rs.getString("LOB_SEGMENT_NAME"));
                    if (tp.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && tp.getPartitionType() != OracleTablePartitions.PartitionType.HASH) {
                        int chunk = rs.getInt("CHUNK");
                        lobDescriptor.setChunk(rs.wasNull() ? null : Integer.valueOf(chunk));
                        int pctVersion = rs.getInt("PCTVERSION");
                        lobDescriptor.setPctVersion(rs.wasNull() ? null : Integer.valueOf(pctVersion));
                        lobDescriptor.setStorageInRow(Boolean.valueOf("YES".equalsIgnoreCase(rs.getString("IN_ROW"))));
                        OracleTableBuilder.setLOBCache(lobDescriptor, rs.getString("CACHE"));
                        OracleStorageProperties storage = OracleTableBuilder.getStorageProperties(rs);
                        OracleTableBuilder.setLogging(rs, storage);
                        lobDescriptor.setStorage(storage);
                    }
                    DBObjectID tablespaceID = ModelUtil.hasLength((String)(tablespaceName = rs.getString("TABLESPACE_NAME"))) ? OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleTablePartitionsBuilder.this.getDatabase(), tablespaceName) : null;
                    OracleTablePartitionsBuilder.this.getOrCreateStorage(lobDescriptor).setTablespaceID(tablespaceID);
                    lobDescriptor.setID((DBObjectID)new NameBasedID((DBObject)lobDescriptor, tp.getID()));
                    map.add((Object)tp, (Object)lobDescriptor);
                }
            }
        };
        wrap.executeQuery(r);
        for (Map.Entry entry : map.entrySet()) {
            Collection descs = (Collection)entry.getValue();
            ((TablePartition)entry.getKey()).setLOBDescriptors(descs.toArray(new LOBDescriptor[descs.size()]));
        }
    }

    private void initialisePartition(TablePartition partition, ResultSet rs) throws SQLException {
        OracleTablePartitions.PartitionType ptype = partition.getPartitionType();
        assert (ptype != null);
        if (partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            this.fillInTablespace(partition, rs);
        } else if (ptype != null) {
            partition.setValues(rs.getString("HIGH_VALUE"));
            partition.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(rs, this.getDatabase()));
        }
        this.fillInPartitionTableProperties(partition, rs);
    }

    private void fillInPartitionTableProperties(TablePartition partition, ResultSet rs) throws SQLException {
        if (this.getDatabase().getDatabaseVersion() >= 110) {
            String compressFor;
            String compression = rs.getString("COMPRESSION");
            OracleTableProperties otp = OracleTableBuilder.getOracleTableProperties((DBObject)partition, compression, compressFor = rs.getString("COMPRESS_FOR"), null, this.getDatabase());
            if (otp.getTableCompression() != null) {
                partition.setProperty("OracleTableProperties", (Object)otp);
            }
            OracleTableBuilder.fillInMemoryProperties((DBObject)partition, rs, this.getDatabase());
        }
    }

    private void fillInPartitionLevelSubpartitions(Table table, final OracleTablePartitions otp, final OracleTablePartitions.PartitionType subpartitionType) throws DBException {
        final IdentityHashMap map = new IdentityHashMap();
        BaseOracleDatabase db = this.getDatabase();
        QueryWrapper wrap = db.newQueryWrapper((SystemObject)table, this.getTablePartitionLevelSubpartitionsQuery(), table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException, SQLException {
                while (rs.next()) {
                    TablePartition partition = OracleTablePartitionsBuilder.this.findTablePartition(rs.getString("PARTITION_NAME"), otp);
                    if (partition == null) continue;
                    OracleTablePartitions subpartitions = (OracleTablePartitions)map.get(partition);
                    if (subpartitions == null) {
                        subpartitions = new OracleTablePartitions(subpartitionType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                        subpartitions.setID((DBObjectID)new NameBasedID((DBObject)subpartitions, partition.getID()));
                        map.put(partition, subpartitions);
                    }
                    String subpartitionName = rs.getString("SUBPARTITION_NAME");
                    TablePartition subpartition = subpartitions.createPartition(subpartitionName);
                    subpartition.setID((DBObjectID)new NameBasedID((DBObject)subpartition, subpartitions.getID()));
                    subpartition.setValues(rs.getString("HIGH_VALUE"));
                    OracleTablePartitionsBuilder.this.fillInPartitionTableProperties(subpartition, rs);
                    OracleTablePartitionsBuilder.this.fillInTablespace(subpartition, rs);
                }
            }
        };
        wrap.executeQuery(r);
        for (Map.Entry entry : map.entrySet()) {
            ((TablePartition)entry.getKey()).setPartitionLevelSubpartitions((OracleTablePartitions)entry.getValue());
        }
    }

    private void fillInTablespace(TablePartition partition, ResultSet rs) throws SQLException {
        String tablespaceName = rs.getString("TABLESPACE_NAME");
        if (tablespaceName != null && !rs.wasNull()) {
            OracleStorageProperties segmentAttributes = partition.getSegmentAttributes();
            if (segmentAttributes == null) {
                segmentAttributes = (OracleStorageProperties)this.newObject(OracleStorageProperties.class, null);
                partition.setSegmentAttributes(segmentAttributes);
            }
            segmentAttributes.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)this.getDatabase(), tablespaceName));
        }
    }

    private OracleStorageProperties getOrCreateStorage(LOBDescriptor descriptor) {
        OracleStorageProperties storage = descriptor.getStorage();
        if (storage == null) {
            storage = (OracleStorageProperties)this.newObject(OracleStorageProperties.class, null);
            descriptor.setStorage(storage);
        }
        return storage;
    }

    private TablePartition findTablePartition(String name, OracleTablePartitions otp) {
        TablePartition retval = null;
        DatabaseDescriptor desc = this.getDatabase().getDescriptor();
        for (TablePartition tp : otp.getPartitions()) {
            if (!desc.areNamesEqual(tp.getName(), name, "PARTITION", false)) continue;
            retval = tp;
            break;
        }
        return retval;
    }

    private String getTablePartitionsQuery(Table table) {
        int ver;
        String retval = Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType") ? "select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   sys.all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position" : ((ver = this.getDatabase().getDatabaseVersion()) >= 12102 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_12c102_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       PARTITION_NAME, HIGH_VALUE, COMPRESSION, COMPRESS_FOR, INMEMORY, \n       INMEMORY_COMPRESSION, INMEMORY_PRIORITY, INMEMORY_DISTRIBUTE, INMEMORY_DUPLICATE\nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position" : (ver >= 110 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_11g_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       PARTITION_NAME, HIGH_VALUE, COMPRESSION, COMPRESS_FOR \nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       PARTITION_NAME, HIGH_VALUE\nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position"));
        return retval;
    }

    private String getTablePartitionLevelSubpartitionsQuery() {
        int ver = this.getDatabase().getDatabaseVersion();
        String retval = ver >= 12102 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_12C102_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE, \n       COMPRESSION, COMPRESS_FOR, INMEMORY, INMEMORY_COMPRESSION, INMEMORY_PRIORITY, \n       INMEMORY_DUPLICATE, INMEMORY_DISTRIBUTE \nfrom   SYS.ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION" : (ver >= 110 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_11g_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE, \n       COMPRESSION, COMPRESS_FOR \nfrom   SYS.ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   SYS.ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION");
        return retval;
    }

    public class TablePartitionBuilder
    extends OracleDBObjectBuilder<TablePartition> {
        TablePartitionBuilder(BaseOracleDatabase db) {
            super(db, "PARTITION");
        }

        protected boolean canBuildComponents() {
            return true;
        }

        private OracleTablePartitions getOTP(DBObject obj) {
            DBObject par = obj.getParent();
            return par instanceof OracleTablePartitions ? (OracleTablePartitions)par : null;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"LOBDescriptors"})
        public void fillInLOBDescriptors(TablePartition partition) throws DBException {
            OracleTablePartitions otp = this.getOTP((DBObject)partition);
            if (otp != null) {
                Table table;
                OracleTablePartitions.ObjectType type = otp.getObjectType();
                String query = null;
                if (type == OracleTablePartitions.ObjectType.PARTITION) {
                    query = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_PARTITIONS_QUERY*/\n       COLUMN_NAME, PARTITION_NAME NAME, LOB_PARTITION_NAME LOB_SEGMENT_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   SYS.ALL_LOB_PARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_POSITION, COLUMN_NAME";
                } else if (type == OracleTablePartitions.ObjectType.SUBPARTITION) {
                    query = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_TEMPLATES_QUERY*/\n       distinct SUBPARTITION_NAME NAME, LOB_SEGMENT_NAME, TABLESPACE_NAME, LOB_COL_NAME COLUMN_NAME\nfrom   SYS.ALL_LOB_TEMPLATES\nwhere  /**/USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_NAME";
                } else if (type == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                    query = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_SUBPARTITIONS_QUERY*/\n       COLUMN_NAME, SUBPARTITION_NAME NAME, LOB_PARTITION_NAME LOB_SEGMENT_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   SYS.ALL_LOB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by SUBPARTITION_POSITION, COLUMN_NAME";
                }
                if (query != null && (table = OracleTablePartitionsBuilder.this.getTable((DBObject)otp)) != null) {
                    boolean found = false;
                    for (Column col : table.getColumns()) {
                        if (!LOBDescriptor.isLOBColumn((Column)col)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        OracleTablePartitionsBuilder.this.fillInPartitionLOBs(table, otp, query);
                    }
                }
            }
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"partitionLevelSubpartitions"})
        public void fillInSubpartitions(TablePartition partition) throws DBException {
            Table table;
            OracleTablePartitions sub;
            OracleTablePartitions otp;
            OracleTablePartitions.PartitionType ptype;
            if (partition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION && ((ptype = partition.getPartitionType()) == OracleTablePartitions.PartitionType.RANGE || ptype == OracleTablePartitions.PartitionType.LIST) && (otp = this.getOTP((DBObject)partition)) != null && (sub = otp.getSubpartitionModel()) != null && (table = OracleTablePartitionsBuilder.this.getTable((DBObject)otp)) != null) {
                OracleTablePartitionsBuilder.this.fillInPartitionLevelSubpartitions(table, otp, sub.getPartitionType());
            }
        }
    }
}

