/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.Oracle11gR2XE;
import oracle.javatools.db.ora.Oracle12c;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;
import oracle.javatools.db.ora.lite.OracleDatabaseLiteDescriptor;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class OracleDatabaseFactory
extends BaseDatabaseCreator {
    private static boolean s_autocommit = true;
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";
    private static final DatabaseRegistry.DatabaseVersion[] s_versions;
    private static final DatabaseRegistry.DatabaseVersion[] s_liteVersions;

    public DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
        OracleDatabaseDescriptor retval = db instanceof OracleDatabaseLite ? new OracleDatabaseLiteDescriptor(db.getDatabaseVersion()) : (db instanceof OracleDatabase ? new OracleDatabaseDescriptor(db.getDatabaseVersion()) : null);
        return retval;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(String type, int ver) {
        OracleDatabaseDescriptor retval = "Oracle Lite".equals(type) ? new OracleDatabaseLiteDescriptor(ver) : ("Oracle Database".equals(type) ? new OracleDatabaseDescriptor(ver) : null);
        return retval;
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        OracleDatabaseDescriptor retval = null;
        if (OracleDatabaseLite.class.isAssignableFrom(providerClass)) {
            retval = new OracleDatabaseLiteDescriptor(providerClass);
        } else if (OracleDatabase.class.isAssignableFrom(providerClass)) {
            retval = new OracleDatabaseDescriptor(providerClass);
        }
        return retval;
    }

    public Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        BaseOracleDatabase db = null;
        Tuple<String, Integer> connInfo = OracleDatabaseFactory.getType(conn);
        if (connInfo != null) {
            Integer ver = (Integer)connInfo.getSecond();
            if ("Oracle Lite".equals(connInfo.getFirst())) {
                switch (ver) {
                    case 101: {
                        db = new OracleLite(connStore, connName, conn, ver);
                        break;
                    }
                    case 103: {
                        db = new OracleLite10gR3(connStore, connName, conn, ver);
                    }
                }
            } else {
                switch (ver) {
                    case 81: {
                        db = new Oracle8(connStore, connName, conn, ver);
                        break;
                    }
                    case 82: {
                        db = new Oracle8i(connStore, connName, conn, ver);
                        break;
                    }
                    case 91: {
                        db = new Oracle9i(connStore, connName, conn, ver);
                        break;
                    }
                    case 92: {
                        db = new Oracle9iR2(connStore, connName, conn, ver);
                        break;
                    }
                    case 100: {
                        db = new Oracle10g(connStore, connName, conn, ver);
                        break;
                    }
                    case 102: {
                        db = new Oracle10gR2(connStore, connName, conn, ver);
                        break;
                    }
                    case 101: {
                        db = new Oracle10gR2XE(connStore, connName, conn, ver);
                        break;
                    }
                    case 110: {
                        db = new Oracle11g(connStore, connName, conn, ver);
                        break;
                    }
                    case 112: {
                        db = new Oracle11gR2(connStore, connName, conn, ver);
                        break;
                    }
                    case 111: {
                        db = new Oracle11gR2XE(connStore, connName, conn, ver);
                        break;
                    }
                    case 120: 
                    case 12102: {
                        db = new Oracle12c(connStore, connName, conn, ver);
                    }
                }
            }
        }
        if (db != null) {
            this.initDB((Database)db);
        }
        return db;
    }

    private void initDB(Database db) {
        ConnectionWrapper wrap = new ConnectionWrapper(db, APIBundle.get((String)"SET_AUTOCOMMIT"));
        try {
            wrap.run(new ConnectionWrapper.SQLRunnable(wrap){

                public void run() throws SQLException {
                    this.getConnection().setAutoCommit(s_autocommit);
                }
            });
        }
        catch (DBException dbe) {
            DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
        }
    }

    public static void setDefaultAutocommit(boolean autocommit) {
        s_autocommit = autocommit;
    }

    public static boolean isDefaultAutocommit() {
        return s_autocommit;
    }

    public static boolean isOracleDatabase(Connection conn) {
        return OracleDatabaseFactory.getType(conn) != null;
    }

    private static boolean isExpressEdition(String ver) {
        return ver.indexOf("Express Edition") >= 0;
    }

    private static Tuple<String, Integer> getType(Connection conn) {
        Tuple retval = null;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (ModelUtil.hasLength((String)dbName)) {
                    if (dbName.startsWith("Oracle Lite") || dbName.startsWith("Oracle9i Lite")) {
                        String ver = dmd.getDatabaseProductVersion();
                        int[] version = OracleDatabaseFactory.getOracleMajorMinorVersion(ver);
                        int finalVersion = 101;
                        if (version != null && version.length > 1 && (version[0] > 10 || version[0] == 10 && version[1] >= 3)) {
                            finalVersion = 103;
                        }
                        retval = new Tuple((Object)"Oracle Lite", (Object)finalVersion);
                    } else if (dbName.startsWith("Personal Oracle") || dbName.startsWith("Oracle") && !dbName.startsWith("Oracle Rdb") && !dbName.startsWith("Oracle Business Intelligence")) {
                        int type = 0;
                        String ver = dmd.getDatabaseProductVersion();
                        int[] version = OracleDatabaseFactory.getOracleMajorMinorVersion(ver);
                        if (version != null && version.length >= 2) {
                            int major = version[0];
                            int minor = version[1];
                            if (major < 8) {
                                type = 0;
                            } else if (major == 8) {
                                type = minor >= 1 ? 82 : 81;
                            } else if (major == 9) {
                                type = minor >= 2 ? 92 : 91;
                            } else if (major == 10) {
                                type = minor < 2 ? 100 : (OracleDatabaseFactory.isExpressEdition(ver) ? 101 : 102);
                            } else if (major == 11) {
                                type = minor < 2 ? 110 : (OracleDatabaseFactory.isExpressEdition(ver) ? 111 : 112);
                            } else if (major == 12) {
                                type = 120;
                                if (minor > 1 || version.length >= 3 && version[2] > 0 || version.length >= 4 && version[3] > 1) {
                                    type = 12102;
                                }
                            } else {
                                type = 12102;
                            }
                        }
                        retval = new Tuple((Object)"Oracle Database", (Object)type);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return retval;
    }

    public static int[] getOracleMajorMinorVersion(String dbVersion) {
        int[] retval = null;
        if (ModelUtil.hasLength((String)dbVersion)) {
            String num;
            Pattern pattern = Pattern.compile(VERSION_PATTERN);
            Matcher matcher = pattern.matcher(dbVersion);
            String string = num = matcher.find() ? matcher.group() : null;
            if (ModelUtil.hasLength((String)num)) {
                String[] bits = num.split("\\.");
                retval = new int[bits.length];
                for (int i = 0; i < bits.length; ++i) {
                    try {
                        retval[i] = Integer.parseInt(bits[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        retval = null;
                        break;
                    }
                }
            }
        }
        return retval;
    }

    public static void registerOracleDatabases() {
        DatabaseRegistry dbreg = DatabaseRegistry.getInstance();
        dbreg.registerDatabases("Oracle Lite", OracleDatabaseFactory.class.getName(), null, null, s_liteVersions);
        dbreg.registerDatabases("Oracle Database", OracleDatabaseFactory.class.getName(), null, null, s_versions);
        Metadata m = Metadata.getInstance();
        m.registerBooleanProperty("OBJECT TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        m.registerBooleanProperty("NESTED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        m.registerBooleanProperty("PARTITIONED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        m.registerProperty("USER_PRIVS", Set.class, OracleDatabase.class, new Class[]{Schema.class});
        m.registerProperty("USER_ROLES", Set.class, OracleDatabase.class, new Class[]{Schema.class});
        ColumnSequenceProcessor.registerProcessorProperties(OracleDatabaseImpl.class);
    }

    static Class<? extends OracleDatabase> getDatabaseClass(int version) {
        Class<?> retval = null;
        for (DatabaseRegistry.DatabaseVersion v : s_versions) {
            if (version != v.getVersion()) continue;
            try {
                ClassLoader l = OracleDatabaseFactory.class.getClassLoader();
                retval = l.loadClass(v.getDatabaseClassName());
            }
            catch (ClassNotFoundException cnfe) {
                DBLog.getLogger(OracleDatabaseFactory.class).severe(cnfe.getMessage());
            }
            break;
        }
        return retval;
    }

    static int getDatabaseVersion(Class<? extends OracleDatabase> clz) {
        DatabaseRegistry.DatabaseVersion[] versions;
        int retval = 0;
        for (DatabaseRegistry.DatabaseVersion v : versions = OracleDatabaseLite.class.isAssignableFrom(clz) ? s_liteVersions : s_versions) {
            if (!clz.getName().equals(v.getDatabaseClassName())) continue;
            retval = v.getVersion();
            break;
        }
        return retval;
    }

    static {
        s_liteVersions = new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_LITE_10gR1"), "oracle.javatools.db.ora.OracleLite", true), new DatabaseRegistry.DatabaseVersion(103, APIBundle.get((String)"DB_ORACLE_LITE_10gR3"), "oracle.javatools.db.ora.OracleLite10gR3", true)};
        String clz12 = "oracle.javatools.db.ora.Oracle12c";
        s_versions = new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(0, null, "oracle.javatools.db.ora.OracleDatabaseImpl"), new DatabaseRegistry.DatabaseVersion(81, null, "oracle.javatools.db.ora.Oracle8"), new DatabaseRegistry.DatabaseVersion(82, APIBundle.get((String)"DB_ORACLE_8i"), "oracle.javatools.db.ora.Oracle8i", true), new DatabaseRegistry.DatabaseVersion(91, null, "oracle.javatools.db.ora.Oracle9i"), new DatabaseRegistry.DatabaseVersion(92, APIBundle.get((String)"DB_ORACLE_9i2"), "oracle.javatools.db.ora.Oracle9iR2"), new DatabaseRegistry.DatabaseVersion(100, APIBundle.get((String)"DB_ORACLE_10g"), "oracle.javatools.db.ora.Oracle10g"), new DatabaseRegistry.DatabaseVersion(102, APIBundle.get((String)"DB_ORACLE_10gR2"), "oracle.javatools.db.ora.Oracle10gR2"), new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_10gR2XE"), "oracle.javatools.db.ora.Oracle10gR2XE"), new DatabaseRegistry.DatabaseVersion(110, APIBundle.get((String)"DB_ORACLE_11g"), "oracle.javatools.db.ora.Oracle11g"), new DatabaseRegistry.DatabaseVersion(112, APIBundle.get((String)"DB_ORACLE_11gR2"), "oracle.javatools.db.ora.Oracle11gR2"), new DatabaseRegistry.DatabaseVersion(111, APIBundle.get((String)"DB_ORACLE_11gR2XE"), "oracle.javatools.db.ora.Oracle11gR2XE"), new DatabaseRegistry.DatabaseVersion(120, APIBundle.get((String)"DB_ORACLE_12c"), "oracle.javatools.db.ora.Oracle12c"), new DatabaseRegistry.DatabaseVersion(12102, APIBundle.get((String)"DB_ORACLE_12cR102"), "oracle.javatools.db.ora.Oracle12c")};
    }
}

