/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.mysql.MySQLDatabaseImpl;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class MySQLTableBuilder
extends JdbcTableBuilder<Table> {
    MySQLTableBuilder(MySQLDatabaseImpl db, String catalog) {
        super(db, catalog);
    }

    @Override
    protected void addExtraDataTypeAttributeValues(final Map<String, Object> attrs, String colName, Table rel) {
        String tabName;
        String dataTypeName = (String)attrs.get("name");
        String string = tabName = rel.getSchema() == null ? rel.getName() : rel.getSchema() + "." + rel.getName();
        if ("ENUM".equalsIgnoreCase(dataTypeName) || "SET".equalsIgnoreCase(dataTypeName)) {
            String qualifiedRelName = rel.getSchema() == null ? rel.getName() : rel.getSchema() + "." + rel.getName();
            String queryString = "show columns from " + tabName + " like '" + colName + "'";
            final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), queryString);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            String[] datatypeVals = rs.getString(2).split("\\(|\\)");
                            if (datatypeVals.length <= 1) continue;
                            attrs.put("value_list", datatypeVals[1]);
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException(ex);
                    }
                }
            };
            try {
                wrap.executeQuery(r);
            }
            catch (DBException dbe) {
                String msg = MessageFormat.format("Error getting props for col {0} on {1}", colName, tabName);
                DBLog.getLogger((Object)((Object)this)).log(Level.FINE, msg, dbe);
                DBLog.getLogger((Object)((Object)this)).warning(msg);
            }
        }
    }

    @Override
    protected void loadAndBuildIndexes(final Table table) throws DBException {
        String tableName = this.getNameForDriver(table.getName());
        String schemaName = this.isUseSchema() && table.getSchema() != null ? table.getSchema().getName() : null;
        String IndexQueryString = "show indexes from " + schemaName + ".`" + tableName + "`";
        QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), IndexQueryString);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) {
                try {
                    MySQLTableBuilder.this.processIndexes(rs, table);
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.WARNING, "Unable to process indexes for table: " + table, dbe);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Unable to query indexes for table: " + table, dbe);
        }
    }

    @Override
    protected void processIndexes(ResultSet rs, Table table) throws DBException {
        TreeMap<String, Index> idxMap = new TreeMap<String, Index>();
        try {
            String tableName = this.getNameForDriver(table.getName());
            while (rs != null && rs.next()) {
                boolean isUnique;
                if (tableName == null && !rs.getString(1).equals(table.getName())) continue;
                boolean bl = isUnique = !rs.getBoolean(2);
                String indexName = rs.getString(3);
                if (table.getConstraint(indexName) != null) continue;
                String colName = rs.getString(5);
                String ascDesc = rs.getString(6);
                Index index = (Index)idxMap.get(indexName);
                if (index == null) {
                    index = new Index(indexName, table);
                    idxMap.put(indexName, index);
                }
                index.setIndexType(isUnique ? Index.IndexType.UNIQUE : Index.IndexType.NORMAL);
                Column col = table.getColumn(colName);
                if (col == null) continue;
                IndexObject.OrderType orderType = null;
                if (ascDesc != null) {
                    orderType = ascDesc.equals("A") ? IndexObject.OrderType.ASC : IndexObject.OrderType.DESC;
                }
                ColumnUsage colUsage = new ColumnUsage(col.getID());
                colUsage.setProvider((DBObjectProvider)this.getProvider());
                IndexObject io = new IndexObject((SQLFragment)colUsage, orderType);
                index.addColumnExpression(io);
            }
        }
        catch (SQLException ex) {
            this.checkUnsupportedOperation((DBObject)table, ex);
        }
        Collection values = idxMap.values();
        Index[] indexes = values.toArray(new Index[values.size()]);
        table.setIndexes(indexes);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void buildComment(final Table tab) throws DBException {
        final Holder comment = new Holder();
        final boolean ddl = this.getDatabase().getDatabaseVersion() < 50;
        String queryString = ddl ? "show create table `{0}`.`{1}`" : "select table_name, table_comment from information_schema.tables  where table_schema = ''{0}'' and table_name = ''{1}''";
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), queryString, new Object[]{tab.getSchema(), tab});
        wrap.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String tabName = rs.getString(1);
                        if (!tab.getName().equals(tabName)) continue;
                        String commentString = rs.getString(2);
                        if (ddl) {
                            int quote = 39;
                            int start = commentString.indexOf("COMMENT='");
                            if (start > 0) {
                                StringBuilder cbuff = new StringBuilder();
                                int i = start + 9;
                                while (i < commentString.length()) {
                                    char c;
                                    boolean isQuote;
                                    boolean bl = isQuote = (c = commentString.charAt(i++)) == '\'';
                                    if (isQuote) {
                                        boolean nextIsQuote = false;
                                        if (commentString.length() > i) {
                                            char next = commentString.charAt(i);
                                            boolean bl2 = nextIsQuote = next == '\'';
                                        }
                                        if (!nextIsQuote) break;
                                        ++i;
                                    }
                                    cbuff.append(c);
                                }
                                commentString = cbuff.toString();
                            } else {
                                commentString = null;
                            }
                        }
                        if (!ModelUtil.hasLength((String)commentString)) {
                            commentString = null;
                        }
                        comment.set((Object)commentString);
                        break;
                    }
                }
                catch (SQLException sqle) {
                    wrap.throwDBException((DBObject)tab, sqle);
                }
            }
        });
        tab.setProperty("Comment", comment.get());
    }

    private boolean canBuildKeysFromDictionary() {
        return this.getDatabase().getDatabaseVersion() > 40;
    }

    @Override
    protected void buildPK(Table rel) throws DBException {
        if (!this.canBuildKeysFromDictionary()) {
            super.buildPK(rel);
        }
    }

    @Override
    protected String makePKName(String schemaName, String tableName) {
        return "PRIMARY";
    }

    @Override
    protected void buildUKs(Table rel) throws DBException {
        if (this.canBuildKeysFromDictionary()) {
            this.buildKeysFromDictionary(rel);
        }
    }

    private void buildKeysFromDictionary(final Table rel) throws DBException {
        final HashMap cons = new HashMap();
        final JdbcDatabase db = this.getDatabase();
        final QueryWrapper wrap = new QueryWrapper((Database)db, "select CONSTRAINT_NAME, con.CONSTRAINT_TYPE, col.COLUMN_NAME, col.ORDINAL_POSITION\nfrom INFORMATION_SCHEMA.TABLE_CONSTRAINTS con\njoin INFORMATION_SCHEMA.KEY_COLUMN_USAGE col\nusing( CONSTRAINT_SCHEMA, CONSTRAINT_NAME, TABLE_SCHEMA, TABLE_NAME )\nwhere binary TABLE_SCHEMA = ? and binary TABLE_NAME = ?\norder by col.ORDINAL_POSITION", new Object[]{rel.getSchema(), rel});
        wrap.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String name = rs.getString("CONSTRAINT_NAME");
                        String type = rs.getString("CONSTRAINT_TYPE");
                        String colName = rs.getString("COLUMN_NAME");
                        ColumnConstraint con = (ColumnConstraint)cons.get(name);
                        if (con == null) {
                            Class<UniqueConstraint> conClz = null;
                            if (type.equals("UNIQUE")) {
                                conClz = UniqueConstraint.class;
                            } else if (type.equals("PRIMARY KEY")) {
                                conClz = PKConstraint.class;
                            }
                            if (conClz != null) {
                                con = (ColumnConstraint)db.getObjectFactory().newObject(conClz, (DBObject)rel);
                                con.setName(name);
                                con.setID((DBObjectID)new NameBasedID("CONSTRAINT", name, rel.getID()));
                            }
                        }
                        if (con == null) continue;
                        cons.put(name, con);
                        Column col = rel.getColumn(colName);
                        if (col == null) continue;
                        boolean found = false;
                        for (DBObjectID existing : con.getColumnIDs()) {
                            if (!existing.equals(col.getID(), true)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        con.addColumn(col);
                    }
                }
                catch (SQLException sqle) {
                    wrap.throwDBException((DBObject)rel, sqle);
                }
            }
        });
        for (ColumnConstraint con : cons.values()) {
            if (con.getColumnIDs().length <= 0) continue;
            rel.addConstraint((Constraint)con);
        }
    }
}

