/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.ValidationException;

class MySQLColumnValidator
extends ColumnValidator {
    static final DataTypeAttribute FLOAT_PRECISION = new DataTypeAttribute("size", "DATATYPE_ATTRIBUTE_LABEL_DISPLAY_WIDTH", 0L, Long.valueOf(53L), null, false);
    private static final NumericDataType ANSI_FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT(<size>)[ <unsigned>]", new DataTypeAttribute[]{FLOAT_PRECISION, NumericDataType.UNSIGNED}, new NumericDataType.MinMaxValue("2.2250738585072014E-308", "1.7976931348623157E+308", NumericDataType.MinMaxValue.FLOAT));

    public MySQLColumnValidator(DBObjectProvider prov) {
        super(prov, true);
    }

    @Override
    protected void validateDateDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        Long scaleVal;
        String dataTypeName = dataType.getName();
        if ("FLOAT".equals(dataTypeName) && (scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale")) == null) {
            dataType = ANSI_FLOAT;
        }
        if (!"ENUM".equals(dataTypeName)) {
            super.validateDateDefaultValue(defaultValue, column, dataTypeUsage, (DataType)dataType);
        }
    }
}

