/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.marshal.BaseSAXHelper;
import oracle.javatools.db.marshal.DBObject2XML;
import oracle.javatools.db.marshal.PartialParseCompleteException;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

class DBObjectSAXHelper
extends BaseSAXHelper {
    private static final String NULL = "null";
    private boolean m_idNameOnly;
    private final List<DBObject> m_objs = new ArrayList<DBObject>();
    private Map<Class, Map<String, PropertyInfo>> m_infos = new HashMap<Class, Map<String, PropertyInfo>>();
    private Map<String, Class<? extends DBObject>> m_types;
    private DBObject2XML m_parent;

    public DBObjectSAXHelper(String namespace, boolean idNameOnly, DBObject2XML parent) {
        super(namespace);
        this.m_idNameOnly = idNameOnly;
        this.m_parent = parent;
    }

    public List<DBObject> getDBObjects() {
        return this.m_objs;
    }

    private Map<String, PropertyInfo> getPropertyInfos(Object bean) {
        Class<?> clz = bean.getClass();
        if (this.m_infos.containsKey(clz)) {
            return this.m_infos.get(clz);
        }
        PropertyIterator iter = new PropertyIterator(clz, null);
        Map infos = iter.getPropertyInfos(true, false, true);
        this.m_infos.put(clz, infos);
        return infos;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name = ModelUtil.hasLength((String)localName) ? localName : qName;
        this.clearChars();
        int ssize = this.getStackSize();
        if (ssize == 0) {
            this.checkNamespace(uri);
            if (!"composite".equals(localName)) {
                Class clz = this.getObjectClass(name);
                this.m_objs.add((DBObject)this.createObject(clz));
            } else if (this.m_idNameOnly) {
                throw new SAXException((Exception)new PartialParseUnsupportedException());
            }
        } else {
            Object current = this.getCurrentObject();
            if (current == NULL) {
                this.push(NULL, NULL);
            } else if (current instanceof Map) {
                this.push(new Object[2], name);
            } else if (current instanceof Object[]) {
                if (name.equals("key")) {
                    this.push("key", name);
                } else if (name.equals("value")) {
                    Class clz = this.getAttributeClass(attributes);
                    if (clz == null) {
                        this.push("value", name);
                    } else if (this.m_parent.toStringConverterAvailable(clz)) {
                        this.push(clz, name);
                    } else if (clz.isArray()) {
                        ArrayList<Class> stck = new ArrayList<Class>();
                        stck.add(clz);
                        this.push(stck, name);
                    } else {
                        this.createObjectNoFail(clz, name);
                    }
                }
            } else if (current instanceof List) {
                Class<?> clz = this.getAttributeClass(attributes);
                if (clz == null) {
                    Class propClz;
                    Object par = this.getCurrentParent();
                    if (par instanceof PropertyInfo && (propClz = ((PropertyInfo)par).getPropertyClass()).isArray()) {
                        clz = propClz.getComponentType();
                    }
                    if (clz == null) {
                        clz = this.getObjectClass(name);
                    }
                }
                if (this.m_parent.toStringConverterAvailable(clz)) {
                    this.push(clz, name);
                } else {
                    this.createObjectNoFail(clz, name);
                }
            } else {
                PropertyInfo info = this.getPropertyInfos(current).get(name);
                if (info == null) {
                    Map allinfos = null;
                    if (current instanceof Copyable) {
                        PropertyIterator iter = new PropertyIterator(current.getClass(), null);
                        allinfos = iter.getPropertyInfos(false, false, false);
                    }
                    if (allinfos != null && allinfos.containsKey(name)) {
                        this.getLogger().fine("ignoring property \"" + name + "\" as it has been deprecated.");
                    } else {
                        this.getLogger().log(Level.INFO, "XML parse: Unknown property {0} on {1}", new Object[]{name, current.getClass()});
                    }
                    this.push(NULL, name);
                } else {
                    this.push(info, name);
                    Class clz = info.getPropertyClass();
                    if (clz == Map.class) {
                        this.push(new HashMap(), name);
                    } else if (clz.isArray()) {
                        this.push(new ArrayList(), name);
                    } else {
                        Class newClass = this.getAttributeClass(attributes);
                        if (newClass == null) {
                            newClass = clz;
                        }
                        if (clz != newClass && this.m_parent.toStringConverterAvailable(newClass)) {
                            this.push(newClass, name);
                        } else if (!this.m_parent.toStringConverterAvailable(newClass)) {
                            this.createObjectNoFail(newClass, name);
                        }
                    }
                }
            }
        }
    }

    private String getPropertyPath() {
        StringBuilder fluff = new StringBuilder();
        for (int i = this.getStackSize() - 1; i >= 0; --i) {
            Object o = this.getObject(i);
            if (!(o instanceof PropertyInfo)) continue;
            if (fluff.length() > 0) {
                fluff.insert(0, "/");
            }
            fluff.insert(0, ((PropertyInfo)o).getPropertyName());
        }
        return fluff.toString();
    }

    void setTypeMappings(Map<String, Class<? extends DBObject>> extraMappings) {
        this.initTypeMap(extraMappings);
    }

    private void initTypeMap(Map<String, Class<? extends DBObject>> extraMappings) {
        if (this.m_types == null) {
            this.m_types = new HashMap<String, Class<? extends DBObject>>();
            if (extraMappings != null) {
                this.registerMappings(extraMappings);
            }
            this.registerMappings(Metadata.getInstance().getDBObjectClasses());
        }
    }

    private void registerMappings(Map<String, Class<? extends DBObject>> map) {
        for (Map.Entry<String, Class<? extends DBObject>> entry : map.entrySet()) {
            String cType = DBObject2XML.convertType(entry.getKey());
            if (this.m_types.containsKey(cType)) continue;
            this.m_types.put(cType, entry.getValue());
        }
    }

    private Class getObjectClass(String localName) throws SAXNotRecognizedException {
        this.initTypeMap(null);
        Class<? extends DBObject> clz = this.m_types.get(localName);
        if (clz == null) {
            throw new SAXNotRecognizedException("unknown object type " + localName);
        }
        return clz;
    }

    private void createObjectNoFail(Class clz, String name) {
        try {
            this.createObject(clz);
        }
        catch (SAXException e) {
            this.logConversionError(e);
            this.push(NULL, name);
        }
    }

    private Object createObject(Class clz) throws SAXException {
        while (clz.getAnnotation(Deprecated.class) != null && clz.getDeclaredMethods().length == 0 && clz.getDeclaredFields().length == 0) {
            clz = clz.getSuperclass();
        }
        try {
            Object obj = clz.newInstance();
            this.push(obj, NULL);
            return obj;
        }
        catch (Exception e) {
            if (e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name;
        String string = name = ModelUtil.hasLength((String)localName) ? localName : qName;
        if (this.hasChars() && (this.getStackSize() != 0 || !"composite".equals(localName))) {
            this.setCharactersValue();
        }
        this.clearChars();
        Object done = this.pop(name);
        if (done == NULL) {
            if (this.getCurrentObject() instanceof PropertyInfo) {
                this.pop(name);
            }
        } else if (!(done instanceof PropertyInfo) && done != "key" && done != "value") {
            if (done instanceof Class) {
                if (this.getCurrentObject() instanceof PropertyInfo) {
                    this.pop(name);
                }
            } else if (done instanceof Object[]) {
                Map map = (Map)this.getCurrentObject();
                map.put(((Object[])done)[0], ((Object[])done)[1]);
            } else if (this.getStackSize() > 0) {
                Object parent = this.getCurrentObject();
                if (parent instanceof PropertyInfo) {
                    Object value;
                    PropertyInfo info = (PropertyInfo)this.pop(name);
                    if (done instanceof List) {
                        Class arrayClz = info.getPropertyClass();
                        if (arrayClz.isArray()) {
                            value = Array.newInstance(arrayClz.getComponentType(), ((List)done).size());
                            value = ((List)done).toArray((Object[])value);
                        } else {
                            value = done;
                        }
                    } else {
                        value = done;
                    }
                    Object currentObject = this.getCurrentObject();
                    if (value instanceof Map && currentObject instanceof AbstractDBObject && info.getPropertyName().equals("properties")) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            String propName = (String)entry.getKey();
                            try {
                                if (propName.equals("ID")) continue;
                                ((DBObject)currentObject).setProperty(propName, entry.getValue());
                            }
                            catch (Exception e) {
                                this.logConversionError(e);
                            }
                        }
                    } else {
                        try {
                            info.setPropertyValue(currentObject, value);
                        }
                        catch (Exception e) {
                            this.logConversionError(e);
                        }
                    }
                } else if (parent instanceof Object[]) {
                    List list;
                    Object first;
                    if (done instanceof List && (first = (list = (List)done).get(0)) instanceof Class) {
                        list.remove(0);
                        done = Array.newInstance(((Class)first).getComponentType(), list.size());
                        done = list.toArray((Object[])done);
                    }
                    ((Object[])parent)[1] = done;
                } else if (parent instanceof List) {
                    ((List)parent).add(done);
                }
            }
        }
        this.checkObject();
    }

    private void setCharactersValue() {
        Object par;
        String str = this.getChars();
        Object obj = this.getCurrentObject();
        Class clz = null;
        if (obj instanceof Class && (par = this.getCurrentParent()) instanceof PropertyInfo) {
            clz = (Class)this.pop("?");
            obj = par;
        }
        if (obj instanceof PropertyInfo) {
            PropertyInfo info = (PropertyInfo)obj;
            Class clazz = clz = clz == null ? info.getPropertyClass() : clz;
            if (this.m_parent.toStringConverterAvailable(clz)) {
                try {
                    Object value;
                    block23: {
                        value = null;
                        try {
                            value = this.fromString(str, clz);
                        }
                        catch (IllegalArgumentException iae) {
                            if (clz.isEnum()) {
                                Method m = clz.getMethod("migrate", String.class);
                                if (m == null || !m.getReturnType().equals(clz)) break block23;
                                try {
                                    value = m.invoke((Object)clz, str);
                                }
                                catch (Exception ex) {
                                    throw iae;
                                }
                            }
                            throw iae;
                        }
                        catch (UnsupportedOperationException use) {
                            if (Number.class.isAssignableFrom(clz) && info.isNumberUnlimited() && "UNLIMITED".equals(str)) {
                                value = info.getNumberUnlimitedValue();
                            }
                            throw use;
                        }
                    }
                    info.setPropertyValue(this.getCurrentParent(), value);
                }
                catch (Exception e) {
                    this.logConversionError(e);
                }
            }
        } else if (obj == "key") {
            ((Object[])this.getCurrentParent())[0] = str;
        } else if (obj instanceof Class) {
            Object parent = this.getCurrentParent();
            try {
                if (parent instanceof Object[]) {
                    ((Object[])parent)[1] = this.fromString(str, (Class)obj);
                } else if (parent instanceof List) {
                    String top = null;
                    this.push(this.fromString(str, (Class)this.pop(top)), top);
                }
            }
            catch (Exception e) {
                this.logConversionError(e);
            }
        } else if (obj == "value") {
            ((Object[])this.getCurrentParent())[1] = str;
        }
    }

    private Object fromString(String str, Class clz) {
        Class<?> retval = null;
        if (clz == Class.class) {
            try {
                retval = this.findClassLoader().loadClass(str);
            }
            catch (ClassNotFoundException cnfe) {
                retval = null;
            }
        } else {
            retval = ToStringManager.fromString((String)str, (Class)clz);
        }
        return retval;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    private void logConversionError(Exception e) {
        String msg = "Couldn't parse XML element: " + e.getMessage();
        Logger logger = this.getLogger();
        logger.log(Level.FINE, msg, e);
        logger.warning(msg);
    }

    private void checkObject() throws SAXException {
        DBObject obj;
        int numObjs = this.m_objs.size();
        if (this.m_idNameOnly && numObjs > 0 && ModelUtil.hasLength((String)(obj = this.m_objs.get(numObjs - 1)).getName()) && obj.getID() != null) {
            throw new PartialParseCompleteException();
        }
    }
}

