/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.View;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcRelationBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class JdbcViewBuilder
extends JdbcRelationBuilder<View> {
    protected static final String DEFAULT_SEARCH_STRING = "CREATE VIEW <name ?.> [(<cols {^)}...>)] AS <select {^{WITH CHECK OPTION|WITH READ ONLY}}...> <check [WITH CHECK OPTION]> <readOnly [WITH READ ONLY]>";
    private TokenPattern m_viewSearch;

    public JdbcViewBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog, "VIEW");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery", "restriction"})
    public void buildQuery(final View view) throws DBException {
        String query = this.getDictionaryQuery();
        if (query == null) {
            this.getLogger().warning(APIBundle.format((String)"VIEW_BUILD_SQL_ERR", (Object[])new Object[]{view.getName()}));
        } else {
            final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), query, this.getDictionaryQueryParams(view));
            wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            String queryString = rs.getString(1);
                            JdbcViewBuilder.this.decodeQueryString(queryString, view);
                            if (rs.getMetaData().getColumnCount() > 1) {
                                String r = rs.getString(2);
                                View.Restriction vr = JdbcViewBuilder.this.decodeRestriction(r);
                                view.setRestriction(vr);
                            }
                        }
                    }
                    catch (SQLException sqe) {
                        wrap.throwDBException(sqe);
                    }
                }
            });
        }
    }

    public boolean canBuildEditableObject() {
        return this.getDictionaryQuery() != null;
    }

    protected String getDictionaryQuery() {
        return null;
    }

    protected Object[] getDictionaryQueryParams(View view) {
        return new Object[]{view.getSchema(), view};
    }

    @Deprecated
    protected SQLQuery decodeQueryString(String queryString) {
        return null;
    }

    protected void decodeQueryString(String queryString, View view) {
        String search = this.getQuerySearchString();
        if (search != null) {
            TokenPattern.PatternResult mr;
            if (this.m_viewSearch == null) {
                this.m_viewSearch = new TokenPattern(search);
            }
            if ((mr = this.m_viewSearch.getResult(queryString)) != null) {
                Token startOfReadOnly;
                Token startOfSelect = mr.getNamedMatchStartToken("select");
                Token endOfSelect = mr.getNamedMatchEndToken("select");
                queryString = startOfSelect.getSource(false, endOfSelect);
                Token startOfCheck = mr.getNamedMatchStartToken("check");
                if (startOfCheck != null) {
                    view.setRestriction(View.Restriction.CHECK_OPTION);
                }
                if ((startOfReadOnly = mr.getNamedMatchStartToken("readOnly")) != null) {
                    view.setRestriction(View.Restriction.READ_ONLY);
                }
            }
        }
        SQLQuery query = (SQLQuery)this.newObject(SQLQuery.class, null);
        query.setQueryString(queryString);
        view.setSQLQuery(query);
    }

    protected String getQuerySearchString() {
        return null;
    }

    protected View.Restriction decodeRestriction(String result) {
        return null;
    }
}

