/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.UserDataType;
import oracle.javatools.db.jdbc.DMDBuilder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public abstract class JdbcRelationBuilder<T extends Relation>
extends DMDBuilder<T> {
    protected JdbcRelationBuilder(JdbcDatabase db, String catalog, String type) {
        super(db, catalog, type);
    }

    @Deprecated
    protected T createRelation(Schema schema, String name) {
        return null;
    }

    protected final boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
    public void fillInColumns(T rel) throws DBException {
        Connection conn = this.getConnection();
        ResultSet rs = null;
        try {
            rs = this.getColumnsMetadata(rel, conn);
            this.buildColumns(rs, rel);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            this.close(rs);
        }
    }

    protected ResultSet getColumnsMetadata(T rel, Connection conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        String relationName = this.getNameForDriver(rel.getName());
        String[] catAndSchema = this.getCatalogAndSchema(rel.getSchema());
        String dbProductName = dmd.getDatabaseProductName();
        ResultSet rs = "EXCEL".equals(dbProductName) ? dmd.getColumns(catAndSchema[0], null, relationName, null) : dmd.getColumns(catAndSchema[0], catAndSchema[1], relationName, "%");
        return rs;
    }

    private void buildColumns(ResultSet rs, T rel) throws SQLException, DBException {
        ArrayList<Column> list = new ArrayList<Column>();
        String relationName = this.getNameForDriver(rel.getName());
        try {
            JdbcDatabase db = this.getDatabase();
            int columnCount = 0;
            while (rs.next()) {
                String defaultValue;
                String datatypeId;
                if (relationName == null && !rs.getString(3).equals(rel.getName())) continue;
                ++columnCount;
                String colName = rs.getString(4);
                Column column = (Column)this.newObject(Column.class, colName);
                column.setID((DBObjectID)new NameBasedID((DBObject)column, rel.getID()));
                list.add(column);
                column.setRelation(rel);
                String jdbcTypeName = rs.getString(6);
                if ((jdbcTypeName == null || jdbcTypeName.length() == 0) && (datatypeId = rs.getString(5)).equals(4118)) {
                    jdbcTypeName = "ROW";
                }
                String dataTypeName = db.normaliseDataTypeName(jdbcTypeName);
                long sizeL = rs.getLong(7);
                Long size = rs.wasNull() ? null : new Long(sizeL);
                long scaleL = rs.getLong(9);
                Long scale = rs.wasNull() ? null : new Long(scaleL);
                DataType dataType = null;
                DataTypeUsage dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.getDatabase(), (Schema)rel.getSchema(), (String)dataTypeName);
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)dtu, (boolean)false);
                }
                catch (DBException dbe) {
                    this.getLogger().warning(dbe.getMessage());
                }
                Map attributes = this.createDataTypeAttributes(rel, column, dataType, size, scale, jdbcTypeName);
                if (attributes != null && !attributes.isEmpty()) {
                    Map filteredAttributes = dataType == null || dataType instanceof UserDataType ? attributes : dataType.createUsage(attributes).getAttributeValues();
                    for (Map.Entry<String, Object> entry : filteredAttributes.entrySet()) {
                        dtu.putAttributeValue(entry.getKey(), entry.getValue());
                    }
                }
                column.setDataTypeUsage(dtu);
                String remark = rs.getString(12);
                if (ModelUtil.hasLength((String)remark)) {
                    column.setProperty("Comment", (Object)remark);
                }
                if (ModelUtil.hasLength((String)(defaultValue = rs.getString(13)))) {
                    column.setDefault((Object)db.normaliseDefaultValue(dataType, defaultValue));
                }
                try {
                    String canIncludeNull = rs.getString(18);
                    if (canIncludeNull != null) {
                        boolean mandatory = canIncludeNull.trim().equals("NO") || canIncludeNull.trim().equals("N");
                        column.setNotNull(mandatory);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.buildExtraColumnInformation(rel, column, rs);
            }
            this.getLogger().fine(">>fillInColumns : " + columnCount + " columns returned for " + rel.getName());
            rel.setColumns(list.toArray(new Column[list.size()]));
            this.addExtraColumnAttributes(rel);
        }
        catch (SQLException ex) {
            this.checkUnsupportedOperation((DBObject)rel, ex);
        }
    }

    protected void buildExtraColumnInformation(T rel, Column col, ResultSet rs) throws SQLException {
    }

    protected void addExtraColumnAttributes(T rel) throws SQLException, DBException {
    }

    @Deprecated
    protected DataTypeUsage getDataTypeUsage(T rel, Column column, DataType dataType, Long size, Long scale, String jdbcTypeName) {
        DataTypeUsage dtu = null;
        Map<String, Object> attributes = this.createDataTypeAttributes(rel, column, dataType, size, scale, jdbcTypeName);
        dtu = dataType.createUsage(attributes);
        return dtu;
    }

    protected Map<String, Object> createDataTypeAttributes(T rel, Column column, DataType dataType, Long size, Long scale, String jdbcTypeName) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        JdbcDatabase db = this.getDatabase();
        String dataTypeName = db.normaliseDataTypeName(jdbcTypeName);
        DataTypeUsage dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)db, (Schema)rel.getSchema(), (String)dataTypeName);
        if (dataType != null) {
            attributes.put("name", dataType.getName());
        }
        this.setAttributeValue("size", dataType, size, attributes, dtu);
        this.setAttributeValue("precision", dataType, size, attributes, dtu);
        this.setAttributeValue("scale", dataType, scale, attributes, dtu);
        this.addExtraDataTypeAttributeValues(attributes, column.getName(), rel);
        return attributes;
    }

    private void setAttributeValue(String attributeName, DataType dataType, Long value, Map<String, Object> attributes, DataTypeUsage dtu) {
        String[] vals;
        DataTypeAttribute attribute;
        Object attribVal = dtu.getAttributeValue(attributeName);
        if (dataType != null && attribVal != null && (attribute = dataType.getDataTypeAttribute(attributeName)) != null && attribute.getValueType() == 2 && (vals = attribute.getValues()) != null && vals.length > 0) {
            for (String val : vals) {
                if (!val.equalsIgnoreCase((String)attribVal)) continue;
                return;
            }
        }
        attributes.put(attributeName, DataTypeHelper.getAttributeValue((Object)value, (DataType)dataType, (String)attributeName));
    }

    protected void addExtraDataTypeAttributeValues(Map<String, Object> attrs, String colName, T rel) {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"constraints"}, depends={"columns"})
    public void fillInConstraints(T rel) throws DBException {
        rel.setConstraints(new Constraint[0]);
        this.buildPK(rel);
        this.buildUKs(rel);
        this.buildCCs(rel);
        this.buildFKs(rel);
    }

    protected ResultSet getPrimaryKeysMetadata(T rel, Connection conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        String relationName = this.getNameForDriver(rel.getName());
        String[] catAndSchema = this.getCatalogAndSchema(rel.getSchema());
        return dmd.getPrimaryKeys(catAndSchema[0], catAndSchema[1], relationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPK(T rel) throws DBException {
        ResultSet rs;
        block8: {
            String relationName = this.getNameForDriver(rel.getName());
            rs = null;
            try {
                rs = this.getPrimaryKeysMetadata(rel, this.getConnection());
                TreeSet<ConCol> cols = new TreeSet<ConCol>();
                int i = 0;
                PKConstraint pk = null;
                while (rs.next()) {
                    String pkSchemaName = rs.getString(2);
                    String pkTableName = rs.getString(3);
                    if (relationName == null && !pkTableName.equals(rel.getName())) continue;
                    String colName = rs.getString(4);
                    short seq = rs.getShort(5);
                    if (pk == null) {
                        String pkName = rs.getString(6);
                        pkName = ModelUtil.hasLength((String)pkName) ? pkName : this.makePKName(pkSchemaName, pkTableName);
                        pk = new PKConstraint(pkName, rel);
                        pk.setID((DBObjectID)new NameBasedID("CONSTRAINT", pkName, rel.getID()));
                    }
                    cols.add(new ConCol(seq, i++, colName));
                }
                if (pk == null) break block8;
                for (ConCol col : cols) {
                    Column column = rel.getColumn(col.getColumnName());
                    if (column == null) continue;
                    column.setNotNull(true);
                    pk.addColumn(column);
                }
                if (pk.getColumnIDs().length > 0) {
                    rel.addConstraint(pk);
                    break block8;
                }
                rel.removeConstraint(pk);
            }
            catch (SQLException ex) {
                try {
                    this.checkUnsupportedOperation((DBObject)rel, ex);
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    throw throwable;
                }
                this.close(rs);
            }
        }
        this.close(rs);
    }

    protected void buildUKs(T rel) throws DBException {
    }

    protected void buildCCs(T rel) throws DBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildFKs(T rel) throws DBException {
        String relationName = this.getNameForDriver(rel.getName());
        ResultSet rs = null;
        try {
            rs = this.getForeignKeysMetadata(rel);
            this.buildFKsFromMetadata(rs, rel, relationName);
        }
        catch (SQLException ex) {
            if (!(rel instanceof View)) {
                this.checkUnsupportedOperation((DBObject)rel, ex);
            }
        }
        finally {
            this.close(rs);
        }
    }

    protected ResultSet getForeignKeysMetadata(T rel) throws SQLException {
        String relationName = this.getNameForDriver(rel.getName());
        DatabaseMetaData dmd = this.getConnection().getMetaData();
        String[] catAndSchema = this.getCatalogAndSchema(rel.getSchema());
        return dmd.getImportedKeys(catAndSchema[0], catAndSchema[1], relationName);
    }

    protected String makePKName(String pkSchemaName, String pkTableName) {
        StringBuffer buf = new StringBuffer();
        if (ModelUtil.hasLength((String)pkSchemaName)) {
            buf.append(pkSchemaName + '#');
        }
        buf.append(pkTableName + "#PK");
        return buf.toString();
    }

    protected void buildFKsFromMetadata(ResultSet rs, T rel, String relationName) throws DBException {
        String schemaName = this.isUseSchema() && rel.getSchema() != null ? rel.getSchema().getName() : null;
        HashMap<String, FKConstraint> fkMap = new HashMap<String, FKConstraint>();
        MultiMap fkColsMap = new MultiMap(TreeSet.class);
        boolean bogusRefConInfo = false;
        try {
            int i = 0;
            TreeSet<Short> seqs = new TreeSet<Short>();
            while (rs.next()) {
                String pkSchemaName;
                if (relationName == null && !rs.getString(7).equals(rel.getName())) continue;
                String string = pkSchemaName = this.getDatabase().catalogIsSchema() ? rs.getString(1) : rs.getString(2);
                if (pkSchemaName == null) {
                    pkSchemaName = schemaName;
                }
                String pkTableName = rs.getString(3);
                String pkColName = rs.getString(4);
                String fkTableName = rs.getString(7);
                String fkColName = rs.getString(8);
                short seq = rs.getShort(9);
                if (rs.wasNull() || seqs.contains(seq)) {
                    bogusRefConInfo = true;
                } else {
                    seqs.add(seq);
                }
                short keyDelete = rs.getShort(11);
                String fkName = rs.getString(12);
                String pkName = rs.getString(13);
                if (rs.wasNull() || !ModelUtil.hasLength((String)pkName)) {
                    pkName = this.makePKName(pkSchemaName, pkTableName);
                }
                Schema pkSchema = null;
                try {
                    pkSchema = this.getDatabase().getSchema(pkSchemaName);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                short keyDeferrability = rs.getShort(14);
                String fkLookupName = ModelUtil.hasLength((String)fkName) ? fkName : pkTableName + "." + pkName;
                FKConstraint fk = (FKConstraint)fkMap.get(fkLookupName);
                if (fk == null) {
                    fk = new FKConstraint(fkName, rel);
                    NameBasedID fkID = new NameBasedID((DBObject)fk, rel.getID());
                    fk.setID((DBObjectID)fkID);
                    NameBasedID pkParentID = new NameBasedID("TABLE", pkSchemaName, pkTableName, (AbstractDBObjectProvider)this.getDatabase());
                    NameBasedID pkID = new NameBasedID("CONSTRAINT", pkName, (DBObjectID)pkParentID);
                    fk.setReferenceID((DBObjectID)pkID);
                    fkMap.put(fkLookupName, fk);
                    FKConstraint.ReferentialAction onDelete = this.getFkOnDeleteAction(keyDelete);
                    fk.setOnDeleteAction(onDelete);
                    Object defState = keyDeferrability == 5 ? Constraint.DeferrableState.DEFER_INIT_DEFERRED : (keyDeferrability == 6 ? Constraint.DeferrableState.DEFER_INIT_IMMEDIATE : null);
                    fk.setDeferrableState(defState);
                }
                fkColsMap.add((Object)fkLookupName, (Object)new ConCol(seq, i++, fkColName, pkColName));
            }
        }
        catch (SQLException ex) {
            this.checkUnsupportedOperation((DBObject)rel, ex);
        }
        for (Map.Entry entry : fkMap.entrySet()) {
            TreeSet<ConCol> fkCols;
            FKConstraint fk;
            block21: {
                fk = (FKConstraint)entry.getValue();
                fkCols = fkColsMap.get(entry.getKey());
                if (!this.trustReferencedConstraintInfo() || bogusRefConInfo && fkCols.size() > 1) {
                    try {
                        Table refTable;
                        DBObjectID pkID = fk.getReferenceID();
                        UniqueConstraint refCon = (UniqueConstraint)pkID.resolveID();
                        if (refCon == null && pkID.getParent() != null && (refTable = (Table)pkID.getParent().resolveID()) != null) {
                            refCon = PKConstraint.getPrimaryKey((Relation)refTable);
                        }
                        if (refCon == null) {
                            DBLog.getLogger((Object)((Object)this)).warning("Unable to recover unique key " + pkID + " referenced by foreign key " + DBUtil.getFullyQualifiedName((DBObject)fk));
                            break block21;
                        }
                        DBObjectID[] refConColIDs = refCon.getColumnIDs();
                        if (refConColIDs.length != fkCols.size()) {
                            DBLog.getLogger((Object)((Object)this)).warning("Unable to reference unique key " + pkID + " from foreign key " + DBUtil.getFullyQualifiedName((DBObject)fk) + " because their column lists are different sizes.");
                            break block21;
                        }
                        TreeSet<ConCol> rsFKCols = fkCols;
                        fkCols = new TreeSet<ConCol>();
                        int iteration = 0;
                        for (ConCol fkCol : rsFKCols) {
                            String refColName = fkCol.getReferencedColumnName();
                            int found = -1;
                            for (int refConColIndex = 0; refConColIndex < refConColIDs.length; ++refConColIndex) {
                                DBObjectID otherID = refConColIDs[refConColIndex];
                                if (!this.getDatabase().getDescriptor().areNamesEqual(refColName, DBUtil.getDBObjectName((DBObjectID)otherID), "COLUMN", false)) continue;
                                found = refConColIndex;
                                break;
                            }
                            if (found < 0) {
                                fkCols = rsFKCols;
                                break;
                            }
                            fkCols.add(new ConCol((short)found, iteration++, fkCol.getColumnName(), refColName));
                        }
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger((Object)((Object)this)).warning("Error checking " + fk.getName() + ": " + dbe.getMessage());
                    }
                }
            }
            for (ConCol conCol : fkCols) {
                fk.addColumn(rel.getColumn(conCol.getColumnName()));
            }
            rel.addConstraint((Constraint)fk);
        }
    }

    protected FKConstraint.ReferentialAction getFkOnDeleteAction(short keyDelete) {
        Object onDelete = keyDelete == 1 ? FKConstraint.ReferentialAction.RESTRICT : (keyDelete == 0 ? FKConstraint.ReferentialAction.CASCADE : (keyDelete == 2 ? FKConstraint.ReferentialAction.SET_NULL : (keyDelete == 4 ? FKConstraint.ReferentialAction.SET_DEFAULT : (keyDelete == 3 ? FKConstraint.ReferentialAction.NO_ACTION : null))));
        return onDelete;
    }

    protected boolean trustReferencedConstraintInfo() {
        return true;
    }

    private static class ConCol
    implements Comparable {
        private final short m_seq;
        private final int m_iteration;
        private final String m_colName;
        private final String m_refColName;

        ConCol(short seq, int iteration, String colName) {
            this(seq, iteration, colName, null);
        }

        ConCol(short seq, int iteration, String colName, String refColName) {
            this.m_seq = seq;
            this.m_iteration = iteration;
            this.m_colName = colName;
            this.m_refColName = refColName;
        }

        public String getColumnName() {
            return this.m_colName;
        }

        public String getReferencedColumnName() {
            return this.m_refColName;
        }

        public int compareTo(Object o) {
            ConCol other = (ConCol)o;
            int retval = this.m_seq == other.m_seq ? this.m_iteration - other.m_iteration : this.m_seq - other.m_seq;
            return retval;
        }
    }
}

