/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDynamicServer11;
import oracle.javatools.db.informix.InformixDynamicServer11Descriptor;
import oracle.javatools.db.informix.InformixDynamicServer11Impl;
import oracle.javatools.db.informix.InformixDynamicServerDescriptor;
import oracle.javatools.db.informix.InformixDynamicServerImpl;

public class InformixDynamicServerFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getInformixConnectionType(conn);
        switch (t) {
            case 100: {
                return new InformixDynamicServerImpl(connStore, connName, conn);
            }
            case 115: {
                return new InformixDynamicServer11Impl(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getInformixConnectionType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                if (driverName.indexOf("Informix") > -1 || driverName.indexOf("iclit09b") > -1) {
                    int v = dmd.getDatabaseMajorVersion();
                    if (v >= 9) {
                        return 115;
                    }
                    return 100;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        InformixDynamicServerDescriptor retval = null;
        if (InformixDynamicServer11.class.isAssignableFrom(providerClass)) {
            retval = new InformixDynamicServer11Descriptor(providerClass);
        } else if (InformixDatabase.class.isAssignableFrom(providerClass)) {
            retval = new InformixDynamicServerDescriptor(providerClass);
        }
        return retval;
    }
}

