/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.hive.HiveTableBuilder;
import oracle.javatools.util.ModelUtil;

public class HivePartitionBuilder
extends AbstractDBObjectBuilder<HivePartition> {
    public HivePartitionBuilder(HiveDatabaseImpl db) {
        super((AbstractDBObjectProvider)db, "HivePartition");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"HiveStorageProperties", "HiveSkewProperties"})
    public void buildUsingDescribe(HivePartition part) throws DBException {
        String partName = part.getName();
        Table tab = (Table)DBUtil.findParentOfType((DBObject)part, Table.class);
        if (tab != null && ModelUtil.hasLength((String)partName)) {
            HiveDatabaseImpl db = (HiveDatabaseImpl)this.getProvider();
            HiveTableBuilder.DescribeBuilder describe = new HiveTableBuilder.DescribeBuilder(db);
            describe.describe("describe formatted " + DBUtil.getFullyQualifiedName((DBObject)tab, (boolean)true) + " partition(" + partName + ")", tab);
            HiveStorageProperties hsp = new HiveStorageProperties();
            part.setProperty("HiveStorageProperties", (Object)hsp);
            describe.extractProperties(HiveTableBuilder.s_propertyMap, (DBObject)hsp);
            describe.extractSkew((DBObject)part);
        }
    }
}

