/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.db2.DB2DDLType;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.db2.DB2v9UniversalDatabaseImpl;
import oracle.javatools.db.ddl.BundleDDLGenerator;

class DB2DDLGenerator
extends BundleDDLGenerator<DB2DDLType> {
    private static final String BASE = "/oracle/javatools/db/db2/";
    private static final String DB2_DDL_BASE = "/oracle/javatools/db/db2/DB2DDL.properties";
    private static final String DB2_V9_DDL = "/oracle/javatools/db/db2/DB2v9DDL.properties";

    public DB2DDLGenerator(Class<? extends DB2UniversalDatabase> dbClz, DBObjectProvider pro) {
        super(dbClz, pro, DB2DDLGenerator.getBundles(dbClz));
    }

    protected DB2DDLType getDDLType(String type) {
        return DB2DDLType.getDDLType(type);
    }

    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        if (property.equals("onDeleteAction")) {
            return Arrays.asList(FKConstraint.ReferentialAction.RESTRICT, FKConstraint.ReferentialAction.CASCADE, FKConstraint.ReferentialAction.SET_NULL, FKConstraint.ReferentialAction.NO_ACTION);
        }
        if (updatedObject instanceof Index && "indexType".equals(property)) {
            ArrayList<Index.IndexType> c = new ArrayList<Index.IndexType>();
            c.add(Index.IndexType.NORMAL);
            c.add(Index.IndexType.UNIQUE);
            return c;
        }
        return super.getAllowedPropertyValues(originalObject, updatedObject, property);
    }

    private static String[] getBundles(Class<? extends DB2UniversalDatabase> clz) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add(DB2_DDL_BASE);
        if (DB2v9UniversalDatabaseImpl.class.isAssignableFrom(clz)) {
            retval.add(DB2_V9_DDL);
        }
        return retval.toArray(new String[retval.size()]);
    }
}

