/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.math.BigDecimal;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.PredefinedDataType;

public class NumericDataType
extends PredefinedDataType {
    public static final DataTypeAttribute UNSIGNED = new DataTypeAttribute("unsigned", "DATATYPE_ATTRIBUTE_LABEL_UNSIGNED", new String[]{"UNSIGNED"}, null, false, false);
    public static final MinMaxValue MIN_MAX_BIGINT = new MinMaxValue("-9223372036854775808", "9223372036854775807", MinMaxValue.SIGNED_INT);
    public static final MinMaxValue MIN_MAX_INT = new MinMaxValue("-2147483648", "2147483647", MinMaxValue.SIGNED_INT);
    public static final MinMaxValue MIN_MAX_MEDIUMINT = new MinMaxValue("-8388608", "8388607", MinMaxValue.SIGNED_INT);
    public static final MinMaxValue MIN_MAX_SMALLINT = new MinMaxValue("-32768", "32767", MinMaxValue.SIGNED_INT);
    public static final MinMaxValue MIN_MAX_SIGNED_TINYINT = new MinMaxValue("-128", "127", MinMaxValue.SIGNED_INT);
    public static final MinMaxValue MIN_MAX_UNSIGNED_TINYINT = new MinMaxValue("0", "255", MinMaxValue.UNSIGNED_INT);
    public static final MinMaxValue MIN_MAX_MONEY = new MinMaxValue("-922337203685477.5808", "922337203685477.5807", MinMaxValue.SIGNED_INT);
    public static final MinMaxValue MIN_MAX_SMALLMONEY = new MinMaxValue("-214748.3648", "214748.3647", MinMaxValue.SIGNED_INT);
    public static final MinMaxValue MIN_MAX_BIT = new MinMaxValue("0", "1", MinMaxValue.UNSIGNED_INT);

    public NumericDataType() {
    }

    public NumericDataType(int domain, String name, MinMaxValue minMaxValues) {
        super(domain, name);
        this.setMinMaxValues(minMaxValues);
    }

    public NumericDataType(int domain, String name, String definition, DataTypeAttribute[] attributes, MinMaxValue minMaxValues) {
        super(domain, name, definition, attributes);
        this.setMinMaxValues(minMaxValues);
    }

    public NumericDataType(int domain, String name, String definition, long minPrecision, long maxPrecision, Long defaultPrecision, boolean isPrecisionMandatory, DataTypeAttribute[] attributes, MinMaxValue minMaxValues) {
        super(domain, name, definition, attributes);
        this.setMinMaxValues(minMaxValues);
        this.addAttribute(new DataTypeAttribute("precision", "DATATYPE_ATTRIBUTE_LABEL_PRECISION", minPrecision, Long.valueOf(maxPrecision), defaultPrecision, isPrecisionMandatory), 0);
    }

    public NumericDataType(int domain, String name, String definition, long minPrecision, long maxPrecision, Long defaultPrecision, boolean isPrecisionMandatory, long minScale, Long maxScale, Long defaultScale, boolean isScaleMandatory, DataTypeAttribute[] attributes, MinMaxValue minMaxValues) {
        super(domain, name, definition, attributes);
        this.setMinMaxValues(minMaxValues);
        this.addAttribute(new DataTypeAttribute("precision", "DATATYPE_ATTRIBUTE_LABEL_PRECISION", minPrecision, Long.valueOf(maxPrecision), defaultPrecision, isPrecisionMandatory), 0);
        this.addAttribute(new DataTypeAttribute("scale", "DATATYPE_ATTRIBUTE_LABEL_SCALE", minScale, maxScale, defaultScale, isScaleMandatory), 1);
    }

    private void setMinMaxValues(MinMaxValue minMaxValues) {
        if (minMaxValues != null) {
            this.setValueType(minMaxValues.getValueType());
            this.setMinValue(minMaxValues.getMinValue());
            this.setMaxValue(minMaxValues.getMaxValue());
        }
    }

    public static class MinMaxValue {
        public static final PredefinedDataType.ValueType SIGNED_INT = PredefinedDataType.ValueType.SIGNED_INT;
        public static final PredefinedDataType.ValueType UNSIGNED_INT = PredefinedDataType.ValueType.UNSIGNED_INT;
        public static final PredefinedDataType.ValueType FLOAT = PredefinedDataType.ValueType.FLOAT;
        private BigDecimal m_minValue;
        private BigDecimal m_maxValue;
        private PredefinedDataType.ValueType m_valueType;

        public MinMaxValue() {
        }

        public MinMaxValue(String minValue, String maxValue, PredefinedDataType.ValueType valueType) {
            this.m_minValue = new BigDecimal(minValue);
            this.m_maxValue = new BigDecimal(maxValue);
            this.m_valueType = valueType;
            assert (this.m_valueType == FLOAT || this.m_valueType == SIGNED_INT || this.m_valueType == UNSIGNED_INT);
        }

        public BigDecimal getMinValue() {
            return this.m_minValue;
        }

        public BigDecimal getMaxValue() {
            return this.m_maxValue;
        }

        public PredefinedDataType.ValueType getValueType() {
            return this.m_valueType;
        }
    }
}

