/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.diff.DefaultResultSetFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ConstraintIndexHelper {
    private final DBObjectProvider m_pro;
    private final Table m_table;
    private final Collection<Index> m_deletedIndexes;
    private final boolean m_supported;

    public ConstraintIndexHelper(DBObjectProvider pro, Table table) {
        this.m_pro = pro;
        this.m_table = table;
        this.m_deletedIndexes = new ArrayList<Index>();
        this.m_supported = this.m_pro.getPropertyManager().canCreateProperty((SystemObject)this.m_table, Property.createPath((String[])new String[]{"constraints", "indexID"}));
    }

    public boolean isSupported() {
        return this.m_supported;
    }

    private String getOriginalTableName() {
        DBObject orig;
        String retval = this.m_table.getName();
        DBObjectID id = this.m_table.getID();
        if (id instanceof TemporaryObjectID && (orig = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)id))) != null) {
            retval = orig.getName();
        }
        return retval;
    }

    public void ensureAndValidateIndexes(UniqueConstraint uk, ValidationLevel level) throws ValidationException {
        if (this.isSupported()) {
            ConstraintIndexHelper.clearIndexIDIfInvalid(uk, this.m_pro);
            DBObjectID currentID = uk.getIndexID();
            this.ensureIndexes(uk);
            String relName = this.m_table.getName();
            String origRelName = this.getOriginalTableName();
            try {
                this.m_table.setName(origRelName);
                ((AbstractDBObjectProvider)this.m_pro).validate(new ValidationContext(null, (DBObject)this.m_table, level, new String[]{"indexes"}));
            }
            catch (ValidationException e) {
                DBObjectID newID = uk.getIndexID();
                if (currentID == null && newID != null) {
                    Index index = (Index)this.m_table.findOwnedObject(newID);
                    if (index != null) {
                        this.m_table.removeIndex(index);
                    }
                    uk.setIndexID(null);
                }
                throw e;
            }
            finally {
                this.m_table.setName(relName);
            }
        }
    }

    public void ensureIndexes(UniqueConstraint uk) {
        ConstraintIndexHelper.ensureIndexes(this.m_pro, this.m_table, uk, this.m_deletedIndexes);
    }

    public void clearNewUnusedIndexes(Table tab) {
        ConstraintIndexHelper.clearNewUnusedIndexes(tab, this.m_deletedIndexes);
    }

    private static void clearNewUnusedIndexes(Table tab, Collection<Index> deletedIndexes) {
        ArrayList<Index> indexesToDelete = new ArrayList<Index>();
        for (Index index : tab.getIndexes()) {
            if (!ConstraintIndexHelper.isSystemGenerated(index) || !ConstraintIndexHelper.isNew((DBObject)index) || ConstraintIndexHelper.isForAConstraint(index)) continue;
            indexesToDelete.add(index);
        }
        for (Index index : indexesToDelete) {
            deletedIndexes.add(index);
            tab.removeIndex(index);
        }
    }

    public static UniqueConstraint forConstraint(Index index) {
        UniqueConstraint ret = null;
        if (index != null && index.getTable() != null) {
            for (Constraint c : index.getTable().getConstraints()) {
                if (!(c instanceof UniqueConstraint) || index.getID() == null || !index.getID().equals(((UniqueConstraint)c).getIndexID())) continue;
                ret = (UniqueConstraint)c;
                break;
            }
        }
        return ret;
    }

    public static boolean isForAConstraint(Index index) {
        return ConstraintIndexHelper.forConstraint(index) != null;
    }

    public static boolean isSystemGenerated(Index index) {
        Boolean retval = index.getSystemGenerated();
        if (retval == null) {
            retval = false;
            UniqueConstraint uk = ConstraintIndexHelper.forConstraint(index);
            if (uk != null && ConstraintIndexHelper.indexDefaultForConstraint(index, uk)) {
                retval = true;
            }
        }
        return retval;
    }

    public static boolean ensureIndexes(DBObjectProvider pro, Table updTable, UniqueConstraint updUK) {
        ArrayList<Index> deletedIndexes = new ArrayList<Index>();
        return ConstraintIndexHelper.ensureIndexes(pro, updTable, updUK, deletedIndexes);
    }

    public static boolean ensureIndexes(DBObjectProvider pro, Table updTable, UniqueConstraint updUK, Collection<Index> deletedIndexes) {
        UniqueConstraint origUK = null;
        if (updUK != null && updUK.getID() instanceof TemporaryObjectID) {
            try {
                origUK = (UniqueConstraint)((TemporaryObjectID)updUK.getID()).resolveOriginalID();
            }
            catch (DBException dbe) {
                DBLog.getLogger().warning(dbe.getMessage());
            }
        }
        return ConstraintIndexHelper.ensureIndexes(pro, updTable, updUK, origUK, deletedIndexes);
    }

    public static boolean ensureIndexes(DBObjectProvider pro, Table updTable, UniqueConstraint updUK, UniqueConstraint origUK, Collection<Index> deletedIndexes) {
        return ConstraintIndexHelper.ensureIndexes(pro, updTable, updUK, origUK, deletedIndexes, null);
    }

    public static boolean ensureIndexes(DBObjectProvider pro, Table updTable, UniqueConstraint updUK, UniqueConstraint origUK, Collection<Index> deletedIndexes, Set<String> existingIndexes) {
        Table origTable;
        boolean change = false;
        ArrayList<Index> previouslyDeletedIndexes = new ArrayList<Index>();
        previouslyDeletedIndexes.addAll(deletedIndexes);
        if (pro == null) {
            throw new IllegalArgumentException("pro should not be null");
        }
        Boolean supported = ModelUtil.areEqual((Object)"Oracle Database", (Object)pro.getDescriptor().getDatabaseType());
        if (!supported.booleanValue()) {
            return change;
        }
        if (updUK == null && origUK == null) {
            throw new IllegalArgumentException("updUK or origUK should not be null");
        }
        if (origUK == null) {
            origTable = null;
        } else {
            origTable = (Table)origUK.getParent();
            DBObjectID id = origUK.getIndexID();
            if (id != null) {
                Index indexInOrig = (Index)origTable.findOwnedObject(id);
                Index indexInUpd = null;
                for (Index i : updTable.getIndexes()) {
                    if (!(i.getID() instanceof TemporaryObjectID)) continue;
                    try {
                        Index idx = (Index)((TemporaryObjectID)i.getID()).resolveOriginalID();
                        if (idx != indexInOrig) continue;
                        indexInUpd = i;
                        break;
                    }
                    catch (DBException e) {
                        DBLog.getLogger().warning(e.getMessage());
                    }
                }
                if (indexInUpd != null && ConstraintIndexHelper.isSystemGenerated(indexInUpd)) {
                    boolean delete = false;
                    int removeRef = 0;
                    if (updUK == null || updUK.getColumnIDs().length == 0 || !updUK.isEnabled()) {
                        delete = indexInUpd.getIndexType() == Index.IndexType.UNIQUE;
                        removeRef = updUK != null ? 1 : 0;
                    } else if (pro != null && updUK != null && updUK.getColumnIDs().length > 0) {
                        Difference rs = pro.getDiffEngine().difference((Object)origUK, (Object)updUK);
                        DefaultResultSetFilter df = new DefaultResultSetFilter();
                        df.addFilteredProps("name");
                        df.addFilteredProps("enabled");
                        DBObjectID origUKIndexId = origUK.getIndexID();
                        DBObjectID updUKIndexId = updUK.getIndexID();
                        if (origUKIndexId != null) {
                            DBObject o;
                            if (updUKIndexId == null) {
                                df.addFilteredProps("indexID");
                            } else if (updUKIndexId instanceof TemporaryObjectID && (o = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)updUKIndexId))) != null && o.getID().equals(origUKIndexId)) {
                                df.addFilteredProps("indexID");
                            }
                        }
                        if (!(rs = rs.getFilteredDifference(new DifferenceFilter[]{df})).isSame()) {
                            delete = true;
                            removeRef = 1;
                        }
                    }
                    if (delete) {
                        deletedIndexes.add(indexInUpd);
                        updTable.removeIndex(indexInUpd);
                        change = true;
                    }
                    if (removeRef != 0) {
                        updUK.setIndexID(null);
                        change = true;
                    }
                }
            }
        }
        if (updUK != null) {
            ConstraintIndexHelper.clearNewUnusedIndexes(updTable, deletedIndexes);
            DBObjectID indexID = updUK.getIndexID();
            if (indexID != null) {
                if (updUK.isEnabled()) {
                    return change;
                }
                updUK.setIndexID(null);
                return true;
            }
            if (updUK.getColumnIDs().length == 0 || !updUK.isEnabled()) {
                return change;
            }
            Index reqdIndex = null;
            for (Index index : previouslyDeletedIndexes) {
                updTable.addIndex(index);
                if (ConstraintIndexHelper.indexValidForConstraint(index, updUK, pro)) {
                    reqdIndex = index;
                    break;
                }
                updTable.removeIndex(index);
            }
            if (reqdIndex != null) {
                deletedIndexes.remove(reqdIndex);
                updUK.setIndexID(reqdIndex.getID());
                return true;
            }
            for (Index index : updTable.getIndexes()) {
                if (!ConstraintIndexHelper.indexValidForConstraint(index, updUK, pro)) continue;
                updUK.setIndexID(index.getID());
                return true;
            }
            Index index = ConstraintIndexHelper.getDefaultIndex(pro, updTable, updUK);
            boolean checkName = true;
            for (Index i : deletedIndexes) {
                if (!index.getName().equals(i.getName())) continue;
                checkName = false;
                break;
            }
            if (checkName) {
                String name;
                if (existingIndexes != null) {
                    name = index.getName();
                    int i = 2;
                    while (existingIndexes.contains(name)) {
                        name = index.getName() + i;
                        ++i;
                    }
                    existingIndexes.add(name);
                    index.setName(name);
                } else if (pro != null) {
                    name = pro.getUniqueName("INDEX", (DBObject)updTable.getSchema(), index.getName());
                    index.setName(name);
                }
            }
            updTable.addIndex(index);
            Index origIndex = null;
            if (origTable != null) {
                origIndex = origTable.getIndex(index.getName());
            }
            indexID = TemporaryObjectID.createID((DBObject)index, origIndex);
            index.setID(indexID);
            updUK.setIndexID(indexID);
            return true;
        }
        return change;
    }

    public static void validateIndexForConstraint(Index index, UniqueConstraint con, DBObjectProvider pro, boolean allowMultipleIndexUsage) throws ValidationException {
        IndexObject[] indexExpressions = index.getColumnExpressions();
        if (index == null || indexExpressions.length == 0) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)"CONIDX_NULL_INDEX_ERR"));
        }
        DBObjectID[] constrColIDs = con.getColumnIDs();
        if (con == null || constrColIDs.length == 0) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)"CONIDX_NULL_CONSTAINT_ERR"));
        }
        Table table = index.getTable();
        if (con.getParent() != table) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)"CONIDX_DIFFERENT_TABLE_ERR"));
        }
        Index.IndexType indexType = index.getIndexType();
        if (indexType != Index.IndexType.NORMAL && indexType != Index.IndexType.UNIQUE) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)"CONIDX_INDEX_TYPE_ERR"));
        }
        if (con.getDeferrableState() != null && indexType == Index.IndexType.UNIQUE) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)"CONIDX_DEFERRABLE_UNIQUE_ERR"));
        }
        boolean expressionsOK = true;
        if (indexType == Index.IndexType.UNIQUE && indexExpressions.length != constrColIDs.length) {
            expressionsOK = false;
        } else if (indexType == Index.IndexType.NORMAL && indexExpressions.length < constrColIDs.length) {
            expressionsOK = false;
        } else {
            ArrayList<DBObjectID> indexColIdList = new ArrayList<DBObjectID>();
            for (int i = 0; i < constrColIDs.length; ++i) {
                Column col;
                IndexObject io = indexExpressions[i];
                String ioexp = io.getExpressionSource();
                if (pro != null) {
                    ioexp = pro.getInternalName(ioexp);
                }
                if ((col = table.getColumn(ioexp)) == null || IndexObject.OrderType.DESC.equals((Object)io.getOrderType())) {
                    expressionsOK = false;
                    break;
                }
                indexColIdList.add(col.getID());
            }
            DBObjectID[] dBObjectIDArray = constrColIDs;
            int n = dBObjectIDArray.length;
            for (int ioexp = 0; ioexp < n; ++ioexp) {
                DBObjectID colId = dBObjectIDArray[ioexp];
                if (indexColIdList.contains(colId)) continue;
                expressionsOK = false;
                break;
            }
        }
        if (!expressionsOK) {
            throw new ValidationException((DBObject)con, APIBundle.format((String)"CONIDX_MISMATCH_ERR", (Object[])new Object[]{index.getName(), con.getName()}));
        }
        if (!allowMultipleIndexUsage) {
            for (Constraint c : ((Table)con.getParent()).getConstraints()) {
                UniqueConstraint uk;
                if (!(c instanceof UniqueConstraint) || c == con || (uk = (UniqueConstraint)c).getIndexID() == null || !uk.getIndexID().equals(index.getID())) continue;
                throw new ValidationException((DBObject)con, APIBundle.format((String)"CONIDX_INDEX_USED_ERR", (Object[])new Object[]{index.getName(), con.getName()}));
            }
        }
    }

    public static boolean indexValidForConstraint(Index index, UniqueConstraint con, DBObjectProvider pro) {
        try {
            ConstraintIndexHelper.validateIndexForConstraint(index, con, pro, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    public static boolean clearIndexIDIfInvalid(UniqueConstraint con, DBObjectProvider pro) {
        Index index;
        Table tab;
        boolean retval = false;
        DBObjectID indexID = con.getIndexID();
        if (indexID != null && (tab = (Table)con.getParent()) != null && (index = (Index)tab.findOwnedObject(indexID)) != null && !ConstraintIndexHelper.indexValidForConstraint(index, con, pro)) {
            con.setIndexID(null);
            retval = true;
        }
        return retval;
    }

    public static boolean indexDefaultForConstraint(Index index, UniqueConstraint con) {
        return ConstraintIndexHelper.indexDefaultForConstraint(index, con, null);
    }

    public static boolean indexDefaultForConstraint(Index index, UniqueConstraint con, DBObjectProvider pro) {
        MyDifferenceFilter filter1;
        if (index == null || con == null) {
            return false;
        }
        if (index.getSystemGenerated() == Boolean.FALSE) {
            return false;
        }
        if (!index.getName().equals(con.getName())) {
            return false;
        }
        if (index.getColumnExpressions().length == 0 || index.getColumnExpressions().length != con.getColumnIDs().length) {
            return false;
        }
        if (!ConstraintIndexHelper.indexValidForConstraint(index, con, pro)) {
            return false;
        }
        Index defIndex = ConstraintIndexHelper.getDefaultIndex(null, index.getTable(), con);
        Difference diff = GenericDiffEngine.getDiffEngine((boolean)false).difference((Object)index, (Object)defIndex);
        Difference filteredDiff = diff.getFilteredDifference(new DifferenceFilter[]{filter1 = new MyDifferenceFilter(pro, defIndex)});
        if (!filteredDiff.isSame()) {
            DefaultResultSetFilter filter2 = new DefaultResultSetFilter();
            filter2.addFilteredProps("columnExpressions");
            filteredDiff = filteredDiff.getFilteredDifference(new DifferenceFilter[]{filter2});
            if (filteredDiff.isSame()) {
                IndexObject[] ios = index.getColumnExpressions();
                IndexObject[] defIOs = defIndex.getColumnExpressions();
                for (int i = 0; i < ios.length; ++i) {
                    if (IndexObject.OrderType.DESC.equals((Object)ios[i].getOrderType())) {
                        return false;
                    }
                    if (!ModelUtil.areDifferent((Object)ios[i].getExpressionSource(), (Object)defIOs[i].getExpressionSource())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static Index getDefaultIndex(DBObjectProvider pro, Table table, UniqueConstraint con) {
        Index index = new Index();
        index.setName(con.getName());
        Index.IndexType indexType = Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType") && con instanceof PKConstraint ? Index.IndexType.UNIQUE : (con.getDeferrableState() == null ? Index.IndexType.UNIQUE : Index.IndexType.NORMAL);
        index.setIndexType(indexType);
        index.setSystemGenerated(Boolean.valueOf(true));
        DBObjectID[] colIDs = con.getColumnIDs();
        IndexObject[] ios = new IndexObject[colIDs.length];
        int i = 0;
        for (DBObjectID colID : colIDs) {
            ColumnUsage cu = new ColumnUsage(colID);
            cu.setProvider(pro);
            IndexObject io = new IndexObject();
            io.setExpression((SQLFragment)cu);
            io.setOrderType(IndexObject.OrderType.ASC);
            ios[i++] = io;
        }
        index.setColumnExpressions(ios);
        if (pro instanceof Database) {
            index.setReverse(Boolean.valueOf(false));
        }
        return index;
    }

    private static boolean isNew(DBObject obj) {
        if (obj.getID() instanceof TemporaryObjectID) {
            try {
                DBObject orig = ((TemporaryObjectID)obj.getID()).resolveOriginalID();
                if (orig == null) {
                    return true;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return false;
    }

    private static class MyDifferenceFilter
    implements DifferenceFilter {
        private final DBObjectProvider m_pro;
        private final Index m_index;
        private final DDLGenerator m_ddlGen;
        private final PropertyManager m_propMgr;

        public MyDifferenceFilter(DBObjectProvider pro, Index index) {
            this.m_pro = pro;
            this.m_index = index;
            this.m_ddlGen = pro == null ? null : pro.getDDLGenerator();
            this.m_propMgr = pro == null ? null : pro.getPropertyManager();
        }

        public boolean isFilteredProperty(Difference diff, String prop) {
            String propPath = diff.getPropertyPath();
            if (diff.isLeaf()) {
                Object orig;
                Object def;
                Object upd;
                if ("schema".equals(prop)) {
                    return true;
                }
                if (this.m_ddlGen != null && !this.m_ddlGen.canCreateProperty((SystemObject)this.m_index, propPath)) {
                    return true;
                }
                if (this.m_pro instanceof Database && "reverse".equals(prop) && diff.getUpdatedObject() == null && Boolean.FALSE.equals(diff.getOriginalObject())) {
                    return true;
                }
                if (this.m_propMgr != null && (upd = diff.getUpdatedObject()) == null && ModelUtil.areEqual((Object)(def = this.m_propMgr.getImplicitDefaultValue((DBObject)this.m_index, propPath)), (Object)(orig = diff.getOriginalObject()))) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Processor
    extends UpdateProcessor {
        public void processUpdate(DBObjectTransaction txn, Difference objDiff) {
            DBObjectProvider pro = txn.getProvider();
            boolean supported = ModelUtil.areEqual((Object)"Oracle Database", (Object)pro.getDescriptor().getDatabaseType()) && objDiff.getUpdatedObject() instanceof Table;
            boolean legacyIndexes = false;
            if (supported) {
                PropertyHelper propHelper = new PropertyHelper();
                Table orgTable = (Table)objDiff.getOriginalObject();
                Table updTable = (Table)objDiff.getUpdatedObject();
                boolean checkIndexes = true;
                if (orgTable != null && TemporaryObjectID.findOriginalObject((DBObject)updTable) == orgTable) {
                    boolean bl = checkIndexes = objDiff.getChildDifference("constraints", true) != null || objDiff.getChildDifference("indexes", true) != null;
                }
                if (checkIndexes) {
                    boolean changedThisTable = false;
                    if (orgTable == null) {
                        for (Constraint c : updTable.getConstraints()) {
                            ArrayList<Index> deletedIndexes;
                            boolean res;
                            if (!(c instanceof UniqueConstraint) || !(res = ConstraintIndexHelper.ensureIndexes(pro, updTable, (UniqueConstraint)c, null, deletedIndexes = new ArrayList<Index>()))) continue;
                            changedThisTable = true;
                        }
                    } else {
                        Index[] allConstrRs = objDiff.getChildDifference("constraints", true);
                        if (allConstrRs != null) {
                            for (Difference constrRs : allConstrRs.getChildren()) {
                                ArrayList<Index> deletedIndexes;
                                boolean res;
                                if (constrRs.isSame()) continue;
                                DBObject updCon = (DBObject)constrRs.getUpdatedObject();
                                DBObject origCon = (DBObject)constrRs.getOriginalObject();
                                if (!(origCon instanceof UniqueConstraint) && !(updCon instanceof UniqueConstraint) || !(res = ConstraintIndexHelper.ensureIndexes(pro, updTable, (UniqueConstraint)updCon, (UniqueConstraint)origCon, deletedIndexes = new ArrayList<Index>()))) continue;
                                changedThisTable = true;
                            }
                        }
                    }
                    for (Index index : updTable.getIndexes()) {
                        Boolean sysGen = index.getSystemGenerated();
                        if (sysGen == null) {
                            legacyIndexes = true;
                            continue;
                        }
                        if (!sysGen.booleanValue() || ConstraintIndexHelper.isForAConstraint(index)) continue;
                        index.setSystemGenerated(Boolean.valueOf(false));
                        changedThisTable = true;
                    }
                    if (legacyIndexes && (!objDiff.isSame() || changedThisTable)) {
                        for (Index index : updTable.getIndexes()) {
                            if (index.getSystemGenerated() != null) continue;
                            index.setSystemGenerated(Boolean.valueOf(ConstraintIndexHelper.isSystemGenerated(index)));
                            changedThisTable = true;
                        }
                    }
                    if (changedThisTable) {
                        Difference diff = pro.getDiffEngine().difference((Object)orgTable, (Object)updTable);
                        diff.copyTo((Object)objDiff);
                    }
                }
            }
        }
    }
}

