/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class ColumnSequenceProcessor
extends UpdateProcessor {
    public static final String AUTO_GENERATED_SEQUENCE = "AUTO_GENERATED_SEQUENCE";
    public static final String AUTO_GENERATED_SEQUENCE_TRIGGER = "AUTO_GENERATED_SEQUENCE_TRIGGER";
    public static final String REUSE_SEQUENCE = "ColumnSequenceExpander.ReuseSequence";
    public static final String TRIGGER_NULL_CHECK = "ColumnSequenceExpander.TriggerNullCheck";
    @Deprecated
    public static final String NEW_SEQUENCE_NAME = "ColumnSequenceExpander.NewSequenceName";
    @Deprecated
    public static final String NEW_TRIGGER_NAME = "ColumnSequenceExpander.NewTriggerName";
    private static final String COLSEQ_SEARCH = "<<COLUMN_SEQUENCES>> BEGIN {^END COLUMN_SEQUENCES}... END COLUMN_SEQUENCES;";
    private static final String COLSEQ_STATEMENT_SEARCH = "<if [IF {^{THEN}}... THEN]> SELECT <seq ?.> INTO : ? .<col ?> FROM [SYS.]DUAL";
    private static final String EMPTY_CODE_SEARCH = "BEGIN <null NULL;> END;";
    private static final String COLSEQ_HEADER = "  <<COLUMN_SEQUENCES>>\n  BEGIN\n";
    private static final String COLSEQ_FOOTER = "  END COLUMN_SEQUENCES;\n";
    private static final String EMPTY_COLSEQ_BLOCK = "  <<COLUMN_SEQUENCES>>\n  BEGIN\n    NULL;\n  END COLUMN_SEQUENCES;\n";
    private static final String IF_INSERTING = "    IF INSERTING THEN\n  ";
    private static final String IF_INSERTING_AND_NULL = "    IF INSERTING AND :<NEW>.<COLUMN> IS NULL THEN\n  ";
    private static final String END_IF = "    END IF;\n";
    private static final String SELECT_INTO = "    SELECT <SEQUENCE>.NEXTVAL INTO :<NEW>.<COLUMN> FROM SYS.DUAL;\n";
    private static final String NEW_TOKEN = "<NEW>";
    private static final String COLUMN_TOKEN = "<COLUMN>";
    private static final String SEQUENCE_TOKEN = "<SEQUENCE>";
    private static final String TRIGGER_SUFFIX = "_TRG";
    private static final String SEQUENCE_SUFFIX = "_SEQ";
    private static final String END = "END";
    private static final String NEW = "NEW";
    private static final String NEXTVAL = "NEXTVAL";
    private static final Set<String> s_props = new HashSet<String>();

    public ColumnSequenceProcessor() {
        ColumnSequenceProcessor.getColumnSequenceProps();
    }

    public void processUpdate(DBObjectTransaction txn, Difference objDiff) {
        SystemObject upd = txn.getDiffUpdatedObject(objDiff);
        if (upd instanceof Table) {
            DBObjectID triggerID;
            Table table = (Table)upd;
            if (ModelUtil.areEqual((Object)Table.TableType.EXTERNAL, (Object)table.getProperty("TableType"))) {
                for (Column col : table.getColumns()) {
                    if (!ColumnSequenceProcessor.hasColumnSequenceProps(col)) continue;
                    ColumnSequenceProcessor.clearColumnSequenceProps(col);
                }
                return;
            }
            Schema proSchema = table.getSchema();
            Schema txnSchema = (Schema)txn.getCopyForUpdate((SystemObject)proSchema);
            if (proSchema != null && txnSchema != null && !proSchema.getName().equals(txnSchema.getName())) {
                return;
            }
            ArrayList<Difference> deletedColumnDiffs = new ArrayList<Difference>();
            ArrayList<Difference> newColumnDiffs = new ArrayList<Difference>();
            ArrayList<Difference> changedColumnDiffs = new ArrayList<Difference>();
            this.getColumnSequenceDiffs(objDiff, deletedColumnDiffs, newColumnDiffs, changedColumnDiffs);
            HashSet<DBObjectID> trigIdSet = new HashSet<DBObjectID>();
            for (Difference diff : deletedColumnDiffs) {
                Column col = (Column)diff.getOriginalObject();
                triggerID = (DBObjectID)col.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                if (triggerID == null) continue;
                trigIdSet.add(triggerID);
            }
            for (Difference diff : changedColumnDiffs) {
                DBObjectID triggerID2;
                if (!AUTO_GENERATED_SEQUENCE_TRIGGER.equals(diff.getPropertyName()) || diff.getOriginalObject() == null || (triggerID2 = (DBObjectID)diff.getOriginalObject()) == null) continue;
                trigIdSet.add(triggerID2);
            }
            for (DBObjectID id : trigIdSet) {
                this.setEmptyColSeqCode(id, txn);
            }
            trigIdSet.clear();
            if (objDiff.getOriginalObject() == null) {
                for (Column col : table.getColumns()) {
                    DBObjectID triggerID3 = (DBObjectID)col.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                    if (triggerID3 == null) continue;
                    trigIdSet.add(triggerID3);
                }
            }
            for (Difference diff : newColumnDiffs) {
                Column col = (Column)diff.getUpdatedObject();
                triggerID = (DBObjectID)col.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                if (triggerID == null) continue;
                trigIdSet.add(triggerID);
            }
            for (Difference diff : changedColumnDiffs) {
                Column col;
                if (diff.getUpdatedObject() == null || (triggerID = (DBObjectID)(col = (Column)diff.getParent().getParent().getUpdatedObject()).getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER)) == null) continue;
                trigIdSet.add(triggerID);
            }
            Holder tableUpdated = new Holder();
            tableUpdated.value = Boolean.FALSE;
            for (DBObjectID id : trigIdSet) {
                this.generateColSeqCode(table, id, txn, (Holder<Boolean>)tableUpdated);
            }
            if (((Boolean)tableUpdated.value).booleanValue()) {
                txn.includeUpdate(upd);
            }
        }
    }

    private void setColSeqBlock(Trigger trigger, String block, DBObjectTransaction txn) throws CancelledException {
        Trigger copy = (Trigger)txn.getCopyForUpdate((SystemObject)trigger);
        if (copy != null) {
            PlSqlParser parser;
            int start = -1;
            int end = -1;
            DBObjectProvider pro = txn.getProvider();
            if (copy.getSource() == null) {
                copy.setSource(PlSqlUtil.getDefaultSource(pro, (PlSqlSourceObject)copy));
            }
            if ((parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)copy, (DBObjectProvider)pro)) != null) {
                PlSqlSearch colSeqSearch = new PlSqlSearch(COLSEQ_SEARCH);
                PlSqlSearch emptyCodeSearch = new PlSqlSearch(EMPTY_CODE_SEARCH);
                if (colSeqSearch.isWithin(parser.getTokenAtOffset(0))) {
                    start = colSeqSearch.getStartToken().getStart();
                    end = colSeqSearch.getEndToken().getEnd() + 1;
                } else if (emptyCodeSearch.isWithin(parser.getTokenAtOffset(0))) {
                    start = emptyCodeSearch.getNamedMatchStartToken("null").getStart();
                    end = emptyCodeSearch.getNamedMatchEndToken("null").getEnd() + 1;
                } else {
                    PlSqlToken tk = parser.getTokenAtOffset(copy.getSource().length());
                    if (!tk.isCode()) {
                        tk = (PlSqlToken)tk.getPrevCodeToken();
                    }
                    while (!tk.matches(END) && tk.getStart() >= 10) {
                        tk = (PlSqlToken)tk.getPrevCodeToken();
                    }
                    if (tk.matches(END)) {
                        end = start = tk.getStart();
                    }
                }
                if (start > -1 && end >= start) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(copy.getSource().substring(0, start));
                    if (end == start) {
                        sb.append(block);
                    } else {
                        sb.append(block.trim());
                    }
                    sb.append(copy.getSource().substring(end));
                    copy.setSource(sb.toString());
                }
                txn.includeUpdate((SystemObject)copy);
            }
        }
    }

    private void setEmptyColSeqCode(DBObjectID trigID, DBObjectTransaction txn) {
        try {
            Trigger trigger = (Trigger)trigID.resolveID();
            this.setColSeqBlock(trigger, EMPTY_COLSEQ_BLOCK, txn);
        }
        catch (DBException e) {
            DBLog.getLogger((Object)((Object)this)).warning(e.getMessage());
        }
    }

    private void generateColSeqCode(Table table, DBObjectID trigID, DBObjectTransaction txn, Holder<Boolean> tableUpdated) {
        try {
            DBObjectProvider pro = txn.getProvider();
            Trigger trigger = (Trigger)trigID.resolveID();
            if (trigger == null && trigID instanceof BaseObjectID) {
                trigger = (Trigger)pro.getObjectFactory().newObject(Trigger.class);
                String name = this.getNameToUse(pro, "TRIGGER", ((BaseObjectID)trigID).getName(), table);
                ColumnSequenceProcessor.initialiseTrigger(trigger, pro, table, name);
            }
            String trigSchemaName = trigger.getSchema().getName();
            String newAs = trigger.getReferencingNewAs();
            if (newAs == null) {
                newAs = NEW;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(COLSEQ_HEADER);
            for (Column col : table.getColumns()) {
                String schemaName;
                DBObjectID triggerID = (DBObjectID)col.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER);
                if (!trigID.equals(triggerID)) continue;
                if (trigID instanceof ReferenceID) {
                    col.setProperty(AUTO_GENERATED_SEQUENCE_TRIGGER, (Object)trigger.getID());
                    tableUpdated.value = Boolean.TRUE;
                }
                String colName = pro.getExternalName(col.getName());
                String seqName = "";
                String seqSchemaName = "";
                DBObjectID seqID = (DBObjectID)col.getProperty(AUTO_GENERATED_SEQUENCE);
                if (seqID instanceof ReferenceID) {
                    seqName = this.getNameToUse(pro, "SEQUENCE", ((ReferenceID)seqID).getName(), table);
                    Schema schema = table.getSchema();
                    seqSchemaName = schema.getName();
                    if (table.getProperty("TemplateObject") == null && (schemaName = ((ReferenceID)seqID).getSchemaName()) != null) {
                        seqSchemaName = schemaName;
                        schema = pro.getSchema(schemaName);
                    }
                    Sequence newSeq = (Sequence)pro.getObjectFactory().newObject(Sequence.class);
                    newSeq.setSchema(schema);
                    newSeq.setName(seqName);
                    TemporaryObjectID id = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)newSeq);
                    newSeq.setID((DBObjectID)id);
                    col.setProperty(AUTO_GENERATED_SEQUENCE, (Object)id);
                    tableUpdated.value = Boolean.TRUE;
                    txn.includeUpdate(null, (SystemObject)newSeq);
                } else if (seqID instanceof BaseObjectID) {
                    BaseObjectID bid = (BaseObjectID)seqID;
                    seqName = bid.getName();
                    schemaName = bid.getSchemaName();
                    if (schemaName != null) {
                        seqSchemaName = schemaName;
                    }
                } else {
                    seqName = DBUtil.getDBObjectName((DBObjectID)seqID);
                }
                seqName = pro.getExternalName(seqName);
                if (ModelUtil.hasLength((String)seqSchemaName) && !seqSchemaName.equals(trigSchemaName)) {
                    seqName = pro.getExternalName(seqSchemaName) + "." + seqName;
                }
                if (Boolean.TRUE.equals(col.getProperty(TRIGGER_NULL_CHECK))) {
                    sb.append(IF_INSERTING_AND_NULL.replaceAll(NEW_TOKEN, newAs).replaceAll(COLUMN_TOKEN, colName));
                } else {
                    sb.append(IF_INSERTING);
                }
                sb.append(SELECT_INTO.replaceAll(SEQUENCE_TOKEN, seqName).replaceAll(NEW_TOKEN, newAs).replaceAll(COLUMN_TOKEN, colName));
                sb.append(END_IF);
            }
            sb.append(COLSEQ_FOOTER);
            this.setColSeqBlock(trigger, sb.toString(), txn);
        }
        catch (DBException e) {
            DBLog.getLogger((Object)((Object)this)).warning(e.getMessage());
        }
    }

    private void getColumnSequenceDiffs(Difference tabDiff, List<Difference> deletedColumnDiffs, List<Difference> newColumnDiffs, List<Difference> changedColumnDiffs) {
        Difference tabPropDiff = tabDiff.getChildDifference("columns", true);
        if (tabPropDiff != null) {
            for (Difference columnDiff : tabPropDiff.getChildren()) {
                if (columnDiff.isSame()) continue;
                if (columnDiff.getOriginalObject() != null && columnDiff.getUpdatedObject() == null) {
                    if (!ColumnSequenceProcessor.hasColumnSequenceProps((Column)columnDiff.getOriginalObject())) continue;
                    deletedColumnDiffs.add(columnDiff);
                    continue;
                }
                if (columnDiff.getOriginalObject() == null && columnDiff.getUpdatedObject() != null) {
                    if (!ColumnSequenceProcessor.hasColumnSequenceProps((Column)columnDiff.getUpdatedObject())) continue;
                    newColumnDiffs.add(columnDiff);
                    continue;
                }
                Difference colPropsDiff = columnDiff.getChildDifference("properties", true);
                if (colPropsDiff == null) continue;
                for (String colseqProp : ColumnSequenceProcessor.getColumnSequenceProps()) {
                    Difference colseqPropDiff = colPropsDiff.getChildDifference(colseqProp, true);
                    if (colseqPropDiff == null) continue;
                    changedColumnDiffs.add(colseqPropDiff);
                }
            }
        }
    }

    private String getNameToUse(DBObjectProvider pro, String type, String name, Table table) {
        DBObjectID templateID = (DBObjectID)table.getProperty("TemplateObject");
        if (templateID != null) {
            String defaultName = DBUtil.getDBObjectName((DBObjectID)templateID);
            defaultName = "TRIGGER".equals(type) ? defaultName + TRIGGER_SUFFIX : defaultName + SEQUENCE_SUFFIX;
            if (defaultName.equals(name)) {
                name = table.getName();
                name = "TRIGGER".equals(type) ? name + TRIGGER_SUFFIX : name + SEQUENCE_SUFFIX;
            }
        }
        name = pro.getUniqueName(type, (DBObject)table.getSchema(), name);
        return name;
    }

    public boolean onlyProcessesPrimaryUpdates() {
        return true;
    }

    public static void initialiseTrigger(Trigger trigger, DBObjectProvider pro, Table table, String name) {
        trigger.setSchema(table.getSchema());
        trigger.setName(name);
        trigger.setBaseType(Trigger.BaseType.TABLE);
        trigger.setBaseObjectID(table.getID());
        trigger.setTiming(Trigger.Timing.BEFORE);
        trigger.setEvents(new String[]{"INSERT"});
        trigger.setStatementLevel(false);
        trigger.setSource(null);
        TemporaryObjectID id = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)trigger);
        trigger.setID((DBObjectID)id);
    }

    public static boolean hasColumnSequenceProps(Column col) {
        for (String prop : ColumnSequenceProcessor.getColumnSequenceProps()) {
            if (col.getProperty(prop) == null) continue;
            return true;
        }
        return false;
    }

    public static void clearColumnSequenceProps(Column col) {
        Map props = col.getProperties();
        if (props != null) {
            for (String prop : ColumnSequenceProcessor.getColumnSequenceProps()) {
                props.remove(prop);
            }
        }
    }

    public static boolean isColumnSequenceProp(String propName) {
        return ColumnSequenceProcessor.getColumnSequenceProps().contains(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getColumnSequenceProps() {
        Set<String> set = s_props;
        synchronized (set) {
            if (s_props.isEmpty()) {
                TemplateExpander.registerInitialiser((TemplateExpander.Initialiser)new TemplateInitialiser());
                s_props.add(AUTO_GENERATED_SEQUENCE_TRIGGER);
                s_props.add(AUTO_GENERATED_SEQUENCE);
                s_props.add(TRIGGER_NULL_CHECK);
                s_props.add(REUSE_SEQUENCE);
            }
        }
        return s_props;
    }

    public static void refreshColumnSequenceProps(Column col) {
        Column origCol;
        DBObjectID id = col.getID();
        if (id instanceof TemporaryObjectID && (origCol = (Column)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)id))) != null) {
            for (String prop : ColumnSequenceProcessor.getColumnSequenceProps()) {
                col.setProperty(prop, origCol.getProperty(prop));
            }
        }
    }

    public static List<ColumnInfo> getColumnInfos(String source, DBObjectProvider pro) {
        ArrayList<ColumnInfo> retval = new ArrayList<ColumnInfo>();
        PlSqlSearch blockSearch = new PlSqlSearch(COLSEQ_SEARCH);
        PlSqlSearch statementSearch = new PlSqlSearch(COLSEQ_STATEMENT_SEARCH);
        PlSqlToken startToken = PlSqlTokenizer.tokenize((String)source, (String[])new String[0]);
        if (blockSearch.isWithin(startToken)) {
            startToken = blockSearch.getStartToken();
            PlSqlToken endToken = blockSearch.getEndToken();
            while (statementSearch.isWithin(startToken, endToken)) {
                PlSqlToken nullCheckEndTk;
                PlSqlToken nullCheckStartTk;
                PlSqlToken columnEndTk = statementSearch.getNamedMatchStartToken("col");
                PlSqlToken columnStartTk = (PlSqlToken)((PlSqlToken)((PlSqlToken)columnEndTk.getPrevCodeToken()).getPrevCodeToken()).getPrevCodeToken();
                String columnName = pro.getInternalName(columnEndTk.getSource());
                PlSqlToken ifStartTk = statementSearch.getNamedMatchStartToken("if");
                PlSqlToken ifEndTk = statementSearch.getNamedMatchEndToken("if");
                boolean nullCheck = false;
                if (ifStartTk != null) {
                    PlSqlSearch nullCheckSearch = new PlSqlSearch(columnStartTk.getSource(true, (Token)columnEndTk) + " IS NULL");
                    if (nullCheckSearch.isWithin(ifStartTk, ifEndTk)) {
                        nullCheck = true;
                        nullCheckStartTk = nullCheckSearch.getStartToken();
                        nullCheckEndTk = nullCheckSearch.getEndToken();
                    } else {
                        nullCheckStartTk = ifStartTk;
                        nullCheckEndTk = ifStartTk;
                    }
                } else {
                    nullCheckEndTk = nullCheckStartTk = statementSearch.getStartToken();
                }
                PlSqlToken sequenceStartTk = statementSearch.getNamedMatchStartToken("seq");
                PlSqlToken sequenceEndTk = statementSearch.getNamedMatchEndToken("seq");
                String seqExpression = statementSearch.getNamedMatch("seq");
                String[] seqChunks = seqExpression.split("\\.");
                if (seqChunks.length > 1 && seqChunks.length < 4 && NEXTVAL.equalsIgnoreCase(seqChunks[seqChunks.length - 1])) {
                    String sequenceSchemaName = null;
                    String sequenceName = pro.getInternalName(seqChunks[0]);
                    if (seqChunks.length == 3) {
                        sequenceSchemaName = sequenceName;
                        sequenceName = pro.getInternalName(seqChunks[1]);
                    }
                    ColumnInfo info = new ColumnInfo(columnName, columnStartTk.getStart(), columnEndTk.getEnd(), sequenceSchemaName, sequenceName, sequenceStartTk.getStart(), sequenceEndTk.getEnd(), nullCheck, nullCheckStartTk.getStart(), nullCheckEndTk.getEnd());
                    retval.add(info);
                }
                startToken = statementSearch.getEndToken();
            }
        }
        return retval;
    }

    public static void registerProcessorProperties(Class<? extends DBObjectProvider> proClz) {
        Metadata m = Metadata.getInstance();
        PropertyDefinition reuseSeq = new PropertyDefinition(REUSE_SEQUENCE, Boolean.class, proClz, new Class[]{Column.class});
        reuseSeq.setNullBehaviour(Nullable.NullBehaviour.NULL_MEANS_FALSE);
        m.registerProperty((PropertyInfo)reuseSeq);
        PropertyDefinition triggerNullChk = new PropertyDefinition(TRIGGER_NULL_CHECK, Boolean.class, proClz, new Class[]{Column.class});
        triggerNullChk.setNullBehaviour(Nullable.NullBehaviour.NULL_MEANS_FALSE);
        m.registerProperty((PropertyInfo)triggerNullChk);
        m.registerIDProperty(AUTO_GENERATED_SEQUENCE, false, Sequence.class, null, proClz, new Class[]{Column.class});
        m.registerIDProperty(AUTO_GENERATED_SEQUENCE_TRIGGER, false, Trigger.class, null, proClz, new Class[]{Column.class});
    }

    @Deprecated
    public static String getUniqueName(DBObjectProvider pro, String type, Schema schema, String tableName) {
        return null;
    }

    public static class ColumnInfo {
        private final String m_columnName;
        private final String m_sequenceSchemaName;
        private final String m_sequenceName;
        private final boolean m_nullCheck;
        private final int m_columnStart;
        private final int m_columnEnd;
        private final int m_sequenceStart;
        private final int m_sequenceEnd;
        private final int m_nullCheckStart;
        private final int m_nullCheckEnd;

        private ColumnInfo(String columnName, int columnStart, int columnEnd, String sequenceSchemaName, String sequenceName, int sequenceStart, int sequenceEnd, boolean nullCheck, int nullCheckStart, int nullCheckEnd) {
            this.m_columnName = columnName;
            this.m_sequenceSchemaName = sequenceSchemaName;
            this.m_sequenceName = sequenceName;
            this.m_nullCheck = nullCheck;
            this.m_columnStart = columnStart;
            this.m_columnEnd = columnEnd;
            this.m_sequenceStart = sequenceStart;
            this.m_sequenceEnd = sequenceEnd;
            this.m_nullCheckStart = nullCheckStart;
            this.m_nullCheckEnd = nullCheckEnd;
        }

        public String getColumnName() {
            return this.m_columnName;
        }

        public String getSequenceSchemaName() {
            return this.m_sequenceSchemaName;
        }

        public String getSequenceName() {
            return this.m_sequenceName;
        }

        public boolean isCheckForNull() {
            return this.m_nullCheck;
        }

        public int getColumnStart() {
            return this.m_columnStart;
        }

        public int getColumnEnd() {
            return this.m_columnEnd;
        }

        public int getSequenceStart() {
            return this.m_sequenceStart;
        }

        public int getSequenceEnd() {
            return this.m_sequenceEnd;
        }

        public int getNullCheckStart() {
            return this.m_nullCheckStart;
        }

        public int getNullCheckEnd() {
            return this.m_nullCheckEnd;
        }
    }

    private static class TemplateInitialiser
    implements TemplateExpander.Initialiser {
        private TemplateInitialiser() {
        }

        public void initialiseObject(DBObject template, DBObject object) {
            if ("TABLE".equals(template.getType())) {
                Table templateTable = (Table)template;
                Table newTable = (Table)object;
                String templateName = templateTable.getName();
                for (Column c : templateTable.getColumns()) {
                    DBObjectID trigID = (DBObjectID)c.getProperty(ColumnSequenceProcessor.AUTO_GENERATED_SEQUENCE_TRIGGER);
                    if (trigID == null) continue;
                    Column c2 = newTable.getColumn(c.getName());
                    String defaultSchemaName = templateTable.getSchema().getName();
                    String defaultTrigName = templateName + ColumnSequenceProcessor.TRIGGER_SUFFIX;
                    String defaultSeqName = templateName + ColumnSequenceProcessor.SEQUENCE_SUFFIX;
                    c2.setProperty(ColumnSequenceProcessor.AUTO_GENERATED_SEQUENCE_TRIGGER, (Object)new ReferenceID("TRIGGER", defaultSchemaName, defaultTrigName));
                    if (Boolean.TRUE.equals(c.getProperty(ColumnSequenceProcessor.REUSE_SEQUENCE))) continue;
                    c2.setProperty(ColumnSequenceProcessor.AUTO_GENERATED_SEQUENCE, (Object)new ReferenceID("SEQUENCE", defaultSchemaName, defaultSeqName));
                }
            }
        }
    }
}

