/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class TOKEngine
extends DataEngine {
    private static final String TOK_LINE_BRANCH = "BRANCH";
    private static final String TOK_LINE_LEAF = "LEAF";
    private Book _book = null;
    private View _view = null;
    private boolean _foundFakeIndenting = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader r = this._getBufferedReader(url, encoding);
        Object dataObject = null;
        try {
            dataObject = this.createDataObject(view, basePath, r);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return dataObject;
    }

    public Object createDataObject(View view, String basePath, BufferedReader reader) throws IOException {
        Book book = null;
        if (view != null) {
            book = view.getBook();
        }
        TopicTree tree = new TopicTree(book, basePath);
        TopicTreeNode parent = tree.getRoot();
        this.parseTOK(book, view, reader, parent);
        return tree;
    }

    protected void parseTOK(Book book, View view, BufferedReader reader, TopicTreeNode root) {
        int level = 0;
        String line = "";
        this._book = book;
        this._view = view;
        KeywordTopicTreeNode currentKeyword = null;
        TopicTreeNode topLevelKeyword = null;
        while (true) {
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                line = null;
            }
            if (line == null) break;
            if (line.equals("") || line.charAt(0) == '#') continue;
            StringTokenizer st = new StringTokenizer(line, "|", true);
            try {
                level = Integer.parseInt(st.nextToken().trim());
                if (!st.nextToken().trim().equals("|")) {
                }
            }
            catch (Exception e2) {}
            continue;
            KeywordTopicTreeNode node = this._parseLine(st, level);
            if (node == null) continue;
            if (level == 1) {
                if (!this._foundFakeIndenting || topLevelKeyword == null) {
                    root.addChild(node);
                    currentKeyword = node;
                    topLevelKeyword = node;
                } else {
                    topLevelKeyword.addChild(node);
                    currentKeyword = node;
                }
            }
            if (level <= 1 || node.isBranch() || currentKeyword == null) continue;
            currentKeyword.addEntry(node);
        }
    }

    private KeywordTopicTreeNode _parseLine(StringTokenizer st, int level) {
        KeywordTopicTreeNode node = null;
        try {
            String lineType = st.nextToken().trim();
            if (!st.nextToken().trim().equals("|")) {
                return null;
            }
            if (lineType.equals(TOK_LINE_BRANCH)) {
                node = this._parseBranch(st, level);
                if (node == null) {
                    return null;
                }
            } else if (lineType.equals(TOK_LINE_LEAF)) {
                node = this._parseLeaf(st, level);
                if (node == null) {
                    return null;
                }
            } else {
                node = null;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            node = null;
        }
        return node;
    }

    private KeywordTopicTreeNode _parseBranch(StringTokenizer st, int level) {
        KeywordTopicTreeNode node = null;
        SimpleTopic topic = null;
        SimpleURLTarget target = null;
        String length = st.nextToken().trim();
        if (!length.equals("|") && !st.nextToken().trim().equals("|")) {
            return null;
        }
        String branchName = st.nextToken();
        if (branchName != null) {
            topic = new SimpleTopic(branchName);
            this._foundFakeIndenting = branchName.startsWith(" ");
        }
        if (st.hasMoreTokens() && st.nextToken().trim().equals("|") && st.hasMoreTokens()) {
            String fileName = st.nextToken().trim();
            target = new SimpleURLTarget(this._view, fileName);
            topic.setTarget(target);
        }
        node = new KeywordTopicTreeNode(this._view, topic);
        return node;
    }

    private KeywordTopicTreeNode _parseLeaf(StringTokenizer st, int level) {
        KeywordTopicTreeNode node = null;
        SimpleTopic topic = null;
        SimpleURLTarget target = null;
        String leafName = "";
        String leafUrl = "";
        String length = st.nextToken().trim();
        if (!length.equals("|") && !st.nextToken().trim().equals("|")) {
            return null;
        }
        leafName = st.nextToken();
        if (!st.nextToken().trim().equals("|")) {
            return null;
        }
        leafUrl = st.nextToken().trim();
        if (leafName != null) {
            topic = new SimpleTopic(leafName);
            this._foundFakeIndenting = leafName.startsWith(" ");
        }
        target = new SimpleURLTarget(this._view, leafUrl);
        topic.setTarget(target);
        node = new KeywordTopicTreeNode(this._view, topic);
        return node;
    }
}

