/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.help.common.util.StringUtils;

public class TopicNameConvention {
    public static final String FILENAME = "filename";
    public static final String EXTENSION = "extension";
    private String _beginningText = "";
    private String _middleText = "";
    private String _endingText = "";
    private String _fileSeparator = "";
    private String _urlBase = "";
    private String _first;

    public void setFirst(String first) throws MalformedConventionException {
        if (!first.equals(FILENAME) && !first.equals(EXTENSION)) {
            throw new MalformedConventionException();
        }
        this._first = first;
    }

    public void setURLBase(String urlBase) {
        this._urlBase = urlBase;
        if (!urlBase.endsWith("/")) {
            this._urlBase = this._urlBase + "/";
        }
    }

    public void setBeginningText(String beginningText) {
        this._beginningText = beginningText;
    }

    public void setMiddleText(String middleText) {
        this._middleText = middleText;
    }

    public void setEndingText(String endingText) {
        this._endingText = endingText;
    }

    public void setFileSeparator(String fileSeparator) {
        this._fileSeparator = fileSeparator;
    }

    public URL convertToURL(String id) {
        if (this._first != null && this._middleText != null) {
            try {
                int indexOfMiddle;
                String filename = "";
                String extension = "";
                if (this._beginningText != null && this._beginningText.length() > 0) {
                    if (!id.startsWith(this._beginningText)) {
                        return null;
                    }
                    id = id.substring(this._beginningText.length());
                }
                if ((indexOfMiddle = id.lastIndexOf(this._middleText)) == -1) {
                    throw new MalformedURLException();
                }
                if (this._first.equals(FILENAME)) {
                    filename = id.substring(0, indexOfMiddle);
                } else {
                    extension = id.substring(0, indexOfMiddle);
                }
                id = id.substring(indexOfMiddle + this._middleText.length());
                if (this._endingText != null && this._endingText.length() > 0 && id.indexOf(this._endingText) > 0) {
                    id = id.substring(0, id.indexOf(this._endingText));
                }
                if (this._first.equals(FILENAME)) {
                    extension = id;
                } else {
                    filename = id;
                }
                if (this._fileSeparator != null && this._fileSeparator.length() > 0) {
                    filename = StringUtils.replaceAll(filename, this._fileSeparator, "/");
                }
                String url = this._urlBase + filename + "." + extension;
                return new URL(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public class MalformedConventionException
    extends Exception {
    }
}

