/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class DbCartDeployCloudUtil {
    public static DDLFormat getDDLFormat() {
        DDLFormat dDLFormat = new DDLFormat(3);
        dDLFormat.setShowDDLOptionsEnabled(true);
        dDLFormat.setShowDep(false);
        dDLFormat.setShowAlter(false);
        dDLFormat.setShowSegments(false);
        dDLFormat.setShowConstraint(true);
        dDLFormat.setShowRefConstraint(true);
        dDLFormat.setShowTrigger(true);
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setSchema(false);
        dDLFormat.setSegments(false);
        dDLFormat.setDrop(false);
        dDLFormat.setCascade(false);
        return dDLFormat;
    }

    public static ExtractDataFormat getDataFormat() {
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(BaseDataFormat.CART, "LOADER".toLowerCase());
        extractDataFormat.isSeparateDataFile(true);
        extractDataFormat.isEnclosureRightDouble(true);
        return extractDataFormat;
    }

    public static TargetFormat getTargetFormat() {
        TargetFormat targetFormat = new TargetFormat(1, 5);
        targetFormat.setShowEncoding(false);
        targetFormat.setShowCompression(true);
        targetFormat.setShowSaveAsType(false);
        targetFormat.setShowCompression(false);
        targetFormat.isCompressed(true);
        targetFormat.setEncoding("UTF8");
        targetFormat.setSaveAsType(1);
        targetFormat.setSaveAs(targetFormat.getDefaultSaveAs());
        targetFormat.isGenScript(true);
        targetFormat.isOpenTarget(false);
        targetFormat.isExcutableControlFile(false);
        targetFormat.isSftp(true);
        targetFormat.isDeployCloud(true);
        return targetFormat;
    }

    public static Boolean isValidString(String string) {
        for (char c : string.toCharArray()) {
            if (!DbCartDeployCloudUtil.isUnsafe(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnsafe(char c) {
        if (c > '\u0080' || c < ' ') {
            return true;
        }
        return " %$&+,/:;=?@<>#%*`[]{}|\"\\".indexOf(c) >= 0;
    }

    public static String validateForDeploy(ArrayList<ExtractObject> arrayList) {
        ArrayList<ExtractObject> arrayList2 = DbCartDeployCloudUtil.validateConns(arrayList);
        ArrayList<ExtractObject> arrayList3 = DbCartDeployCloudUtil.validateTypes(arrayList);
        ArrayList<ExtractObject> arrayList4 = DbCartDeployCloudUtil.validateObjects(arrayList);
        if (!(arrayList2.isEmpty() && arrayList3.isEmpty() && arrayList4.isEmpty())) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            stringBuilder.append(DbCartAddinArb.getString("UNABLE_TO_DEPLOY_OBJECTS_TO_CLOUD") + "\n");
            if (!arrayList2.isEmpty()) {
                stringBuilder.append(DbCartAddinArb.getString("BAD_CONN_TEXT") + "\n");
                for (ExtractObject extractObject : arrayList2) {
                    stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            if (!arrayList3.isEmpty()) {
                string = "";
                stringBuilder.append(DbCartAddinArb.getString("BAD_TYPE_TEXT") + "\n");
                for (ExtractObject extractObject : arrayList3) {
                    stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            if (!arrayList4.isEmpty()) {
                string = "";
                stringBuilder.append(DbCartAddinArb.getString("BAD_COLUMN_TEXT") + "\n");
                for (ExtractObject extractObject : arrayList4) {
                    stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static ArrayList<ExtractObject> validateConns(ArrayList<ExtractObject> arrayList) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : arrayList) {
            if (Connections.getInstance().isOracle(extractObject.getDBObject().getConnection())) continue;
            arrayList2.add(extractObject);
            extractObject.isPreSelected(false);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ExtractObject> validateTypes(ArrayList<ExtractObject> arrayList) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        ResultSet resultSet = null;
        String string = "select count(*) from all_external_tables where table_name = :TNAME and OWNER = :OWNER";
        for (ExtractObject extractObject : arrayList) {
            DBObject dBObject = extractObject.getDBObject();
            Connection connection = dBObject.getConnection();
            String string2 = dBObject.getObjectType();
            if (string2.equals("DATABASE LINK") || string2.equals("DIRECTORY") || string2.equals("MATERIALIZED VIEW") || string2.equals("MATERIALIZED VIEW LOG") || string2.equals("SYNONYM")) {
                arrayList2.add(extractObject);
                extractObject.isPreSelected(false);
                continue;
            }
            if (!Connections.getInstance().isOracle(connection) || !string2.equals("TABLE")) continue;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TNAME", dBObject.getObjectName());
                hashMap.put("OWNER", dBObject.getSchemaName());
                if (!Connections.getInstance().lock(connection)) continue;
                try {
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        if (n <= 0) continue;
                        arrayList2.add(extractObject);
                        extractObject.isPreSelected(false);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                DBUtil.closeResultSet(resultSet);
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ExtractObject> validateObjects(ArrayList<ExtractObject> arrayList) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        ResultSet resultSet = null;
        String string = "select count(*) from all_tab_cols where table_name = :TNAME and OWNER = :OWNER and (data_type = 'SDO_GEOMETRY' or data_type = 'LONG' or data_type = 'LONG RAW' or data_type = 'BFILE')";
        for (ExtractObject extractObject : arrayList) {
            DBObject dBObject = extractObject.getDBObject();
            Connection connection = dBObject.getConnection();
            if (!Connections.getInstance().isOracle(connection) || !dBObject.getObjectType().equals("TABLE")) continue;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TNAME", dBObject.getObjectName());
                hashMap.put("OWNER", dBObject.getSchemaName());
                if (!Connections.getInstance().lock(connection)) continue;
                try {
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        if (n <= 0) continue;
                        arrayList2.add(extractObject);
                        extractObject.isPreSelected(false);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                DBUtil.closeResultSet(resultSet);
            }
        }
        return arrayList2;
    }

    public static String validateTitle(String string) {
        if (string == null || string.equals("")) {
            return DbCartAddinArb.getString("NULL_TITLE_MESSAGE");
        }
        if (!DbCartDeployCloudUtil.isValidString(string).booleanValue()) {
            return DbCartAddinArb.getString("BAD_TITLE_MESSAGE");
        }
        return null;
    }

    public static String validateCloudConn(String string) {
        if (string == null || string.length() == 0) {
            return DbCartAddinArb.getString("XML_CONN_ERROR_MESSAGE2");
        }
        try {
            Connections.getInstance().getConnection(string, true);
        }
        catch (Exception exception) {
            return DbCartAddinArb.format("XML_CONN_ERROR_MESSAGE1", string);
        }
        return null;
    }

    public static CConnectionInfo.SftpInfo getSftpInfo(String string) {
        CConnections cConnections;
        CConnectionInfo cConnectionInfo;
        CConnectionInfo.SftpInfo sftpInfo = null;
        if (string != null && (cConnectionInfo = (cConnections = CConnections.getInstance()).getConnectionInfo(string)) != null) {
            sftpInfo = cConnectionInfo.getSftpInfo();
        }
        return sftpInfo;
    }
}

