/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.saveactions;

import oracle.ideimpl.ceditor.saveactions.SaveActionsHook;
import oracle.javatools.data.HashStructure;

public class SaveActionDescription {
    private HashStructure hash;
    private String extensionId;

    SaveActionDescription(String extensionId, HashStructure hash) {
        this.extensionId = extensionId;
        this.hash = hash;
    }

    public String getId() {
        String id = this.hash.getString("id");
        if (id == null) {
            SaveActionsHook.logError("Missing 'id' attribute", this.extensionId);
        }
        return id;
    }

    public boolean getExecuteByDefault() {
        return this.getBoolean("execute-by-default", false);
    }

    public boolean getExecuteBeforeSave() {
        return this.getBoolean("execute-before-save", true);
    }

    private boolean getBoolean(String name, boolean defaultValue) {
        if (this.hash.keyStatus(name) == 0) {
            SaveActionsHook.logError("Missing '" + name + "' attribute", this.extensionId);
        }
        return this.hash.getBoolean(name, defaultValue);
    }
}

