/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class URIEncoding
extends Encoding
implements Decoder {
    public URIEncoding(MimeType mimeType) {
        super(EncodingType.ENCODING_URI, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(Reader reader, Writer writer) throws URISyntaxException, IOException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        int n = reader.read();
        while (n != -1) {
            stringBuffer.append((char)n);
            n = reader.read();
        }
        URI uRI = new URI(stringBuffer.toString());
        File file = new File(uRI);
        FileReader fileReader = new FileReader(file);
        try {
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n2 = bufferedReader.read();
            while (n2 != -1) {
                writer.write(n2);
                n2 = bufferedReader.read();
            }
            writer.flush();
            bl = false;
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {
                if (bl) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(Reader reader, OutputStream outputStream) throws URISyntaxException, IOException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Reader reader2 = reader;
        OutputStream outputStream2 = outputStream;
        int n = reader2.read();
        while (n != -1) {
            stringBuffer.append((char)n);
            n = reader2.read();
        }
        URI uRI = new URI(stringBuffer.toString());
        File file = new File(uRI);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n2 = bufferedInputStream.read();
            while (n2 != -1) {
                outputStream2.write(n2);
                n2 = bufferedInputStream.read();
            }
            outputStream2.flush();
            bl = false;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                if (bl) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                }
                throw iOException;
            }
        }
    }

    @Override
    public void decodeStream(Object object, Object object2) throws EncodingException, IOException {
        try {
            if (object2 instanceof OutputStream) {
                this.decode((Reader)object, (OutputStream)object2);
            } else {
                this.decode((Reader)object, (Writer)object2);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new EncodingException(uRISyntaxException);
        }
    }

    @Override
    public long getDecodeLength(long l) throws EncodingException {
        throw new EncodingException("Length of output cannot be reliably determined.");
    }

    @Override
    public int getDecodeBlocksize() {
        return 1;
    }
}

