/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.util.GCReapHandler;
import oracle.dbtools.util.Logger;

public final class GCTracker {
    private static GCTracker instance = null;
    private final Map<Reference, GCReapHandler> handlerMap = new HashMap<Reference, GCReapHandler>();
    private final ReferenceQueue reaped = new ReferenceQueue();
    private boolean tracking = true;

    private GCTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GCTracker getInstance() {
        if (instance != null) return instance;
        Class<GCTracker> clazz = GCTracker.class;
        synchronized (GCTracker.class) {
            if (instance != null) return instance;
            instance = new GCTracker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTracking(boolean bl) {
        if (this.tracking != bl) {
            GCTracker gCTracker = this;
            synchronized (gCTracker) {
                this.tracking = bl;
            }
        }
    }

    public boolean isTracking() {
        return this.tracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(Object object, GCReapHandler gCReapHandler) {
        if (this.tracking) {
            GCTracker gCTracker = this;
            synchronized (gCTracker) {
                if (this.tracking) {
                    this.handlePendingReap();
                    PhantomReference<Object> phantomReference = new PhantomReference<Object>(object, this.reaped);
                    this.handlerMap.put(phantomReference, gCReapHandler);
                }
            }
        }
    }

    public void pollReferentReapQueue() {
        this.pollReferentReapQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollReferentReapQueue(boolean bl) {
        if (bl || this.tracking) {
            GCTracker gCTracker = this;
            synchronized (gCTracker) {
                this.handlePendingReap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReferentReapQueue() {
        GCTracker gCTracker = this;
        synchronized (gCTracker) {
            this.purgeReferentReapQueue(this.isTracking());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReferentReapQueue(boolean bl) {
        GCTracker gCTracker = this;
        synchronized (gCTracker) {
            this.setTracking(bl);
            this.handlerMap.clear();
            Reference reference = this.reaped.poll();
            while (reference != null) {
                reference = this.reaped.poll();
            }
        }
    }

    private void handlePendingReap() {
        Reference reference = this.reaped.poll();
        while (reference != null) {
            GCReapHandler gCReapHandler = this.handlerMap.remove(reference);
            if (gCReapHandler != null) {
                try {
                    gCReapHandler.referentDequeued();
                }
                catch (Exception exception) {
                    Logger.finest(GCTracker.class, exception);
                }
            }
            reference = this.reaped.poll();
        }
    }
}

