/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public final class ResolvedDBObject {
    private String _owner;
    private String _part1;
    private String _part2;
    private String _dblink;
    private int _type;
    private String _filter;
    private BigDecimal _id;
    private boolean bad = false;
    private static String error = "";
    private static final String PLSQL_DBMS_UTILITY_RESOLVE = "begin  DBMS_UTILITY.NAME_RESOLVE (   name          => :NAME,    context       => :CTX,   schema        => :SCHEMA,    part1         => :PART1,    part2         => :PART2,   dblink        => :DBLINK,    part1_type    => :PART1_TYPE,    object_number => :NUM);end;";
    private static final String QUERY_OWNED_SYNONYM = "select owner,table_name,table_owner from all_synonyms where synonym_name = :NAME and owner = :OWNER";
    private static final String QUERY_SYNONYM = "select owner,table_name,table_owner from all_synonyms where synonym_name = :NAME";
    private static final String PLSQL_DBMS_UTILITY_TOKENIZE = "begin  DBMS_UTILITY.NAME_TOKENIZE (   name   => :NAME,    a      => :A,    b      => :B,    c      => :C,    dblink => :DBLINK,    nextpos => :NEXTPOS);end;";

    private ResolvedDBObject(String string, String string2, String string3, String string4, int n, String string5, BigDecimal bigDecimal) {
        this._owner = string;
        this._part1 = string2;
        this._part2 = string3;
        this._dblink = string4;
        this._type = n;
        this._filter = string5;
        this._id = bigDecimal;
    }

    private ResolvedDBObject(String string) {
        this.bad = true;
        error = string;
    }

    public BigDecimal getId() {
        return this._id;
    }

    public String getName() {
        if (this._type == 2 || this._type == 4) {
            return this._part1;
        }
        if (this._type == 7 || this._type == 8) {
            return this._part2;
        }
        if (this._type == 9) {
            return this._part1;
        }
        return this._part1;
    }

    public int getType() {
        return this._type;
    }

    public String getTypeName() {
        switch (this._type) {
            case 1: {
                return "TABLE";
            }
            case 2: {
                return "TABLE";
            }
            case 4: {
                return "VIEW";
            }
            case 5: {
                return "SYNONYM";
            }
            case 7: {
                return "PROCEDURE";
            }
            case 8: {
                return "FUNCTION";
            }
            case 9: {
                return "PACKAGE";
            }
        }
        return null;
    }

    public String getFilter() {
        return this._filter;
    }

    public String getOwner() {
        return this._owner;
    }

    public String getPart1() {
        return this._part1;
    }

    public String getPart2() {
        return this._part2;
    }

    public String getDBlink() {
        return this._dblink;
    }

    public HashMap<String, ?> getBinds() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OBJECT_OWNER", this._owner);
        hashMap.put("FILTER", this._filter);
        if (this._type == 2 || this._type == 4) {
            hashMap.put("OBJECT_NAME", this._part1);
        } else if (this._type == 7 || this._type == 8) {
            hashMap.put("OBJECT_NAME", this._part2);
        } else if (this._type == 9) {
            hashMap.put("OBJECT_NAME", this._part1);
            hashMap.put("FILTER", this._part2);
        }
        return hashMap;
    }

    public static ResolvedDBObject resolveDBObject(Connection connection, String string, String string2) {
        if (connection == null) {
            return new ResolvedDBObject("no connection");
        }
        ResolvedDBObject resolvedDBObject = null;
        if (connection != null) {
            for (int i = 0; i < 10 && resolvedDBObject == null; ++i) {
                if (resolvedDBObject == null) {
                    resolvedDBObject = ResolvedDBObject.getResolvedObject(connection, string, i, string2);
                }
                if (i != 9 || !string.contains(".")) continue;
                string2 = string.substring(string.lastIndexOf(".") + 1);
                string = string.substring(0, string.lastIndexOf("."));
                i = -1;
            }
        }
        if (resolvedDBObject == null) {
            resolvedDBObject = ResolvedDBObject.getSynonymnReference(connection, string);
        }
        return resolvedDBObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolvedDBObject getSynonymnReference(Connection connection, String string) {
        String string2;
        String string3;
        Object object;
        Object object2;
        ResolvedDBObject resolvedDBObject = null;
        String string4 = null;
        String string5 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(PLSQL_DBMS_UTILITY_TOKENIZE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.registerOutParameter(4, 12);
            oracleCallableStatement.registerOutParameter(5, 12);
            oracleCallableStatement.registerOutParameter(6, 2);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.execute();
            object2 = oracleCallableStatement.getString(2);
            object = oracleCallableStatement.getString(3);
            string3 = oracleCallableStatement.getString(4);
            string2 = oracleCallableStatement.getString(5);
            int n = oracleCallableStatement.getInt(6);
            if (object == null) {
                string4 = object2;
            } else {
                string5 = object2;
                string4 = object;
            }
        }
        catch (SQLException sQLException) {
            string4 = string;
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            object2 = null;
            object = null;
            try {
                if (string5 != null) {
                    object2 = (OraclePreparedStatement)connection.prepareStatement(QUERY_OWNED_SYNONYM);
                    object2.setStringAtName("OWNER", string5);
                } else {
                    object2 = (OraclePreparedStatement)connection.prepareStatement(QUERY_SYNONYM);
                }
                object2.setStringAtName("NAME", string4);
                object = (OracleResultSet)object2.executeQuery();
                if (object.next()) {
                    string5 = object.getString(1);
                    string3 = object.getString(2);
                    string2 = object.getString(3);
                    resolvedDBObject = new ResolvedDBObject(string5, string4, "\"" + string2 + "\".\"" + string3 + "\"", null, 5, null, null);
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
                object2.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return resolvedDBObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolvedDBObject getResolvedObject(Connection connection, String string, int n, String string2) {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(PLSQL_DBMS_UTILITY_RESOLVE);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.registerOutParameter(4, 12);
            oracleCallableStatement.registerOutParameter(5, 12);
            oracleCallableStatement.registerOutParameter(6, 12);
            oracleCallableStatement.registerOutParameter(7, 2);
            oracleCallableStatement.registerOutParameter(8, 2);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.setInt(2, n);
            oracleCallableStatement.execute();
            String string3 = oracleCallableStatement.getString(3);
            String string4 = oracleCallableStatement.getString(4);
            String string5 = oracleCallableStatement.getString(5);
            String string6 = oracleCallableStatement.getString(6);
            int n2 = oracleCallableStatement.getInt(7);
            BigDecimal bigDecimal = oracleCallableStatement.getBigDecimal(8);
            ResolvedDBObject resolvedDBObject = new ResolvedDBObject(string3, string4, string5, string6, n2, string2, bigDecimal);
            PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from all_objects where object_name = :NAME and owner = :OWNER");
            preparedStatement.setString(1, resolvedDBObject.getName());
            preparedStatement.setString(2, resolvedDBObject.getOwner());
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            if (resultSet.getInt(1) == 0) {
                resolvedDBObject = null;
            }
            ResolvedDBObject resolvedDBObject2 = resolvedDBObject;
            return resolvedDBObject2;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 6563) {
                ResolvedDBObject resolvedDBObject = new ResolvedDBObject("Object Not Found: " + string);
                return resolvedDBObject;
            }
            if (sQLException.getErrorCode() == 931) {
                ResolvedDBObject resolvedDBObject = new ResolvedDBObject("invalid object name");
                return resolvedDBObject;
            }
            if (sQLException.getErrorCode() != 4047 && sQLException.getErrorCode() != 6564) {
                ResolvedDBObject resolvedDBObject;
                ResolvedDBObject resolvedDBObject3 = resolvedDBObject = new ResolvedDBObject(sQLException.getMessage());
                return resolvedDBObject3;
            }
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    public final boolean isBad() {
        return this.bad;
    }

    public final String getError() {
        return error;
    }
}

