/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class ObjectQueries {
    private List<Query> m_queryList;
    private Query m_default;
    private Map<VersionEntry, Query> m_queryMap = new TreeMap<VersionEntry, Query>();
    private XMLNode m_node;

    public ObjectQueries(XMLNode xMLNode) {
        this.m_node = xMLNode;
        this.initQueries(xMLNode);
    }

    public String getQueriesAttribute(String string) {
        if (this.m_node.getAttributes().getNamedItem(string) != null) {
            this.m_node.getAttributes().getNamedItem(string).getTextContent();
        }
        return null;
    }

    public void addQuery(Version version, Version version2, Query query) {
        this.m_queryMap.put(new VersionEntry(version, version2), query);
    }

    public void setDefaultQuery(Query query) {
        this.m_default = query;
    }

    public Query getQuery(String string) {
        return QueryUtils.getQuery(this.m_queryList, string);
    }

    public Query getQuery(String string, boolean bl) {
        return QueryUtils.getQuery(this.m_queryList, string, bl);
    }

    public Query getQuery(Connection connection) {
        return QueryUtils.getQuery(this.m_queryList, connection);
    }

    public Query getQuery(Version version) {
        Query query = null;
        for (VersionEntry versionEntry : this.m_queryMap.keySet()) {
            if (version.compareTo(versionEntry.m_min) < 0) break;
            if (versionEntry.m_max != null && version.compareTo(versionEntry.m_max) > 0) continue;
            query = this.m_queryMap.get(versionEntry);
        }
        return query != null ? query : this.m_default;
    }

    public int getLoadedQueryCount() {
        return this.m_queryList.size();
    }

    public void initQueries(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode == null ? this.m_node : xMLNode;
        this.m_queryList = new ArrayList<Query>();
        if (xMLNode2 != null) {
            this.m_queryList.addAll(Query.getQueries((Node)xMLNode2));
            for (Query query : this.m_queryList) {
                Version version = query.getMinversion();
                Version version2 = query.getMaxversion();
                if (version == null && version2 == null) {
                    this.setDefaultQuery(query);
                    continue;
                }
                this.addQuery(version, version2, query);
            }
        }
    }

    private class VersionEntry
    implements Comparable<VersionEntry> {
        private Version m_min;
        private Version m_max;

        private VersionEntry(Version version, Version version2) {
            assert (version != null || version2 != null);
            this.m_min = version;
            this.m_max = version2;
        }

        @Override
        public int compareTo(VersionEntry versionEntry) {
            if (this == versionEntry) {
                return 0;
            }
            int n = this.m_min.compareTo(versionEntry.m_min);
            if (n == 0) {
                n = this.m_max != null ? (versionEntry.m_max != null ? this.m_max.compareTo(versionEntry.m_max) : 1) : (versionEntry.m_max != null ? -1 : 0);
            }
            return n;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof VersionEntry && ModelUtil.areEqual(this.m_min, ((VersionEntry)object).m_min) && ModelUtil.areEqual(this.m_max, ((VersionEntry)object).m_max);
        }

        public int hashCode() {
            return this.m_min.hashCode() + (this.m_max != null ? this.m_max.hashCode() : 0);
        }
    }
}

