/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.MessageFormat;
import java.util.Locale;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPLTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OraMessageFormat
extends MessageFormat {
    public OraMessageFormat(String string) {
        super(string);
    }

    public OraMessageFormat(String string, Locale locale) {
        super(string, locale);
    }

    public static String format(String string, Object ... objectArray) {
        return OraMessageFormat.format(string, null, objectArray);
    }

    public static String format(String string, DefaultNLSProvider defaultNLSProvider, Object ... objectArray) {
        OraMessageFormat oraMessageFormat = new OraMessageFormat(string);
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (objectArray[i] instanceof NUMBER) {
                    objectArray[i] = ((NUMBER)objectArray[i]).bigDecimalValue();
                    continue;
                }
                if (objectArray[i] instanceof DATE) {
                    objectArray[i] = OraDATE.getInstance((DATE)objectArray[i]).getTime();
                    continue;
                }
                if (objectArray[i] instanceof TIMESTAMP) {
                    objectArray[i] = OraTIMESTAMP.getInstance((TIMESTAMP)objectArray[i]).getTime();
                    continue;
                }
                if (objectArray[i] instanceof TIMESTAMPTZ) {
                    objectArray[i] = OraTIMESTAMPTZ.getInstance((TIMESTAMPTZ)objectArray[i]).getTime();
                    continue;
                }
                if (!(objectArray[i] instanceof TIMESTAMPLTZ)) continue;
                if (defaultNLSProvider != null) {
                    objectArray[i] = OraTIMESTAMPLTZ.getInstance((TIMESTAMPLTZ)objectArray[i], defaultNLSProvider.getSessionTimeZone(), defaultNLSProvider.getDatabaseTimeZone()).getTime();
                    continue;
                }
                objectArray[i] = OraTIMESTAMPLTZ.getInstance((TIMESTAMPLTZ)objectArray[i]).getTime();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return oraMessageFormat.format(objectArray);
    }
}

