/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowXquery
implements IShowCommand {
    private static final String[] SHOWXQUERY = new String[]{"xquery"};

    @Override
    public String[] getShowAliases() {
        return SHOWXQUERY;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowXquery(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowXquery(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (DBUtil.getDbVersion(connection).compareTo(new Version("10.2")) < 0) {
            scriptRunnerContext.write(Messages.getString("SERVER_VERSION_TOO_LOW"));
            return true;
        }
        String string = (String)scriptRunnerContext.getProperty("xquery.baseuri");
        String string2 = (String)scriptRunnerContext.getProperty("xquery.ordering");
        String string3 = (String)scriptRunnerContext.getProperty("xquery.node");
        String string4 = (String)scriptRunnerContext.getProperty("xquery.context");
        if (string == null) {
            string = "";
        }
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            string = "\"" + string + "\"";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (!string4.startsWith("\"") || !string4.endsWith("\"")) {
            string4 = "\"" + string4 + "\"";
        }
        if (string2 == null) {
            string2 = "DEFAULT";
        }
        if (string3 == null) {
            string3 = "DEFAULT";
        }
        scriptRunnerContext.write("xquery BASEURI " + string + " CONTEXT " + string4 + " NODE " + string3 + " ORDERING " + string2 + "\n");
        return true;
    }
}

