/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.net.URL;
import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowURLs
implements IShowCommand {
    private static final String[] SHOWURLS = new String[]{"url"};

    @Override
    public String[] getShowAliases() {
        return SHOWURLS;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowURLs(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowURLs(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (scriptRunnerContext.getProperty("script.runner.topbase.url") != null) {
                scriptRunnerContext.write(SHOWURLS[0] + " top_base_url \"" + ((URL)scriptRunnerContext.getProperty("script.runner.topbase.url")).toString() + "\"");
            } else {
                scriptRunnerContext.write(SHOWURLS[0] + " top_base_url \"\"");
            }
            if (scriptRunnerContext.getProperty("script.runner.base.url") != null) {
                scriptRunnerContext.write("    base_url \"" + ((URL)scriptRunnerContext.getProperty("script.runner.base.url")).toString() + "\"");
            } else {
                scriptRunnerContext.write("    base_url \"\"");
            }
            if (scriptRunnerContext.getProperty("script.runner.node.url") != null) {
                String string = ((URL)scriptRunnerContext.getProperty("script.runner.node.url")).toString();
                int n = string.lastIndexOf(92);
                int n2 = string.lastIndexOf(47);
                if (n2 > n) {
                    n = n2;
                }
                if (n != -1) {
                    scriptRunnerContext.write("    node_url " + Messages.getString("PARENT") + " \"" + string.substring(0, n) + "\"\n");
                } else {
                    scriptRunnerContext.write("    node_url \"" + string + "\"\n");
                }
            } else {
                scriptRunnerContext.write("    node_url \"\" \n");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }
}

