/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowSystemOut
implements IShowCommand {
    private static final String[] SHOWSYSTEMOUT = new String[]{"systemout"};

    @Override
    public String[] getShowAliases() {
        return SHOWSYSTEMOUT;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSystemOut(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowSystemOut(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (scriptRunnerContext.getProperty("script.runner.using.systemout") != null) {
                scriptRunnerContext.write("systemout \"" + ((Boolean)scriptRunnerContext.getProperty("script.runner.using.systemout")).toString() + "\"\n");
            } else {
                scriptRunnerContext.write("systemout \"\" \n");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }
}

