/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IParsedShow;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowRecyclebin
implements IShowCommand,
IParsedShow {
    private static final String[] SHOWRECYCLE = new String[]{"recyc", "recycl", "recycle", "recycleb", "recyclebi", "recyclebin"};

    @Override
    public String[] getShowAliases() {
        return SHOWRECYCLE;
    }

    @Override
    public String handleShowRemainder(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowRecyclebin(connection, scriptRunnerContext, iSQLCommand);
        }
        return null;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doShowRecyclebin(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string;
        block59: {
            String string2;
            string = ScriptUtils.eatOneWord(ScriptUtils.eatOneWord(iSQLCommand.getSql()).trim()).trim();
            boolean bl = true;
            int n = -1;
            int n2 = string.length();
            boolean bl2 = false;
            boolean bl3 = false;
            while (bl) {
                if (++n == n2) {
                    bl = false;
                    break;
                }
                string2 = string.substring(n, n + 1);
                if (string2.equals("\"")) {
                    if (bl3) continue;
                    if (!bl2) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (string2.equals("'")) {
                    if (bl2) continue;
                    if (!bl3) {
                        bl3 = true;
                        continue;
                    }
                    bl3 = false;
                    continue;
                }
                if (!string2.matches("\\s") || bl2 || bl3) continue;
                bl = false;
                break;
            }
            if ((string2 = string.substring(0, n).trim()).startsWith("\"") && string2.endsWith("\"") && string2.length() > 1) {
                string2 = string2.substring(1, string2.length() - 1);
            } else if (string2.startsWith("'") && string2.endsWith("'") && string2.length() > 1) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            string = n == n2 ? "" : string.substring(n).trim();
            if (DBUtil.getDbVersion(connection).compareTo(new Version("10.0")) < 0) {
                scriptRunnerContext.write(Messages.getString("SERVER_VERSION_TOO_LOW"));
                return string;
            }
            boolean bl4 = false;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string3;
                String string4;
                String string5;
                boolean bl5;
                block60: {
                    bl4 = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getBaseConnection());
                    if (!bl4) break block59;
                    bl5 = false;
                    string5 = null;
                    string4 = " where original_name = :INPUT";
                    String string6 = "select original_name \"ORIGINAL NAME\", object_name \"RECYCLEBIN NAME\", type \"OBJECT TYPE\", droptime  \"DROP TIME\"   from dba_recyclebin r where owner = USER";
                    string3 = "select original_name \"ORIGINAL NAME\", object_name \"RECYCLEBIN NAME\", type \"OBJECT TYPE\", droptime  \"DROP TIME\"  from recyclebin r";
                    try {
                        if (!string2.equals("")) {
                            string5 = string6 + string4;
                            statement = connection.prepareStatement(string5);
                            statement.setString(1, string2);
                        } else {
                            string5 = string6;
                            statement = connection.prepareStatement(string5);
                        }
                        resultSet = statement.executeQuery();
                    }
                    catch (SQLException sQLException) {
                        bl5 = true;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                        if (statement == null) break block60;
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException3) {
                            // empty catch block
                        }
                    }
                }
                if (bl5) {
                    if (!string2.equals("")) {
                        string5 = string3 + string4;
                        statement = connection.prepareStatement(string5);
                        statement.setString(1, string2);
                    } else {
                        string5 = string3;
                        statement = connection.prepareStatement(string5);
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    resultSet = statement.executeQuery();
                }
                if (!resultSet.next()) break block59;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (!string2.equals("")) {
                    statement = connection.prepareStatement(string5);
                    statement.setString(1, string2);
                } else {
                    statement = connection.prepareStatement(string5);
                }
                resultSet = statement.executeQuery();
                ResultSetFormatter resultSetFormatter = new ResultSetFormatter(scriptRunnerContext);
                resultSetFormatter.setProgressUpdater(scriptRunnerContext.getTaskProgressUpdater());
                int n3 = resultSetFormatter.rset2sqlplusShrinkToSize(resultSet, connection, scriptRunnerContext.getOutputStream());
            }
            catch (IOException iOException) {
                scriptRunnerContext.write(iOException.getLocalizedMessage());
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                scriptRunnerContext.write(sQLException.getLocalizedMessage());
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (bl4) {
                    DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getBaseConnection());
                }
            }
        }
        return string;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }
}

