/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowAllNeither;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowObsolete
implements IShowCommand,
IShowAllNeither {
    private static final String[] SHOWOBSOLETE = new String[]{"sqlpluscompa", "sqlpluscompat", "sqlpluscompati", "sqlpluscompatib", "sqlpluscompatibi", "sqlpluscompatibil", "sqlpluscompatibili", "sqlpluscompatibilit", "sqlpluscompatibility", "sqlc", "sqlco", "sqlcon", "sqlcont", "sqlconti", "sqlcontin", "sqlcontinu", "sqlcontinue", "exitc", "exitcom", "exitcomm", "exitcommit", "flu", "flus", "flush", "doc", "docu", "docum", "docume", "documen", "document", "maxd", "maxda", "maxdat", "maxdata", "sqlpre", "sqlpref", "sqlprefi", "sqlprefix", "label", "closecur", "closecurs", "closecurso", "closecursor", "com", "comp", "compa", "compat", "compata", "compatab", "compatabi", "compatabil", "compatabili", "compatabilit", "compatability", "_ociclientversion", "cmds", "cmdse", "cmdsep", "tab", "escchar", "desc", "descr", "describe"};

    @Override
    public String[] getShowAliases() {
        return SHOWOBSOLETE;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return ShowObsolete.doObsolete(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    public static boolean doObsolete(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim().toLowerCase().replaceAll("^show?\\s+", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            scriptRunnerContext.write(MessageFormat.format("show {0} is obsolete.\n", string2));
        }
        return true;
    }
}

