/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;

public class ShowJdbc
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWJDBC = new String[]{"jdbc"};

    @Override
    public String[] getShowAliases() {
        return SHOWJDBC;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() != null) {
            return this.doShowJDBC(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doShowJDBC(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer();
            try {
                if (!DBUtil.getConnectionResolver().lock(connection)) break block5;
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    stringBuffer.append("-- Database Info --\n");
                    stringBuffer.append("Database Product Name: " + databaseMetaData.getDatabaseProductName() + "\n");
                    stringBuffer.append("Database Product Version: " + databaseMetaData.getDatabaseProductVersion() + "\n");
                    stringBuffer.append("Database Major Version: " + databaseMetaData.getDatabaseMajorVersion() + "\n");
                    stringBuffer.append("Database Minor Version: " + databaseMetaData.getDatabaseMinorVersion() + "\n");
                    stringBuffer.append("-- Driver Info --\n");
                    stringBuffer.append("Driver Name: " + databaseMetaData.getDriverName() + "\n");
                    stringBuffer.append("Driver Version: " + databaseMetaData.getDriverVersion() + "\n");
                    stringBuffer.append("Driver Major Version: " + databaseMetaData.getDriverMajorVersion() + "\n");
                    stringBuffer.append("Driver Minor Version: " + databaseMetaData.getDriverMinorVersion() + "\n");
                    stringBuffer.append("Driver URL: " + databaseMetaData.getURL() + "\n");
                }
                finally {
                    DBUtil.getConnectionResolver().unlock(connection);
                }
            }
            catch (Exception exception) {
                stringBuffer.append("\nUnable to gather information\n");
            }
        }
        scriptRunnerContext.write(stringBuffer.toString());
        return true;
    }
}

