/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.math.BigInteger;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowHeadsep
implements IShowCommand {
    private static final String[] SHOWHEADSEP = new String[]{"heads", "headse", "headsep"};

    @Override
    public String[] getShowAliases() {
        return SHOWHEADSEP;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowHeadsep(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowHeadsep(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setheadsep");
        if (string.matches("(?i:on|off)")) {
            String string2 = "";
            if (string.equalsIgnoreCase("ON")) {
                String string3 = (String)scriptRunnerContext.getProperty("script.runner.setheadsepchar");
                string2 = MessageFormat.format(Messages.getString("HEADSEP_ON"), string3, String.format("%x", new BigInteger(string3.getBytes())));
                string2 = string2 + Show.m_lineSeparator;
            } else {
                string2 = Messages.getString("HEADSEP_OFF") + Show.m_lineSeparator;
            }
            scriptRunnerContext.write(string2);
        }
        return true;
    }
}

