/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowFeedback
implements IShowCommand {
    private static final String[] SHOWFEEDBACK = new String[]{"feedback", "feedbac", "feedba", "feedb", "feed"};

    @Override
    public String[] getShowAliases() {
        return SHOWFEEDBACK;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doFeedback(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doFeedback(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        int n = scriptRunnerContext.getFeedback();
        if (n == -1) {
            scriptRunnerContext.write("FEEDBACK ON\n");
        } else if (n == -2) {
            scriptRunnerContext.write("FEEDBACK OFF\n");
        } else if (n == 0) {
            scriptRunnerContext.setFeedback(-2);
            scriptRunnerContext.write("FEEDBACK OFF\n");
        } else {
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("FEEDBACKONFORN"), "FEEDBACK ON", n));
        }
        return true;
    }
}

