/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowEscape
implements IShowCommand {
    private static final String[] SHOWESCAPE = new String[]{"esc", "esca", "escap", "escape"};

    @Override
    public String[] getShowAliases() {
        return SHOWESCAPE;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowEscape(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowEscape(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getEscape()) {
            String string = "escape \"{0}\" (hex {1})";
            scriptRunnerContext.write(MessageFormat.format(string, Character.valueOf(scriptRunnerContext.getEscapeChar()), String.format("%x", scriptRunnerContext.getEscapeChar())) + "\n");
        } else {
            scriptRunnerContext.write("escape OFF\n");
        }
        return true;
    }
}

