/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowCommandLine
implements IShowCommand {
    private static final String[] SHOWCOMMANDLINE = new String[]{"commandline"};

    @Override
    public String[] getShowAliases() {
        return SHOWCOMMANDLINE;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSQLCli(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowSQLCli(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (scriptRunnerContext.isCommandLine()) {
                scriptRunnerContext.write("commandline true\n");
            } else {
                scriptRunnerContext.write("commandline false\n");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }
}

