/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowColsep
implements IShowCommand {
    private static final String[] SHOWCOLSEP = new String[]{"colsep"};

    @Override
    public String[] getShowAliases() {
        return SHOWCOLSEP;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowColsep(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowColsep(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setcolsep");
        String string2 = MessageFormat.format(Messages.getString("COLSEP"), string) + Show.m_lineSeparator;
        scriptRunnerContext.write(string2);
        return true;
    }
}

