/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.query.Bind;

public class ShowBinds
implements IShowCommand,
IShowPrefixNameNewline,
IShowNoRows {
    private static final String[] SHOWBINDS = new String[]{"binds"};

    @Override
    public String[] getShowAliases() {
        return SHOWBINDS;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Map<String, Bind> map = scriptRunnerContext.getVarMap();
        if (map.size() != 0) {
            String string = (String)scriptRunnerContext.getProperty("script.runner.optional_show_header");
            if (string != null && !string.equals("")) {
                scriptRunnerContext.write(string);
            }
            SQLCommand sQLCommand = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_PRINT, SQLCommand.StmtResultType.G_R_NONE, true);
            sQLCommand.setOrigSQL("print");
            sQLCommand.setSql("print");
            SQLPLUS sQLPLUS = new SQLPLUS(sQLCommand, scriptRunnerContext.getOutputStream());
            sQLPLUS.setConn(connection);
            sQLPLUS.setScriptRunnerContext(scriptRunnerContext);
            sQLPLUS.run();
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

