/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowAppicmd
implements IShowCommand {
    private static final String[] SHOWAPPICMD = new String[]{"appi", "appin", "appinf", "appinfo"};

    @Override
    public String[] getShowAliases() {
        return SHOWAPPICMD;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowAppicmd(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowAppicmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            String string = "";
            boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.appinfo");
            String string2 = "OFF";
            if (!bl) {
                string = SQLPLUS.PRODUCT_NAME;
                if (connection != null) {
                    string = this.newValue(scriptRunnerContext, string);
                }
            } else {
                string = this.newValue(scriptRunnerContext, string);
            }
            if (scriptRunnerContext.getProperty("script.runner.appinfo") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.appinfo").equals(new Boolean(true))).booleanValue()) {
                string2 = "ON";
            }
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("APPINFO"), string2, string) + "\n");
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newValue(ScriptRunnerContext scriptRunnerContext, String string) throws SQLException {
        if (scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            boolean bl = false;
            Statement statement = null;
            try {
                bl = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getCurrentConnection());
                if (bl) {
                    statement = scriptRunnerContext.getCurrentConnection().prepareCall("BEGIN DBMS_APPLICATION_INFO.READ_MODULE(:MOD, :ACT); END;");
                    statement.registerOutParameter(1, 12);
                    statement.registerOutParameter(2, 12);
                    statement.execute();
                    string = statement.getString(1);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    try {
                        DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getCurrentConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return string;
    }
}

