/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.net;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.net.Net;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetParser;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;

public class NetEntries {
    public static final String CONFIGFILE = File.separator + "netEntries.xml";
    public static final String CONFIGBACK = File.separator + "netEntries.xml~";
    public static Object LOCK = new Object();
    private HashMap<String, Net> netEntries = new HashMap();
    private static NetEntries _INSTANCE;
    private Set<String> netEntriesUpper = new HashSet<String>();

    public static String getBase() {
        String string = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String string2 = System.getenv("APPDATA");
            string = string2 != null ? string2 + File.separator + "sdsql" : null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetEntries getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_INSTANCE == null) {
                _INSTANCE = new NetEntries();
                _INSTANCE.load();
            }
        }
        return _INSTANCE;
    }

    private NetEntries() {
        URL uRL = this.getClass().getClassLoader().getResource("oracle/dbtools/raptor/newscriptrunner/commands/net/netEntries.xml");
        NetParser netParser = new NetParser();
        try {
            ArrayList<Net> arrayList = netParser.processXML(uRL);
            for (Net net : arrayList) {
                this.netEntries.put(net.getName(), net);
                this.netEntriesUpper.add(net.getName().toUpperCase());
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getLocalizedMessage());
        }
    }

    public static ArrayList<String> getMatching(String string) {
        return NetEntries.getMatching(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getMatching(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        if (string == null || string.equals("")) {
            bl2 = true;
        } else {
            string = string.toUpperCase();
        }
        Object object = LOCK;
        synchronized (object) {
            ArrayList<String> arrayList2;
            NetEntries netEntries = NetEntries.getInstance();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<TCPTNSEntry> arrayList3 = TNSHelper.getTNSEntries();
            if (arrayList3 != null) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    String string2 = arrayList3.get(i).getName();
                    String string3 = string2.toUpperCase();
                    if (!bl2 && !string3.startsWith(string) || hashSet.contains(string3)) continue;
                    hashSet.add(string3);
                    arrayList.add(string2);
                }
            }
            if (bl && (arrayList2 = netEntries.getNetEntries()) != null) {
                for (String string3 : arrayList2) {
                    String string4 = string3.toUpperCase();
                    if (!bl2 && !string4.startsWith(string) || hashSet.contains(string4)) continue;
                    hashSet.add(string4);
                    arrayList.add(string3);
                }
            }
            Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        }
        return arrayList;
    }

    public void add() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string, String string2, String string3) {
        Object object = LOCK;
        synchronized (object) {
            if (this.netEntriesUpper.contains(string.toUpperCase())) {
                this.removeIgnoreCase(string);
                this.netEntriesUpper.remove(string.toUpperCase());
            }
            Net net = new Net(string, string2, string3);
            this.netEntries.put(string, net);
            this.netEntriesUpper.add(string.toUpperCase());
            this.save();
        }
    }

    public void removeIgnoreCase(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.netEntries.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            arrayList.add(string2);
        }
        for (String string2 : arrayList) {
            this.netEntries.remove(string2);
        }
    }

    public String getKeyIgnoreCase(String string) {
        for (String string2 : this.netEntries.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return string2;
        }
        return null;
    }

    public void add(String string, String string2) {
        this.add(string, string2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(String string) {
        Object object = LOCK;
        synchronized (object) {
            if (this.netEntriesUpper.contains(string.toUpperCase())) {
                this.removeIgnoreCase(string);
                this.netEntriesUpper.remove(string.toUpperCase());
                this.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getNetEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = LOCK;
        synchronized (object) {
            for (String string : this.netEntries.keySet()) {
                arrayList.add(string);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) {
        Object object = LOCK;
        synchronized (object) {
            return this.netEntriesUpper.contains(string.toUpperCase());
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string) {
        Object object = LOCK;
        synchronized (object) {
            Net net = this.netEntries.get(string);
            if (net != null) {
                return net.getQuery();
            }
            Set<String> set = this.netEntries.keySet();
            for (String string2 : set) {
                Net net2;
                if (!string2.equalsIgnoreCase(string) || (net2 = this.netEntries.get(string2)) == null) continue;
                return net2.getQuery();
            }
            return null;
        }
    }

    public String save() {
        return this.save(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(String string) {
        ArrayList<Net> arrayList = new ArrayList<Net>();
        String string2 = null;
        Object object = LOCK;
        synchronized (object) {
            NetParser netParser = new NetParser();
            try {
                String string3 = NetEntries.getBase();
                if (string3 == null) {
                    throw new Exception("NET-013 APPDATA is null");
                }
                if (string3 != null && !new File(string3).exists() && !new File(string3).mkdirs()) {
                    throw new Exception("NET-009 " + string3 + " Directory did not create");
                }
                File file = null;
                if (string != null) {
                    file = new File(string);
                } else {
                    string = string3 + CONFIGFILE;
                    file = new File(string);
                    if (string3 != null && new File(string3 + CONFIGFILE).exists()) {
                        if (new File(string3 + CONFIGBACK).exists() && !new File(string3 + CONFIGBACK).delete()) {
                            throw new Exception("NET-011 " + string3 + CONFIGBACK + " could not be deleted ");
                        }
                        try {
                            Files.move(Paths.get(string3 + CONFIGFILE, new String[0]), Paths.get(string3 + CONFIGBACK, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Exception exception) {
                            throw new Exception("NET-010 " + string3 + CONFIGFILE + " could not be renamed to " + string3 + CONFIGBACK + " " + exception.getMessage());
                        }
                    }
                }
                for (Map.Entry<String, Net> entry : this.netEntries.entrySet()) {
                    Net net = entry.getValue();
                    arrayList.add(net);
                }
                if (string3 != null) {
                    netParser.putXML(file, arrayList);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getLocalizedMessage());
                string2 = exception.getLocalizedMessage() + "\n";
            }
        }
        if (string2 == null) {
            return MessageFormat.format("Net-007 - Net Entries saved to {0}\n", string);
        }
        return string2;
    }

    public String load() {
        return this.load(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String load(String string) {
        Object object = LOCK;
        synchronized (object) {
            block11: {
                Object object2;
                File file = null;
                if (string != null) {
                    file = new File(string);
                } else {
                    object2 = NetEntries.getBase();
                    if (object2 == null) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "NET-013 APPDATA is null\n");
                    }
                    string = (String)object2 + CONFIGFILE;
                    file = new File(string);
                }
                object2 = new NetParser();
                try {
                    if (file != null && file.exists()) {
                        URL uRL = file.toURI().toURL();
                        if (file.canRead()) {
                            ArrayList<Net> arrayList = ((NetParser)object2).processXML(uRL);
                            for (Net net : arrayList) {
                                this.removeIgnoreCase(net.getName());
                                this.netEntries.put(net.getName(), net);
                                this.netEntriesUpper.add(net.getName().toUpperCase());
                            }
                            break block11;
                        }
                        return MessageFormat.format("NET-012 {0} could not be read.\n", string);
                    }
                    return MessageFormat.format("NET-012 {0} could not be read.\n", string);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
                }
            }
        }
        return "";
    }
}

