/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.net;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.raptor.query.Bind;

public class NetCommand
extends CommandListener
implements IHelp {
    private static String LIST = "list";
    private static String DROP = "drop";
    private static String NET = "net";
    private static String SAVE = "save";
    private static String LOAD = "load";
    private static String SHOW = "show";
    private static String HELP = "help";
    public static final String ON = "ON";
    public static final String OFF = "OFF";
    public static final String WARN = "WARN";
    public static final String READONLY = "READONLY";

    @Override
    public String getCommand() {
        return "NET";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String[] stringArray = iSQLCommand.getSql().trim().split("[ \t\n]+");
        if (stringArray.length <= 0) return false;
        String string = null;
        if (!stringArray[0].toLowerCase().equals(this.getCommandName())) return false;
        if (stringArray.length == 1) {
            ArrayList<String> arrayList = NetEntries.getInstance().getNetEntries();
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                scriptRunnerContext.write(iterator.next() + "\n");
            }
            return this.handleReturn(true);
        }
        if (stringArray.length <= 1) {
            scriptRunnerContext.write("NET-002: Net add not enough arguments\n");
            return this.handleReturn(true);
        }
        String string2 = "";
        if (iSQLCommand.getSql().contains("=") && !stringArray[1].startsWith("=")) {
            String string3;
            String[] stringArray2 = iSQLCommand.getSql().trim().split("=")[0].split("\\s+");
            string2 = stringArray2[1];
            if (stringArray2.length > 2) {
                string2 = string2 + stringArray2[2];
            }
            if ((string3 = iSQLCommand.getSql().substring(iSQLCommand.getSql().toLowerCase().indexOf("=") + 1).trim()).startsWith(":")) {
                if (string3.length() > 1) {
                    string3 = string3.substring(1);
                    Bind bind = scriptRunnerContext.getVarMap().get(string3.toUpperCase());
                    if (bind != null) {
                        string = bind.getValue();
                    }
                }
                if (string == null || string.equals("")) {
                    scriptRunnerContext.write("NET-006: No valid bind value\n");
                    return this.handleReturn(true);
                }
            } else {
                String string4 = string3.toUpperCase();
                if (string3.length() > 5 && string4.startsWith("Q'") && string3.endsWith(ScriptParser.getEndQuoteString(string3.substring(2, 3)) + "'")) {
                    string3 = string3.substring(3, string3.length() - 2);
                } else if (string3 == null || string3.equals("")) {
                    scriptRunnerContext.write("NET-005: String not valid\n");
                    return this.handleReturn(true);
                }
                string = string3;
            }
            NetCommand.add(scriptRunnerContext, (String)scriptRunnerContext.getProperty("script.runner.setnetoverwrite"), string2, string, true);
            return this.handleReturn(true);
        }
        if (stringArray[1].toLowerCase().equals(DROP)) {
            if (stringArray.length != 3) return false;
            NetEntries.getInstance().drop(stringArray[2]);
            return this.handleReturn(true);
        }
        if (stringArray[1].toLowerCase().equals(LIST)) {
            String string5 = "";
            if (stringArray.length > 2 && stringArray[2].length() > 0) {
                string5 = stringArray[2];
                String string6 = NetEntries.getInstance().get(string5);
                if (string6 != null) {
                    String string7 = new String(new char[string5.length()]).replace("\u0000", "-");
                    scriptRunnerContext.write(MessageFormat.format("{0}\n{1}\n", string5, string7));
                    scriptRunnerContext.write(string6 + "\n");
                    return this.handleReturn(true);
                }
                scriptRunnerContext.write(MessageFormat.format("NET-010 - net {0} not found \n", string5));
                return this.handleReturn(true);
            }
            Iterator<String> iterator = NetEntries.getInstance().getNetEntries().iterator();
            while (iterator.hasNext()) {
                scriptRunnerContext.write(iterator.next() + "\n");
            }
            return this.handleReturn(true);
        }
        if (stringArray[1].toLowerCase().equals(SAVE)) {
            if (scriptRunnerContext.getProperty("script.runner.jline") == null) {
                scriptRunnerContext.write("NET-008 - save only enabled in command line mode\n");
                return this.handleReturn(true);
            }
            if (stringArray.length > 2 && stringArray[2] != null) {
                scriptRunnerContext.write(NetEntries.getInstance().save(stringArray[2]));
                return this.handleReturn(true);
            }
            scriptRunnerContext.write(NetEntries.getInstance().save());
            return this.handleReturn(true);
        }
        if (stringArray[1].toLowerCase().equals(LOAD)) {
            if (scriptRunnerContext.getProperty("script.runner.jline") == null) {
                scriptRunnerContext.write("NET-009 - load only enabled in command line mode\n");
                return this.handleReturn(true);
            }
            if (stringArray.length > 2 && stringArray[2] != null) {
                scriptRunnerContext.write(NetEntries.getInstance().load(stringArray[2]));
                return this.handleReturn(true);
            }
            scriptRunnerContext.write(NetEntries.getInstance().load());
            return this.handleReturn(true);
        }
        if (stringArray[1].toLowerCase().equals(LOAD)) {
            if (scriptRunnerContext.getProperty("script.runner.jline") != null) {
                NetEntries.getInstance().load();
                return this.handleReturn(true);
            }
            scriptRunnerContext.write("NET-009 - load only enabled in command line mode\n");
            return this.handleReturn(true);
        }
        if (stringArray[1].toLowerCase().equals(HELP)) {
            scriptRunnerContext.write(this.getHelp());
            return false;
        }
        scriptRunnerContext.write("NET-001: Net command not found\n");
        return this.handleReturn(true);
    }

    public static void addOrWarn(ScriptRunnerContext scriptRunnerContext, String string, String string2, String string3, boolean bl) {
        if (string == null) {
            string = WARN;
        }
        String string4 = NetEntries.getInstance().get(string2);
        switch (string) {
            case "WARN": {
                if (string4 == null) break;
                if (string4 == null || !string3.trim().equalsIgnoreCase(string4.trim())) {
                    scriptRunnerContext.write(ScriptRunnerDbArb.format("KEY_EXISTS", "net " + string2.toUpperCase() + "=" + string3 + ";"));
                }
                return;
            }
            case "OFF": {
                if (string4 == null) break;
                return;
            }
        }
        if (string4 == null || !string3.trim().equalsIgnoreCase(string4.trim())) {
            NetEntries.getInstance().add(string2, string3);
        }
    }

    public static void add(ScriptRunnerContext scriptRunnerContext, String string, String string2, String string3, boolean bl) {
        if (string2.length() < 40 && string2.indexOf("=") == -1) {
            if (bl) {
                NetEntries.getInstance().add(string2, string3);
            } else {
                NetCommand.addOrWarn(scriptRunnerContext, string, string2, string3, bl);
            }
        }
        NetEntries.getInstance().save();
    }

    public String getCommandName() {
        return NET;
    }

    boolean handleReturn(boolean bl) {
        if (!bl) {
            // empty if block
        }
        return true;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

