/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.editor;

import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.plusplus.FileSystem;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;

public class StoreCommand
extends CommandListener
implements IHelp {
    private static final String SET = "set";
    private static final String DOT = ".";
    private static final String CMD = "save";
    private static final String HELP = "STORE {SET} file_name[.ext] [CRE[ATE] | REP[LACE] | APP[END]]\n";
    private static final String FILE = "file";
    private static final String CREATE_PATTERN = "(?i:cre(?:ate))";
    private static final String APPEND_PATTERN = "(?i:app(?:end))";
    private static final String REPLACE_PATTERN = "(?i:rep(?:lace))";
    private static final String FILENAME_PATTERN = "(?i:cre(?:ate))|(?i:app(?:end))|(?i:rep(?:lace))";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim();
        String[] stringArray = string.split("\\s+");
        String string2 = null;
        Object var7_7 = null;
        FileSystem.State state = FileSystem.State.UNKNOWN;
        switch (stringArray.length) {
            case 1: {
                this.writeMissingSet(scriptRunnerContext);
                this.writeHelp(scriptRunnerContext);
                return true;
            }
            case 2: {
                if (stringArray[1].toLowerCase().equals(SET)) {
                    scriptRunnerContext.write("SP2-0556: Invalid file name.\n");
                    this.writeHelp(scriptRunnerContext);
                } else {
                    this.writeMissingSet(scriptRunnerContext);
                    this.writeHelp(scriptRunnerContext);
                }
                return true;
            }
            case 3: {
                if (!stringArray[1].toLowerCase().equals(SET)) {
                    this.writeMissingSet(scriptRunnerContext);
                    this.writeHelp(scriptRunnerContext);
                    return true;
                }
                if (this.isReservedName(stringArray[2])) {
                    this.writeReserved(scriptRunnerContext);
                    return true;
                }
                string2 = scriptRunnerContext.prependCD(stringArray[2]);
                break;
            }
            case 4: {
                if (!stringArray[1].toLowerCase().equals(SET)) {
                    this.writeMissingSet(scriptRunnerContext);
                    this.writeHelp(scriptRunnerContext);
                    return true;
                }
                if (!this.isReservedName(stringArray[3])) {
                    this.writeIllegalStoreCommand(scriptRunnerContext);
                    this.writeHelp(scriptRunnerContext);
                    return true;
                }
                if (this.isReservedName(stringArray[2])) {
                    this.writeReserved(scriptRunnerContext);
                    return true;
                }
                string2 = scriptRunnerContext.prependCD(stringArray[2]);
                state = this.getMode(stringArray[3]);
                break;
            }
            default: {
                this.writeIllegalStoreCommand(scriptRunnerContext);
                this.writeHelp(scriptRunnerContext);
                return true;
            }
        }
        if (string2.lastIndexOf(DOT) == -1) {
            String string3 = (String)scriptRunnerContext.getProperty("script.runner.file.suffix");
            if (!scriptRunnerContext.getProperty("script.runner.file.suffix").equals("")) {
                string2 = string2 + DOT + scriptRunnerContext.getProperty("script.runner.file.suffix");
            }
        }
        scriptRunnerContext.write(scriptRunnerContext.save(string2, state.ordinal()));
        return true;
    }

    private FileSystem.State getMode(String string) {
        Matcher matcher = Pattern.compile(CREATE_PATTERN).matcher(string);
        if (matcher != null && matcher.find()) {
            return FileSystem.State.CREATE;
        }
        matcher = Pattern.compile(APPEND_PATTERN).matcher(string);
        if (matcher != null && matcher.find()) {
            return FileSystem.State.APPEND;
        }
        matcher = Pattern.compile(REPLACE_PATTERN).matcher(string);
        if (matcher != null && matcher.find()) {
            return FileSystem.State.REPLACE;
        }
        return FileSystem.State.UNKNOWN;
    }

    private void writeIllegalStoreCommand(ScriptRunnerContext scriptRunnerContext) {
        scriptRunnerContext.write("SP2-0603: Illegal STORE command\n");
    }

    private void writeReserved(ScriptRunnerContext scriptRunnerContext) {
        scriptRunnerContext.write("SP2-0108: The filenames CREATE, REPLACE, APPEND, FILE, and abbreviations may not be used.\n");
    }

    private boolean isReservedName(String string) {
        Pattern pattern = Pattern.compile(FILENAME_PATTERN);
        Matcher matcher = pattern.matcher(string);
        return matcher != null && matcher.find();
    }

    private void writeMissingSet(ScriptRunnerContext scriptRunnerContext) {
        scriptRunnerContext.write("SP2-0088: missing SET keyword\n");
    }

    private void writeHelp(ScriptRunnerContext scriptRunnerContext) {
        scriptRunnerContext.write(this.getHelp());
    }

    @Override
    public String getCommand() {
        return "STORE";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

