/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.NUMBER;

public class Title
extends CommandListener {
    protected static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String LEFTPTRN = "(?i:\\bl(?:e|ef|eft)\\b)";
    private static final String LEFTCMDPTRN = "(?i:(?i:\\bl(?:e|ef|eft)\\b)\\s+(?:'[^']+'\\s+(?i:sql.pno)|'[^']+'|(?i:sql.pno)))";
    private static final String RIGHTPTRN = "(?i:\\br(?:|i|ig|igh|ight)\\b)";
    private static final String RIGHTCMDPTRN = "(?i:(?i:\\br(?:|i|ig|igh|ight)\\b)\\s+(?:\\'[^\\']+\\'\\s+(?i:sql.pno)|\\'[^\\']+\\'|(?i:sql.pno)))";
    private static final String CENTERPTRN = "(?i:\\bc(?:e|en|ent|ente|enter)\\b)";
    private static final String CENTERCMDPTRN = "(?i:(?i:\\bc(?:e|en|ent|ente|enter)\\b)\\s+(?:\\'[^\\']+\\'\\s+(?i:sql.pno)|\\'[^\\']+\\'|(?i:sql.pno)))";
    private static final String SKIPPTRN = "(?i:\\bs(?:|k|ki|kip)\\b)";
    private static final String SKIPPTRN_HAS_NUM = "(?i:\\bs(?:|k|ki|kip)\\d{1,2}\\b)";
    private static final String SKIPCMDPTRN = "(?i:(?i:\\bs(?:|k|ki|kip)\\b)(?:|\\s+)(?:\\d+|\\z))";
    private static final String FORMATPTRN = "(?i:\\bformat\\b)";
    private static final String COLPTRN = "(?i:\\bcol\\b)";
    private static final String COLCMDPTRN = "(?:(?i:\\bcol\\b)\\s+(?:|(?i:\\bformat\\b)\\s+)(?:'[^']+'|'[^']+'\\s+(?i:sql.pno)|.+))";
    private static final String FONTPTRN = "(?i:\\bfont\\b)";
    private static final String TABPTRN = "(?i:\\btab\\b)";
    private static final String JUSTIFY = "justify";
    private static final String COL = "col";
    private static final String TAB = "tab";
    private static final String FORMAT = "format";
    private static final String SKIP = "skip";
    private static final String SQLPNO = "SQL.PNO";
    private static final String SQLSCAN = "SQL.SCAN";
    private static final String JUSTIFYPTRN = "(?:(?i:\\bl(?:e|ef|eft)\\b)|(?i:\\bc(?:e|en|ent|ente|enter)\\b)|(?i:\\br(?:|i|ig|igh|ight)\\b))";
    private static final String SCAN_ON = "ON";
    private static final String SCAN_OFF = "OFF";
    private static final String CURRPAGENO = "(?i:sql.pno)";
    private static final int LINESIZE = 80;
    protected int m_linesize = -1;
    protected String m_titleCmd = "";
    protected String CMD = "";
    protected ArrayList<String> m_parsedList = null;
    protected Connection m_connection = null;
    protected String m_headsepchar = "";
    protected String m_scan = "";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }

    public StringBuffer getTitle(ScriptRunnerContext scriptRunnerContext, Integer n) {
        StringBuffer stringBuffer = new StringBuffer("");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        this.m_parsedList = new ArrayList();
        this.m_headsepchar = (String)scriptRunnerContext.getProperty("script.runner.setheadsepchar");
        this.m_linesize = (Integer)scriptRunnerContext.getProperty("script.runner.setlinesize") + m_lineSeparator.length();
        String string = this.m_scan = scriptRunnerContext.getScanOn() ? SCAN_ON : SCAN_OFF;
        if (this.m_linesize < 10) {
            this.m_linesize = 80 + m_lineSeparator.length();
        }
        if (this.m_linesize > 1) {
            stringBuffer.append(this.addLine());
            Object object = this.m_titleCmd;
            while (((String)object).split("\\s+").length > 0 && ((String)object).length() > 0) {
                String string2;
                String[] stringArray;
                Object object2;
                String string3;
                Object object3;
                Object object4;
                Object object5;
                String[] stringArray2 = this.splitStr((String)object);
                String string4 = stringArray2[0];
                if (string4.matches(JUSTIFYPTRN)) {
                    linkedHashMap.put(JUSTIFY, string4);
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                    continue;
                }
                if (string4.matches(SKIPPTRN) || string4.matches(SKIPPTRN_HAS_NUM)) {
                    object5 = null;
                    object4 = null;
                    if (string4.matches(SKIPPTRN_HAS_NUM)) {
                        object5 = SKIPPTRN_HAS_NUM;
                        object4 = this.extractFirst((String)object, (String)object5);
                        if (!((String)object4).isEmpty()) {
                            object3 = ((String)object4).split("\\d+");
                            string3 = ((String)object4).substring(object3[0].length());
                            object2 = string3.trim();
                            linkedHashMap.put(SKIP, (String)object2);
                        }
                    } else {
                        object5 = "(?i:\\bs(?:|k|ki|kip)\\b)\\s*(-?\\d)*";
                        object4 = this.extractFirst((String)object, (String)object5);
                        if (!((String)object4).isEmpty()) {
                            object3 = ((String)object4).split("\\s+");
                            if (((String[])object3).length == 2) {
                                string3 = object3[1];
                                linkedHashMap.put(SKIP, string3);
                            } else {
                                linkedHashMap.put(SKIP, "0");
                            }
                        }
                    }
                    this.applyPrintSpec(stringBuffer, linkedHashMap, "");
                    linkedHashMap.clear();
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    if (((String)object4).isEmpty()) {
                        object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                        continue;
                    }
                    object = ((String)object).substring(((String)object4).length(), ((String)object).length()).trim();
                    continue;
                }
                if (string4.matches(COLPTRN)) {
                    object5 = "(?i:\\bcol\\b)\\s+\\d+";
                    object4 = this.extractFirst((String)object, (String)object5);
                    if (!((String)object4).isEmpty() && ((String[])(object3 = ((String)object4).split("\\s+"))).length == 2) {
                        string3 = object3[1];
                        linkedHashMap.put(COL, string3);
                    }
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    if (((String)object4).isEmpty()) {
                        object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                        continue;
                    }
                    object = ((String)object).substring(((String)object4).length(), ((String)object).length()).trim();
                    continue;
                }
                if (string4.matches(FORMATPTRN)) {
                    object5 = "(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)";
                    object4 = "(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+.+\\s+(?i:sql.pno)";
                    object3 = ".+\\s+(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)";
                    string3 = "";
                    object2 = null;
                    stringArray = "";
                    string2 = "";
                    if (((String)object).matches((String)object5)) {
                        string3 = this.extractFirst((String)object, (String)object5);
                        if (!string3.isEmpty()) {
                            object2 = string3.split("\\s+");
                            stringArray = object2[1];
                            string2 = this.getFormattedStr(n.toString(), (String)stringArray);
                        }
                    } else if (((String)object).matches((String)object4)) {
                        string3 = this.extractFirst((String)object, (String)object4);
                        if (!string3.isEmpty()) {
                            string2 = ((String)object).replaceAll("(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+", "").trim();
                            string2 = string2.replaceAll("\\s+(?i:sql.pno)", "").trim();
                            string2 = string2.replaceAll("['\"]", "").trim();
                            object2 = string3.split("\\s+");
                            stringArray = object2[1];
                            string2 = string2 + this.getFormattedStr(n.toString(), (String)stringArray);
                        }
                    } else if (((String)object).matches((String)object3) && !(string3 = this.extractFirst((String)object, (String)object3)).isEmpty()) {
                        string2 = ((String)object).replaceAll("\\s+(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)", "").trim();
                        string2 = string2.replaceAll("['\"]", "").trim();
                        object2 = string3.split("\\s+");
                        stringArray = object2[2];
                        string2 = string2 + this.getFormattedStr(n.toString(), (String)stringArray);
                    }
                    if (linkedHashMap.size() == 0) {
                        linkedHashMap.put(JUSTIFY, string2);
                    }
                    this.applyPrintSpec(stringBuffer, linkedHashMap, string2);
                    linkedHashMap.clear();
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    if (string3.isEmpty()) {
                        object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                        continue;
                    }
                    object = ((String)object).substring(string3.length(), ((String)object).length()).trim();
                    continue;
                }
                if (string4.equalsIgnoreCase(SQLPNO)) {
                    this.applyPrintSpec(stringBuffer, linkedHashMap, n.toString());
                    linkedHashMap.clear();
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                    continue;
                }
                if (string4.equalsIgnoreCase(SQLSCAN)) {
                    this.applyPrintSpec(stringBuffer, linkedHashMap, this.m_scan);
                    linkedHashMap.clear();
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                    continue;
                }
                if (string4.matches(FONTPTRN)) {
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                    continue;
                }
                if (string4.matches(TABPTRN)) {
                    object5 = "(?i:\\btab\\b)\\s+\\d+";
                    object4 = this.extractFirst((String)object, (String)object5);
                    if (!((String)object4).isEmpty() && ((String[])(object3 = ((String)object4).split("\\s+"))).length == 2) {
                        string3 = object3[1];
                        linkedHashMap.put(TAB, string3);
                    }
                    if (string4.equals(object)) {
                        object = "";
                        continue;
                    }
                    if (((String)object4).isEmpty()) {
                        object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                        continue;
                    }
                    object = ((String)object).substring(((String)object4).length(), ((String)object).length()).trim();
                    continue;
                }
                object5 = "";
                if (string4.equalsIgnoreCase("_date")) {
                    object5 = scriptRunnerContext.getDate(string4);
                } else if (string4.startsWith("'") && string4.endsWith("'") || string4.startsWith("\"") && string4.endsWith("\"")) {
                    if (string4.contains("\"\"")) {
                        object4 = this.appendLookahead((String)object);
                        object5 = object4[0];
                        object5 = ((String)object5).replaceAll("\"\"", "\"");
                        object = object4[1];
                        string4 = "";
                    } else if (string4.contains("''")) {
                        object4 = this.appendLookahead((String)object);
                        object5 = object4[0];
                        object5 = ((String)object5).replaceAll("''", "'");
                        object = object4[1];
                        string4 = "";
                    } else {
                        object4 = this.appendLookahead((String)object);
                        object5 = object4[0];
                        if (((String)(object5 = ((String)object5).replaceAll("'", ""))).contains("\"")) {
                            object5 = ((String)object5).replaceAll("\"", "");
                        }
                        object = object4[1];
                        string4 = "";
                    }
                } else {
                    object4 = scriptRunnerContext.getMap();
                    object5 = (String)object4.get(string4);
                    if (object5 == null || ((String)object5).isEmpty()) {
                        object3 = this.appendLookahead((String)object);
                        object5 = object3[0];
                        object = object3[1];
                        string4 = "";
                    }
                }
                object4 = this.splitStr((String)object);
                if (object4 != null && ((String[])object4).length > 0) {
                    object3 = object4[0];
                    if (((String)object3).equalsIgnoreCase(SQLPNO)) {
                        string3 = string4 + "\\s+" + CURRPAGENO;
                        object5 = (String)object5 + "          " + n.toString();
                        if (((String)object3).equals(object) || ((String)object).matches(string3)) {
                            object = "";
                        } else {
                            string4 = "";
                            object = ((String)object).substring(((String)object3).length(), ((String)object).length()).trim();
                        }
                    }
                    if (((String)object3).equalsIgnoreCase(SQLSCAN)) {
                        string3 = string4 + "\\s+" + "(?i:sql.scan)";
                        object5 = (String)object5 + "  " + this.m_scan;
                        if (((String)object3).equals(object) || ((String)object).matches(string3)) {
                            object = "";
                        } else {
                            string4 = "";
                            object = ((String)object).substring(((String)object3).length(), ((String)object).length()).trim();
                        }
                    } else if (((String)object3).equalsIgnoreCase(FORMAT) && !((String)(object2 = this.extractFirst((String)object, string3 = "(?i:\\bformat\\b)\\s+[\\w.,$]+\\s+(?i:sql.pno)"))).isEmpty() && (stringArray = ((String)object2).split("\\s+")).length == 3) {
                        string2 = stringArray[1];
                        String string5 = n.toString();
                        String string6 = this.getFormattedStr(string5, string2);
                        object5 = (String)object5 + string6;
                        object = ((String)object2).equals(object) ? "" : (((String)object2).isEmpty() ? ((String)object).substring(((String)object3).length(), ((String)object).length()).trim() : ((String)object).substring(((String)object2).length(), ((String)object).length()).trim());
                    }
                } else if (linkedHashMap.size() == 0) {
                    linkedHashMap.put(JUSTIFY, (String)object5);
                }
                if (string4.equals(object)) {
                    object = "";
                } else if (((String)object).length() > 0) {
                    object = ((String)object).substring(string4.length(), ((String)object).length()).trim();
                }
                if (linkedHashMap.isEmpty() && ((String)object5).length() > 0) {
                    stringBuffer.append((String)object5);
                    continue;
                }
                this.applyPrintSpec(stringBuffer, linkedHashMap, (String)object5);
                linkedHashMap.clear();
            }
        }
        if (!stringBuffer.toString().endsWith(m_lineSeparator)) {
            stringBuffer.append(m_lineSeparator);
        }
        return stringBuffer;
    }

    private String[] appendLookahead(String string) {
        String string2 = string;
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = null;
        for (String string3 : stringArray2 = this.splitStr(string)) {
            if (this.testKeyword(string3)) break;
            if (string3.startsWith("'") && string3.endsWith("'")) {
                stringBuffer.append(string3.subSequence(1, string3.length() - 1));
            } else if (string3.startsWith("'") && !string3.endsWith("'")) {
                stringBuffer.append(string3.subSequence(1, string3.length()));
            } else if (!string3.startsWith("'") && string3.endsWith("'")) {
                stringBuffer.append(string3.subSequence(0, string3.length() - 1));
            } else if (string3.startsWith("\"") && string3.endsWith("\"")) {
                stringBuffer.append(string3.subSequence(1, string3.length() - 1));
            } else if (string3.startsWith("\"") && !string3.endsWith("\"")) {
                stringBuffer.append(string3.subSequence(1, string3.length()));
            } else if (!string3.startsWith("\"") && string3.endsWith("\"")) {
                stringBuffer.append(string3.subSequence(0, string3.length() - 1));
            } else {
                stringBuffer.append(string3);
            }
            string2 = string2.substring(string3.length(), string2.length()).trim();
        }
        stringArray[0] = stringBuffer.toString();
        stringArray[1] = string2;
        return stringArray;
    }

    private void applyPrintSpec(StringBuffer stringBuffer, LinkedHashMap<String, String> linkedHashMap, String string) {
        int n = stringBuffer.toString().split(m_lineSeparator).length;
        if (linkedHashMap != null) {
            for (Map.Entry<String, String> entry : linkedHashMap.entrySet()) {
                int n2;
                int n3;
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                String string4 = this.applyHeadSep(string.trim());
                if (string2.equals(JUSTIFY)) {
                    int n4;
                    int n5;
                    int n6;
                    String string5;
                    String string6 = "";
                    string6 = string3.matches(LEFTPTRN) ? this.justify_left(string4, this.m_linesize - m_lineSeparator.length()) : (string3.matches(CENTERPTRN) ? this.justify_center(string4, this.m_linesize - m_lineSeparator.length()) : (string3.matches(RIGHTPTRN) ? this.justify_right(string4, this.m_linesize - m_lineSeparator.length()) : this.justify_left(string4, this.m_linesize)));
                    int n7 = string6.indexOf(string4);
                    if (n7 < 0 || n <= 0) continue;
                    n3 = n7;
                    n2 = n3 + string4.length();
                    if (n > 1) {
                        if (string4.contains(m_lineSeparator)) {
                            String[] stringArray = string4.split(m_lineSeparator);
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (i > 0) {
                                    stringBuffer.append(this.addLine());
                                }
                                string5 = stringArray[i].trim();
                                n6 = stringBuffer.capacity();
                                n5 = (n + i - 1) * this.m_linesize;
                                n4 = n5 + n3;
                                int n8 = n4 + string5.length();
                                stringBuffer.replace(n4, n8, stringArray[i].trim());
                            }
                            continue;
                        }
                        int n9 = n3 + (n - 1) * this.m_linesize;
                        int n10 = n2 + (n - 1) * this.m_linesize;
                        stringBuffer.replace(n9, n10, string4);
                        continue;
                    }
                    if (string4.contains(m_lineSeparator)) {
                        String[] stringArray = string4.split(m_lineSeparator);
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(this.addLine());
                            }
                            string5 = stringArray[i].trim();
                            n6 = i * this.m_linesize;
                            n5 = n6 + n3;
                            n4 = n5 + string5.length();
                            stringBuffer.replace(n5, n4, stringArray[i].trim());
                        }
                        continue;
                    }
                    stringBuffer.replace(n3, n2, string4);
                    continue;
                }
                if (string2.equals(COL) || string2.equals(TAB)) {
                    int n11 = new Integer(string3);
                    int n12 = this.m_linesize * (n - 1);
                    n3 = n12 + this.m_linesize - (m_lineSeparator.length() + 1);
                    n2 = stringBuffer.indexOf(string4);
                    if (n2 > -1 && n2 >= n12 && n2 <= n3 && string4 != null && !string4.equals("")) {
                        String string7 = String.format("%1$-" + string4.length() + "s", "");
                        stringBuffer.replace(n2, n2 + string4.length(), string7);
                    } else if (string2.equals(TAB)) {
                        stringBuffer.replace(n12 + n11, n12 + n11 + string4.length(), string4);
                    } else {
                        stringBuffer.replace(n12 + (n11 - 1), n12 + (n11 - 1) + string4.length(), string4);
                    }
                    if (n11 < n12 || n11 > n3) continue;
                    if (n11 + string4.length() <= n3) {
                        if (string2.equals(TAB)) {
                            stringBuffer.replace(n11, n11 + string4.length(), string4);
                            continue;
                        }
                        stringBuffer.replace(n11 - 1, n11 - 1 + string4.length(), string4);
                        continue;
                    }
                    int n13 = n3 - n11;
                    String string8 = string4.substring(0, n13);
                    stringBuffer.replace(n11 - 1, n11 - 1 + string8.length(), string8);
                    continue;
                }
                if (!string2.equals(SKIP)) continue;
                int n14 = new Integer(string3);
                if (n14 < 0) {
                    stringBuffer.append(this.addLine());
                    String string9 = Integer.toString(n14);
                    stringBuffer.replace(0, string9.length(), string9);
                    continue;
                }
                if (n14 == 0 || n14 == 1) {
                    stringBuffer.append(this.addLine());
                    continue;
                }
                for (int i = 0; i < n14; ++i) {
                    stringBuffer.append(this.addLine());
                }
            }
        }
    }

    protected String extractFirst(String string, String string2) {
        Matcher matcher;
        String string3 = "";
        Pattern pattern = Pattern.compile(string2);
        if (pattern != null && (matcher = pattern.matcher(string)) != null && matcher.find()) {
            string3 = matcher.group();
        }
        return string3;
    }

    private String[] splitStr(String string) {
        String string2 = null;
        String[] stringArray = null;
        String string3 = "(\\\\|/|\\{|\\}|\\[|\\]|<|>|,|\\+|\\^|\\)|\\(|@|&|\\$|!|%|\\?|#|;|:|\\*|\\.|=|-|_|\\w|-?\\d|\\s|\\" + this.m_headsepchar + ")+";
        String string4 = "(['\"])(" + string3 + ")(['\"]['\"]" + string3 + ")+['\"]|([^\\s]+)";
        String string5 = "(['\"]" + string3 + "['\"])|([^\\s]+)";
        string2 = string.contains("''") || string.contains("\"\"") ? string4 : string5;
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(string2);
        if (pattern != null) {
            Matcher matcher = pattern.matcher(string);
            if (matcher != null) {
                while (matcher.find()) {
                    arrayList.add(matcher.group());
                }
            }
            if (arrayList.size() > 0) {
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
        }
        return stringArray;
    }

    private int countSingleQuotes(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\'') continue;
            n = n++;
        }
        return n;
    }

    private boolean testKeyword(String string) {
        String string2 = string.trim();
        return string2.equalsIgnoreCase("LEFT") || string2.equalsIgnoreCase("LE") || string2.equalsIgnoreCase("RIGHT") || string2.equalsIgnoreCase("R") || string2.equalsIgnoreCase("CENTER") || string2.equalsIgnoreCase("CE") || string2.equalsIgnoreCase("SKIP") || string2.equalsIgnoreCase("S") || this.validateSkip(string2) || string2.equalsIgnoreCase("TAB") || string2.equalsIgnoreCase("COL") || string2.equalsIgnoreCase("FORMAT") || string2.equalsIgnoreCase("BOLD") || string2.equalsIgnoreCase(SQLPNO) || string2.equalsIgnoreCase(SQLSCAN) || string2.equalsIgnoreCase(SCAN_ON) || string2.equalsIgnoreCase(SCAN_OFF);
    }

    private boolean validateSkip(String string) {
        return (string.startsWith(SKIP) || string.startsWith("SKIP")) && this.isInteger(string = string.substring(4, string.length()).trim());
    }

    private boolean isInteger(String string) {
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!(i == 0 && string.charAt(i) == '-' ? string.length() == 1 : Character.digit(string.charAt(i), 10) < 0)) continue;
            return false;
        }
        return true;
    }

    private String applyHeadSep(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.m_headsepchar);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            string2 = string3.length() > this.m_linesize ? string2 + string3.substring(0, this.m_linesize) : string2 + string3;
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + m_lineSeparator;
        }
        if (string2.length() == 0) {
            string2 = string;
        } else {
            if (string2.startsWith("'") || string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("'") || string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    private void skip(StringBuffer stringBuffer, String string, String string2) {
        String string3 = this.getMatch(string);
        if (string3 != null && !string3.isEmpty()) {
            string3 = string3.trim().replaceAll(string2, "").trim();
            string3 = string3.replaceAll("['\"]", "");
            boolean bl = false;
            boolean bl2 = bl = string3.equals("") ? false : Pattern.matches("^\\d*$", string3);
            if (bl) {
                int n = new Integer(string3);
                if (n <= 1) {
                    stringBuffer.append(this.addLine());
                } else {
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(this.addLine());
                    }
                }
            } else {
                stringBuffer.append(this.addLine());
            }
        }
    }

    private void justify(StringBuffer stringBuffer, String string, String string2, Integer n) {
        String string3 = "";
        String string4 = this.getMatch(string);
        if (string4 != null && !string4.isEmpty()) {
            string4 = string4.trim().replaceAll(string2, "").trim();
            int n2 = (string4 = string4.replaceAll("['\"]", "")).toUpperCase().indexOf(SQLPNO);
            if (n2 > 0) {
                string4 = string4.replaceAll(CURRPAGENO, "     " + n.toString());
            }
            string3 = string.equals(LEFTCMDPTRN) ? this.justify_left(string4, this.m_linesize - m_lineSeparator.length()) : (string.equals(RIGHTCMDPTRN) ? this.justify_right(string4, this.m_linesize - m_lineSeparator.length()) : (string.equals(CENTERCMDPTRN) ? this.justify_center(string4, this.m_linesize - m_lineSeparator.length()) : this.justify_left(string4, this.m_linesize)));
            int n3 = string3.indexOf(string4);
            int n4 = stringBuffer.toString().split(m_lineSeparator).length;
            if (n3 >= 0 && n4 > 0) {
                int n5 = n3 + this.m_linesize * (n4 - 1);
                int n6 = n5 + string4.length();
                stringBuffer.replace(n5, n6, string4);
            }
        }
    }

    private void col(StringBuffer stringBuffer, String string, String string2, Integer n) {
        int n2 = stringBuffer.toString().split(m_lineSeparator).length;
        int n3 = this.m_linesize * (n2 - 1);
        int n4 = n3 + this.m_linesize - (m_lineSeparator.length() + 1);
        String string3 = this.getMatch(string);
        if (string3 != null && !string3.isEmpty()) {
            String[] stringArray = string3.split("(?:\\s+|['\"].+['\"])");
            if (stringArray.length >= 3) {
                String string4;
                boolean bl = false;
                int n5 = 0;
                String string5 = "";
                String string6 = "";
                String string7 = "";
                for (int i = 1; i < stringArray.length; ++i) {
                    bl = stringArray[i].matches("^\\d+$");
                    if (bl) {
                        n5 = new Integer(stringArray[i]) - 1;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase(FORMAT)) {
                        string6 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("sql.pno")) {
                        string4 = this.getFormattedStr(n.toString(), string6);
                        string7 = "     ";
                        string5 = string5 + string7 + string4;
                        continue;
                    }
                    string5 = string5 + stringArray[i];
                }
                Matcher matcher = Pattern.compile("['\"].+['\"]").matcher(string3);
                if (matcher.find()) {
                    string4 = matcher.group();
                    string5 = string4 + string5;
                }
                string5 = string5.replaceAll("['\"]", "");
                string5 = this.getFormattedStr(string5, string6);
                string5 = string7 + string5;
                if (n5 >= n3 && n5 <= n4) {
                    if (n5 + string5.length() <= n4) {
                        stringBuffer.replace(n5, n5 + string5.length(), string5);
                    } else {
                        int n6 = n4 - n5;
                        String string8 = string5.substring(0, n6);
                        stringBuffer.replace(n5, n5 + string8.length(), string8);
                    }
                }
            }
        } else {
            return;
        }
    }

    private String getMatch(String string) {
        String string2 = "";
        Pattern pattern = Pattern.compile(string);
        if (pattern != null) {
            Matcher matcher = pattern.matcher(this.m_titleCmd);
            while (matcher.find()) {
                string2 = matcher.group();
                if (this.m_parsedList.size() == 0) {
                    this.m_parsedList.add(string2);
                    break;
                }
                if (this.m_parsedList.contains(string2)) continue;
                this.m_parsedList.add(string2);
                break;
            }
        }
        return string2;
    }

    private String addLine() {
        String string = "";
        string = this.justify_left(" ", this.m_linesize - m_lineSeparator.length());
        string = string + m_lineSeparator;
        return string;
    }

    private String justify_left(String string, int n) {
        return String.format("%1$-" + n + "s", string);
    }

    private String justify_right(String string, int n) {
        return String.format("%1$" + n + "s", string);
    }

    private String justify_center(String string, int n) {
        String string2 = string.trim();
        if (n < string2.length()) {
            return string;
        }
        int n2 = (n - string2.length()) / 2 + string2.length();
        String string3 = String.format("%1$" + n2 + "s", string2);
        String string4 = String.format("%1$-" + n + "s", string3);
        return string4;
    }

    private String getFormattedStr(String string, String string2) {
        String string3 = string;
        if (string2.startsWith("a") || string2.startsWith("A")) {
            String string4 = string2.replaceAll("^\\D*", "").trim();
            string3 = this.justify_left(string3, new Integer(string4));
        } else {
            NUMBER nUMBER = new NUMBER(new Integer(string3).intValue());
            try {
                string3 = nUMBER.toFormattedText(string2, null);
            }
            catch (Exception exception) {
                string3 = nUMBER.stringValue();
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFormattedNumber(Connection connection, NUMBER nUMBER, String string) {
        String string2 = "";
        ResultSet resultSet = null;
        String string3 = "SELECT TO_CHAR(";
        string3 = string3 + nUMBER.stringValue() + ",";
        string3 = string3 + "'" + string + "'" + ") from dual";
        if (connection == null || string3.equals("")) return string2;
        try {
            DBUtil dBUtil = DBUtil.getInstance(connection);
            resultSet = dBUtil.executeOracleQuery(string3, null);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            if (resultSet == null) return string2;
        }
        catch (Exception exception) {
            try {
                string2 = DataTypesUtil.stringValue(nUMBER, connection);
                if (resultSet == null) return string2;
            }
            catch (Throwable throwable) {
                if (resultSet == null) throw throwable;
                DBUtil.closeResultSet(resultSet);
                throw throwable;
            }
            DBUtil.closeResultSet(resultSet);
            return string2;
        }
        DBUtil.closeResultSet(resultSet);
        return string2;
    }

    public String getCommand() {
        return this.m_titleCmd;
    }

    public String buildShowTitle(Title title, ScriptRunnerContext scriptRunnerContext) {
        String string = "";
        String string2 = "";
        boolean bl = false;
        if (title instanceof TopTitle) {
            string = "ttitle";
            bl = scriptRunnerContext.getTTitleFlag();
            string2 = scriptRunnerContext.getTTitleCmd();
        } else if (title instanceof BottomTitle) {
            string = "btitle";
            bl = scriptRunnerContext.getBTitleFlag();
            string2 = scriptRunnerContext.getBTitleCmd();
        } else {
            return string;
        }
        if (bl) {
            if (string2.equals("")) {
                string = string + " " + Messages.getString("Title.1") + m_lineSeparator;
            } else {
                string = string + " " + MessageFormat.format(Messages.getString("Title.2"), string2.length()) + m_lineSeparator;
                string = string + string2 + m_lineSeparator;
            }
        } else if (string2.equals("")) {
            string = string + " " + Messages.getString("Title.3") + m_lineSeparator;
        } else {
            string = string + " " + MessageFormat.format(Messages.getString("Title.4"), string2.length()) + m_lineSeparator;
            string = string + string2 + m_lineSeparator;
        }
        return string;
    }
}

