/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.jdbc.OracleConnection;

public class SetStatementCache
extends CommandListener {
    private static String CMD = "setstatementcache";

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext != null && scriptRunnerContext.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return false;
        }
        if (iSQLCommand.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith(CMD) && connection instanceof OracleConnection) {
            block8: {
                String[] stringArray = iSQLCommand.getSql().toLowerCase().trim().split(" ");
                try {
                    if (stringArray[2].equals("on")) {
                        ((OracleConnection)connection).setImplicitCachingEnabled(true);
                        ((OracleConnection)connection).setStatementCacheSize(100);
                        scriptRunnerContext.write("Statement Caching set to 100");
                        break block8;
                    }
                    if (stringArray[2].equals("off")) {
                        ((OracleConnection)connection).setImplicitCachingEnabled(true);
                        scriptRunnerContext.write("Statement Caching disabled");
                        break block8;
                    }
                    Integer n = 100;
                    try {
                        Integer.parseInt(stringArray[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ((OracleConnection)connection).setImplicitCachingEnabled(true);
                    ((OracleConnection)connection).setStatementCacheSize(n.intValue());
                    scriptRunnerContext.write("Statement Caching set to " + n);
                }
                catch (SQLException sQLException) {
                    scriptRunnerContext.write("Failed to enable Statement Caching" + sQLException.getLocalizedMessage());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

