/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.WrapBufferOutputStreamToWriter;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetSpool
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SPOOL;
    public static String fileExists = "FILE_EXISTS";

    public SetSpool() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected void doBeginWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream;
        if (!scriptRunnerContext.isEchoOn() && scriptRunnerContext.getTopLevel()) {
            SetSpool.writeToExisting(scriptRunnerContext.getPrompt() + iSQLCommand.getSQLOrig(), scriptRunnerContext);
            if (iSQLCommand.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) {
                SetSpool.writeToExisting(";", scriptRunnerContext);
            } else if (iSQLCommand.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL)) {
                SetSpool.writeToExisting("\n/", scriptRunnerContext);
            }
            SetSpool.writeToExisting("\n", scriptRunnerContext);
        }
        if (iSQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && (wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer")) != null) {
            this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.filedisplay"), wrapListenBufferOutputStream.getFileOutput().getAbsolutePath()), scriptRunnerContext);
            SetSpool.writeToExisting("\n\n", scriptRunnerContext);
        }
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (!scriptRunnerContext.isEchoOn() && scriptRunnerContext.getTopLevel()) {
            SetSpool.writeToExisting(scriptRunnerContext.getPrompt() + iSQLCommand.getSQLOrig(), scriptRunnerContext);
            SetSpool.writeToExisting("\n", scriptRunnerContext);
        }
        if ((Boolean)iSQLCommand.getProperty("prop_status_boolean") != null && ((Boolean)iSQLCommand.getProperty("prop_status_boolean")).booleanValue()) {
            if (iSQLCommand.getProperty("prop_file_string") != null) {
                String string = this.expandVariables(iSQLCommand.getSql().trim().replaceAll("^.*?[sS][pP][oO][^\\s]*\\s+", "").trim());
                String[] stringArray = null;
                boolean bl = true;
                try {
                    String string2;
                    boolean bl2 = false;
                    String[] stringArray2 = string.split("\\s+");
                    if (stringArray2 != null && stringArray2.length > 0 && ((string2 = stringArray2[0]).equalsIgnoreCase("CRE") || string2.equalsIgnoreCase("CREA") || string2.equalsIgnoreCase("CREAT") || string2.equalsIgnoreCase("CREATE") || string2.equalsIgnoreCase("REP") || string2.equalsIgnoreCase("REPL") || string2.equalsIgnoreCase("REPLA") || string2.equalsIgnoreCase("REPLACE") || string2.equalsIgnoreCase("APP") || string2.equalsIgnoreCase("APPE") || string2.equalsIgnoreCase("APPEN") || string2.equalsIgnoreCase("APPEND"))) {
                        bl2 = true;
                        this.writeToMain(Messages.getString("SetSpool.filenamebad") + "\n", scriptRunnerContext);
                        this.usage(scriptRunnerContext, false, true);
                        return true;
                    }
                    stringArray = ScriptUtils.executeArgs(string);
                    if (stringArray != null) {
                        string2 = stringArray[0];
                        bl = false;
                        if (!(stringArray.length <= 2 && (stringArray.length <= 1 || stringArray[1].equalsIgnoreCase("CRE") || stringArray[1].equalsIgnoreCase("CREA") || stringArray[1].equalsIgnoreCase("CREAT") || stringArray[1].equalsIgnoreCase("CREATE") || stringArray[1].equalsIgnoreCase("REP") || stringArray[1].equalsIgnoreCase("REPL") || stringArray[1].equalsIgnoreCase("REPLA") || stringArray[1].equalsIgnoreCase("REPLACE") || stringArray[1].equalsIgnoreCase("APP") || stringArray[1].equalsIgnoreCase("APPE") || stringArray[1].equalsIgnoreCase("APPEN") || stringArray[1].equalsIgnoreCase("APPEND")))) {
                            this.usage(scriptRunnerContext, true, false);
                        } else {
                            String string3 = "R";
                            if (stringArray.length > 1) {
                                if (stringArray[1].equalsIgnoreCase("CRE") || stringArray[1].equalsIgnoreCase("CREA") || stringArray[1].equalsIgnoreCase("CREAT") || stringArray[1].equalsIgnoreCase("CREATE")) {
                                    string3 = "C";
                                } else if (stringArray[1].equalsIgnoreCase("APP") || stringArray[1].equalsIgnoreCase("APPE") || stringArray[1].equalsIgnoreCase("APPEN") || stringArray[1].equalsIgnoreCase("APPEND")) {
                                    string3 = "A";
                                }
                            }
                            if (string2.equalsIgnoreCase("out")) {
                                this.stopSpool(scriptRunnerContext);
                                this.writeToMain(Messages.getString("SetSpool.printingnotsupported") + "\n", scriptRunnerContext);
                            } else {
                                this.initFile(string2, scriptRunnerContext, iSQLCommand, string3);
                            }
                        }
                    }
                }
                catch (ArgumentQuoteException argumentQuoteException) {
                    String string4 = "'";
                    if (string.length() > 1 && string.substring(0, 1).equals("\"")) {
                        string4 = "\"";
                    }
                    this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.missingquote"), string, string4) + "\n", scriptRunnerContext);
                    this.writeToMain(Messages.getString("SetSpool.cannotcreate") + "\n", scriptRunnerContext);
                    bl = false;
                }
                if (bl) {
                    this.writeToMain(Messages.getString("SetSpool.invalidfilename") + "\n", scriptRunnerContext);
                }
            } else if (iSQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && iSQLCommand.getSql().trim().toLowerCase().equals("spool")) {
                this.spoolKeyword(scriptRunnerContext);
            } else {
                this.initFile("spool", scriptRunnerContext, iSQLCommand, "R");
            }
        } else if (iSQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && iSQLCommand.getSql().trim().toLowerCase().equals("spool")) {
            this.spoolKeyword(scriptRunnerContext);
        } else if (iSQLCommand.getSql().trim().split(" ").length > 2) {
            this.usage(scriptRunnerContext, true, false);
        } else if (iSQLCommand.getSql().trim().split(" ").length == 2) {
            this.stopSpool(scriptRunnerContext);
        }
        return true;
    }

    private void usage(ScriptRunnerContext scriptRunnerContext, boolean bl, boolean bl2) {
        if (bl) {
            scriptRunnerContext.write("SP2-0768: Illegal SPOOL command\nUsage: SPO[OL] { <file> | OFF | OUT }\nwhere <file> is file_name[.ext] [CRE[ATE]|REP[LACE]|APP[END]]\n");
        } else if (bl2) {
            scriptRunnerContext.write("SP2-0769: Usage: SPO[OL] { <file> | OFF | OUT }\nwhere <file> is file_name[.ext] [CRE[ATE]|REP[LACE]|APP[END]]\n");
        }
    }

    private void spoolKeyword(ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream != null) {
            this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.filedisplay"), wrapListenBufferOutputStream.getFileOutput().getAbsolutePath()), scriptRunnerContext);
        } else {
            this.writeToMain(Messages.getString("SetSpool.2"), scriptRunnerContext);
        }
        this.writeToMain("\n\n", scriptRunnerContext);
    }

    public void writeToMain(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.write(string.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public static void writeToExisting(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.write(string.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger("SetSpool").log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger("SetSpool").log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public String expandVariables(String string) {
        String[] stringArray;
        if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
            String[] stringArray2;
            if (string.indexOf("%") == -1) {
                return string;
            }
            for (String string2 : stringArray2 = System.getenv().keySet().toArray(new String[System.getenv().keySet().size()])) {
                string = string.replaceAll("(?i)" + Pattern.quote("%" + string2 + "%"), Matcher.quoteReplacement(System.getenv(string2)));
            }
            return string;
        }
        if (string.indexOf("$") == -1) {
            return string;
        }
        for (String string3 : stringArray = System.getenv().keySet().toArray(new String[System.getenv().keySet().size()])) {
            string = string.replaceAll("\\$\\{" + Pattern.quote(string3) + "\\}", Matcher.quoteReplacement(System.getenv(string3)));
            string = string.replaceAll("\\$" + Pattern.quote(string3) + "$", Matcher.quoteReplacement(System.getenv(string3)));
            string = string.replaceAll("\\$" + Pattern.quote(string3) + "([^\\p{Alnum}_])", Matcher.quoteReplacement(System.getenv(string3)) + "$1");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFile(String string, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand, String string2) {
        boolean bl = false;
        String string3 = "";
        string = scriptRunnerContext.prependCD(string);
        boolean bl2 = false;
        try {
            if (string.startsWith("/") || string.startsWith("\\") || string.length() > 2 && string.charAt(1) == ':') {
                string3 = string;
            } else {
                String string4;
                URL uRL = (URL)scriptRunnerContext.getProperty("script.runner.node.url");
                if (uRL != null && uRL.getProtocol().equalsIgnoreCase("file")) {
                    string4 = null;
                    try {
                        File file;
                        String string5 = null;
                        try {
                            file = new File(uRL.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            file = new File(uRL.getPath());
                        }
                        if (!file.getParent().equals(System.getProperty("java.io.tmpdir"))) {
                            string5 = file.getParent() + File.separator + string;
                            if (!this.doesParentExist(string5 = string5.replace('/', '\\'))) {
                                string5 = string5.replace('\\', '/');
                            }
                            if (this.addDotLst(string5)) {
                                string5 = System.getProperty("os.name").startsWith("Windows") ? string5 + ".LST" : string5 + ".lst";
                            }
                            if (string2.equals("C") && new File(string5).exists()) {
                                string3 = string5;
                                bl2 = true;
                                throw new IOException(fileExists);
                            }
                            new File(string5).createNewFile();
                            File file2 = new File(string5);
                            if (!file2.canWrite()) {
                                throw new IOException();
                            }
                            string3 = string5;
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (string4 != null) {
                            try {
                                ((FileOutputStream)((Object)string4)).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!bl) {
                    if (bl2) {
                        throw new IOException(fileExists);
                    }
                    string4 = scriptRunnerContext.getSettingsDir();
                    string3 = string4 + File.separator + string;
                }
            }
            string3 = string3.replace('/', '\\');
            if (!this.doesParentExist(string3)) {
                string3 = string3.replace('\\', '/');
            }
            if (this.addDotLst(string3)) {
                string3 = System.getProperty("os.name").startsWith("Windows") ? string3 + ".LST" : string3 + ".lst";
            }
            this.createNewSpoolOut(string3, scriptRunnerContext, bl, string2);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().equals(fileExists)) {
                this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.fileExists") + "\n", string3), scriptRunnerContext);
            } else {
                this.writeToMain(Messages.getString("SetSpool.invalidfilename") + "\n", scriptRunnerContext);
            }
            ScriptUtils.doWhenever(scriptRunnerContext, iSQLCommand, scriptRunnerContext.getCurrentConnection(), false);
        }
    }

    public void stopSpool(ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.flush();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            scriptRunnerContext.getOutputStream().removeFromList(wrapListenBufferOutputStream);
            try {
                wrapListenBufferOutputStream.flush();
                wrapListenBufferOutputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            scriptRunnerContext.putProperty("Spool.out.buffer", null);
        } else {
            scriptRunnerContext.write("not spooling currently\n");
        }
    }

    private void createNewSpoolOut(String string, ScriptRunnerContext scriptRunnerContext, boolean bl, String string2) throws IOException {
        if (!bl && string2.equals("C") && new File(string).exists()) {
            throw new IOException(fileExists);
        }
        boolean bl2 = false;
        if (string2.equals("A")) {
            bl2 = true;
        }
        new File(string).createNewFile();
        String string3 = scriptRunnerContext.getEncoding();
        WrapListenBufferOutputStream wrapListenBufferOutputStream = null;
        WrapBufferOutputStreamToWriter wrapBufferOutputStreamToWriter = new WrapBufferOutputStreamToWriter(null);
        wrapBufferOutputStreamToWriter.setTerminator(scriptRunnerContext.getStringTerminator());
        wrapBufferOutputStreamToWriter.setOut(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, bl2), string3)));
        wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)new BufferedOutputStream(wrapBufferOutputStreamToWriter), scriptRunnerContext);
        wrapListenBufferOutputStream.setFileOutput(new File(string));
        wrapListenBufferOutputStream.setRemoveForcePrint(true);
        WrapListenBufferOutputStream wrapListenBufferOutputStream2 = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream2 != null) {
            this.stopSpool(scriptRunnerContext);
            scriptRunnerContext.putProperty("Spool.out.buffer", null);
        }
        scriptRunnerContext.putProperty("Spool.out.buffer", wrapListenBufferOutputStream);
        scriptRunnerContext.getOutputStream().addToList(wrapListenBufferOutputStream);
    }

    private boolean doesParentExist(String string) {
        int n;
        int n2;
        int n3 = string.lastIndexOf("/");
        if (n3 > (n2 = (n = string.lastIndexOf("\\")))) {
            n2 = n3;
        }
        if (n2 == -1) {
            return false;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            ++n2;
        }
        return new File(string.substring(0, n2)).exists();
    }

    private boolean addDotLst(String string) {
        if (string.equals("/dev/null") || string.equals("\\dev\\null") || string.equals("/dev/stderr") || string.equals("\\dev\\stderr") || string.equals("/dev/stdout") || string.equals("\\dev\\stdout") || string.equals("/dev/error") || string.equals("\\dev\\error")) {
            return false;
        }
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("\\");
        int n3 = string.lastIndexOf(".");
        int n4 = n2;
        if (n > n4) {
            n4 = n;
        }
        return n3 <= n4;
    }

    @Override
    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext) {
        super.endScript(connection, scriptRunnerContext);
        if (scriptRunnerContext.getTopLevel()) {
            this.stopSpool(scriptRunnerContext);
            this.setCmdOn(false);
        }
    }
}

