/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.utils.NLSUtils;

public class SetNull
extends AForAllStmtsCommand
implements IShowCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NULL;

    public SetNull() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getProperty("prop_file_string") != null) {
            String string = iSQLCommand.getSql();
            if ((string = string.trim().replaceAll("^[sS][eE][tT]\\s+[nN][uU][lL][lL]\\s+", "").trim()).startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            } else if (string.startsWith("'") && string.endsWith("'") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            }
            scriptRunnerContext.putProperty("script.runner.setnull", string);
            NLSUtils.setNullDisplay(scriptRunnerContext.getCurrentConnection(), string);
        } else {
            scriptRunnerContext.removeProperty("script.runner.setnull");
            NLSUtils.setNullDisplay(scriptRunnerContext.getCurrentConnection(), null);
        }
        return true;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = null;
        string = scriptRunnerContext.getProperties().containsKey("script.runner.setnull") && scriptRunnerContext.getProperties().get("script.runner.setnull") != null ? "\"" + (String)scriptRunnerContext.getProperties().get("script.runner.setnull") + "\"" : "null";
        scriptRunnerContext.write("");
        scriptRunnerContext.write(MessageFormat.format(Messages.getString("SETNULL"), string) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"null"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

